/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin;

import android.support.annotation.NonNull;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.AppExtension;
import com.google.common.collect.ImmutableSet;
import com.google.firebase.perf.plugin.FirebasePerfExtension;
import com.google.firebase.perf.plugin.FirebasePerfPlugin;
import com.google.firebase.perf.plugin.instrumentation.Instrument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.slf4j.Logger;

public class FirebasePerfTransform
extends Transform {
    private static final Logger logger = FirebasePerfPlugin.getLogger();
    private final Project project;
    private final AppExtension androidExt;
    private final Set<QualifiedContent.ContentType> typeClasses;
    private final Set<QualifiedContent.Scope> scopes;
    private Instrument firebasePerfInstrumentation;
    private final Map<String, Object> params;
    private boolean instrumentationEnabled = true;

    public FirebasePerfTransform(Project project) {
        this.project = project;
        this.androidExt = (AppExtension)project.getExtensions().getByType(AppExtension.class);
        this.typeClasses = ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
        this.scopes = ImmutableSet.of((Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Object)QualifiedContent.Scope.PROJECT, (Object)QualifiedContent.Scope.SUB_PROJECTS);
        this.params = new HashMap<String, Object>();
        this.params.put("firebasePerformanceInstrumentationEnabled", this.instrumentationEnabled);
    }

    @NonNull
    public String getName() {
        return "FirebasePerformancePlugin";
    }

    @NonNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.typeClasses;
    }

    @NonNull
    public Set<QualifiedContent.Scope> getScopes() {
        return this.scopes;
    }

    public boolean isIncremental() {
        return true;
    }

    @NonNull
    public Map<String, Object> getParameterInputs() {
        FirebasePerfExtension perfExt = (FirebasePerfExtension)this.project.getExtensions().findByName("FirebasePerformance");
        Optional<Boolean> parsedPropVal = FirebasePerfPlugin.getProjectPropertyValue(this.project);
        if (parsedPropVal.isPresent()) {
            this.instrumentationEnabled = parsedPropVal.get();
            logger.info(String.format("Firebase Performance Instrumentation is %s per the project property specified in the 'gradle.properties' file.", this.instrumentationEnabled ? "enabled" : "disabled"));
        } else if (perfExt != null && perfExt.isInstrumentationEnabled().isPresent()) {
            this.instrumentationEnabled = perfExt.isInstrumentationEnabled().get();
            logger.info(String.format("Firebase Performance Instrumentation is %s per the extension value specified in the 'build.gradle' file.", this.instrumentationEnabled ? "enabled" : "disabled"));
        } else {
            logger.info(String.format("Firebase Performance Instrumentation is %s by default.", this.instrumentationEnabled ? "enabled" : "disabled"));
        }
        this.params.put("firebasePerformanceInstrumentationEnabled", this.instrumentationEnabled);
        return this.params;
    }

    public void transform(TransformInvocation invocation) throws IOException {
        Collection transformInputs = invocation.getInputs();
        Collection referencedInputs = invocation.getReferencedInputs();
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        boolean incremental = invocation.isIncremental();
        String string = String.valueOf(invocation.getContext().getVariantName());
        logger.info(string.length() != 0 ? "Executing transform for build variant: ".concat(string) : new String("Executing transform for build variant: "));
        List<URL> runtimeCP = this.buildRuntimeClasspath(transformInputs, referencedInputs);
        logger.debug("Effective app classpath at runtime:");
        for (URL url : runtimeCP) {
            String string2 = String.valueOf(url);
            logger.debug(new StringBuilder(2 + String.valueOf(string2).length()).append("- ").append(string2).toString());
        }
        try (URLClassLoader cl = new URLClassLoader(runtimeCP.toArray(new URL[0]), null);){
            logger.info(new StringBuilder(36).append("Transforming with incremental: ").append(incremental).toString());
            if (!incremental) {
                outputProvider.deleteAll();
            }
            this.firebasePerfInstrumentation = new Instrument(cl);
            for (TransformInput transformInput : transformInputs) {
                this.transformDirectoryInputs(transformInput, incremental, outputProvider);
                this.transformJarInputs(transformInput, incremental, outputProvider);
            }
        }
    }

    private void transformJarInputs(TransformInput transformInput, boolean incremental, TransformOutputProvider outputProvider) throws IOException {
        for (JarInput jarInput : transformInput.getJarInputs()) {
            boolean doXForm;
            String string = String.valueOf(jarInput);
            logger.debug(new StringBuilder(23 + String.valueOf(string).length()).append("Transforming JarInput: ").append(string).toString());
            String uniqueName = this.generateUniqueNameFor(jarInput);
            File outDir = outputProvider.getContentLocation(uniqueName, jarInput.getContentTypes(), jarInput.getScopes(), Format.DIRECTORY);
            String string2 = String.valueOf(jarInput.getFile());
            logger.debug(new StringBuilder(11 + String.valueOf(string2).length()).append("Jar input: ").append(string2).toString());
            string2 = String.valueOf(outDir);
            logger.debug(new StringBuilder(18 + String.valueOf(string2).length()).append("Directory output: ").append(string2).toString());
            boolean bl = doXForm = !incremental || Status.ADDED.equals((Object)jarInput.getStatus()) || Status.CHANGED.equals((Object)jarInput.getStatus());
            if (doXForm) {
                if (this.instrumentationEnabled) {
                    this.performTransformationFor(jarInput, outDir);
                    continue;
                }
                this.performDummyTransformationFor(jarInput, outputProvider.getContentLocation(uniqueName, jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR));
                continue;
            }
            if (Status.REMOVED.equals((Object)jarInput.getStatus())) {
                FileUtils.deleteQuietly((File)outDir);
                continue;
            }
            String string3 = String.valueOf(jarInput.getFile());
            logger.debug(new StringBuilder(23 + String.valueOf(string3).length()).append("Skipping transforming: ").append(string3).toString());
        }
    }

    private void transformDirectoryInputs(TransformInput transformInput, boolean incremental, TransformOutputProvider outputProvider) throws IOException {
        for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
            String string = String.valueOf(directoryInput);
            logger.debug(new StringBuilder(29 + String.valueOf(string).length()).append("Transforming DirectoryInput: ").append(string).toString());
            String uniqueName = this.generateUniqueNameFor(directoryInput);
            File outDir = outputProvider.getContentLocation(uniqueName, directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
            String string2 = String.valueOf(directoryInput.getFile());
            logger.debug(new StringBuilder(17 + String.valueOf(string2).length()).append("Directory input: ").append(string2).toString());
            string2 = String.valueOf(outDir);
            logger.debug(new StringBuilder(18 + String.valueOf(string2).length()).append("Directory output: ").append(string2).toString());
            if (!outDir.mkdirs() && !outDir.isDirectory()) continue;
            if (this.instrumentationEnabled) {
                this.performTransformationFor(directoryInput, outDir, incremental ? directoryInput.getChangedFiles() : null);
                continue;
            }
            this.performDummyTransformationFor(directoryInput, outDir);
        }
    }

    private List<URL> buildRuntimeClasspath(Collection<TransformInput> transformInputs, Collection<TransformInput> referencedInputs) {
        ArrayList<File> classPaths = new ArrayList<File>(this.androidExt.getBootClasspath());
        for (Collection transformInputCollection : Arrays.asList(transformInputs, referencedInputs)) {
            for (TransformInput transformInput : transformInputCollection) {
                List<Collection> allQualifiedContents = Arrays.asList(transformInput.getDirectoryInputs(), transformInput.getJarInputs());
                for (Collection qualifiedContentCollection : allQualifiedContents) {
                    for (QualifiedContent qualifiedContent : qualifiedContentCollection) {
                        classPaths.add(qualifiedContent.getFile());
                    }
                }
            }
        }
        return classPaths.stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                String string = String.valueOf(file);
                logger.error(new StringBuilder(42 + String.valueOf(string).length()).append("Unable to instrument classes due to file: ").append(string).toString());
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    private String generateUniqueNameFor(JarInput jarInput) {
        File jar = jarInput.getFile();
        String jarName = jar.getName();
        int lastIndex = jarName.lastIndexOf(46);
        if (lastIndex != -1) {
            String string = DigestUtils.md5Hex((String)jar.getPath());
            String string2 = jarName.substring(0, lastIndex);
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("-").append(string2).toString();
        }
        String string = DigestUtils.md5Hex((String)jar.getPath());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(jarName).length()).append(string).append("-").append(jarName).toString();
    }

    private String generateUniqueNameFor(DirectoryInput directoryInput) {
        return DigestUtils.md5Hex((String)directoryInput.getFile().getPath());
    }

    private void performTransformationFor(JarInput jarInput, File outDir) throws IOException {
        if (outDir.mkdirs() || outDir.isDirectory()) {
            this.firebasePerfInstrumentation.instrumentClassesInJar(jarInput.getFile(), outDir);
        }
    }

    private void performTransformationFor(DirectoryInput directoryInput, File outDir, Map<File, Status> changedFiles) throws IOException {
        String string = String.valueOf(outDir);
        this.firebasePerfInstrumentation.instrumentClassesInDir(directoryInput.getFile(), 0, new StringBuilder(1 + String.valueOf(string).length()).append(string).append("/").toString(), changedFiles);
    }

    private void performDummyTransformationFor(JarInput jarInput, File outJar) throws IOException {
        block11: {
            if (outJar.getParentFile().mkdirs() || outJar.getParentFile().isDirectory()) {
                try (FileInputStream fis = new FileInputStream(jarInput.getFile());
                     FileOutputStream fos = new FileOutputStream(outJar);){
                    IOUtils.copy((InputStream)fis, (OutputStream)fos);
                    break block11;
                }
            }
            String string = String.valueOf(outJar.getParentFile());
            throw new IOException(new StringBuilder(34 + String.valueOf(string).length()).append("Couldn't create transform output: ").append(string).toString());
        }
    }

    private void performDummyTransformationFor(DirectoryInput directoryInput, File outDir) throws IOException {
        FileUtils.deleteDirectory((File)outDir);
        FileUtils.copyDirectory((File)directoryInput.getFile(), (File)outDir);
    }
}

