/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.instrumentation;

import com.android.build.api.transform.Status;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.firebase.perf.plugin.FirebasePerfPlugin;
import com.google.firebase.perf.plugin.instrumentation.InstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.InstrumentationConfigFactory;
import com.google.firebase.perf.plugin.instrumentation.InstrumentationVisitor;
import com.google.firebase.perf.plugin.instrumentation.PerfInstrumentedAttribute;
import com.google.firebase.perf.plugin.instrumentation.exceptions.AlreadyPerfInstrumentedException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;

public class Instrument {
    private static final Logger logger = FirebasePerfPlugin.getLogger();
    private final InstrumentationConfig instrumentationConfig;

    public Instrument(ClassLoader classLoader) {
        this.instrumentationConfig = new InstrumentationConfigFactory(classLoader).newConfig();
    }

    public void instrumentClassesInDir(File dir, int depth, String outDir, Map<File, Status> changed) throws IOException {
        String[] names = dir.list();
        if (names == null) {
            throw new IOException("File list was unexpectedly null");
        }
        for (String name : names) {
            if (depth == 0 && name.equals("android")) {
                String string = String.valueOf(dir);
                logger.debug(new StringBuilder(9 + String.valueOf(string).length()).append("Copying: ").append(string).toString());
                FileUtils.copyDirectory((File)dir, (File)new File(outDir));
                continue;
            }
            File file = new File(dir, name);
            if (file.isDirectory()) {
                String string = file.getName();
                this.instrumentClassesInDir(file, ++depth, new StringBuilder(1 + String.valueOf(outDir).length() + String.valueOf(string).length()).append(outDir).append(string).append("/").toString(), changed);
                continue;
            }
            if (!name.endsWith(".class")) continue;
            String string = String.valueOf(outDir);
            String string2 = String.valueOf(name);
            this.instrumentClassFile(file, string2.length() != 0 ? string.concat(string2) : new String(string), changed);
        }
    }

    public void instrumentClassFile(File file, String outDir, Map<File, Status> changed) throws IOException {
        Status status;
        String string = String.valueOf(file);
        logger.debug(new StringBuilder(26 + String.valueOf(string).length()).append("Instrumenting class file: ").append(string).toString());
        File outFile = new File(outDir);
        outFile.getParentFile().mkdirs();
        outFile.createNewFile();
        if (changed != null && ((status = changed.get(file)) == null || status == Status.NOTCHANGED || status == Status.REMOVED)) {
            Files.copy((File)file, (File)outFile);
            return;
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        byte[] fileBytes = ByteStreams.toByteArray((InputStream)is);
        ((InputStream)is).close();
        try {
            byte[] out = this.instrument(fileBytes);
            try (FileOutputStream fos = new FileOutputStream(outFile);){
                fos.write(out);
            }
        }
        catch (AlreadyPerfInstrumentedException e) {
            logger.error("Already instrumented class");
        }
        catch (Exception e) {
            String string2 = String.valueOf(file);
            String string3 = e.getMessage();
            logger.error(new StringBuilder(20 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Can't instrument ").append(string2).append(" : ").append(string3).toString());
            e.printStackTrace();
            Files.copy((File)file, (File)outFile);
        }
    }

    public void instrumentClassesInJar(File inJarFile, File outDir) throws IOException {
        JarEntry inEntry;
        JarInputStream jis = new JarInputStream(new BufferedInputStream(new FileInputStream(inJarFile)));
        while ((inEntry = jis.getNextJarEntry()) != null) {
            String name = inEntry.getName();
            byte[] entryBytes = ByteStreams.toByteArray((InputStream)jis);
            jis.closeEntry();
            if (name.endsWith(".class") && this.checkIfInstrumentable(name)) {
                String string = String.valueOf(name);
                logger.debug(string.length() != 0 ? "Instrumenting ".concat(string) : new String("Instrumenting "));
                try {
                    entryBytes = this.instrument(entryBytes);
                }
                catch (Exception e) {
                    String string2 = String.valueOf(name);
                    logger.error(string2.length() != 0 ? "Can't instrument: ".concat(string2) : new String("Can't instrument: "));
                    e.printStackTrace();
                }
            } else {
                String string = String.valueOf(name);
                logger.debug(string.length() != 0 ? "Copying: ".concat(string) : new String("Copying: "));
            }
            if (inEntry.isDirectory()) continue;
            String string = String.valueOf(outDir);
            File outFile = new File(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(name).length()).append(string).append("/").append(name).toString());
            outFile.getParentFile().mkdirs();
            outFile.createNewFile();
            try (FileOutputStream fos = new FileOutputStream(outFile);){
                fos.write(entryBytes);
            }
        }
        jis.close();
    }

    public boolean checkIfInstrumentable(String name) {
        return !name.equals("android") && !name.startsWith("android/") && !name.startsWith("firebase/perf/") && !name.startsWith("com/google/firebase/") && !name.startsWith("com/google/firebase/perf/") && !name.startsWith("com/google/protobuf/") && !name.startsWith("com/google/android/apps/common/proguard/") && !name.startsWith("com/google/android/gms/") && !name.startsWith("com/google/common") && !name.startsWith("okhttp3/") && !name.startsWith("okio/");
    }

    public byte[] instrument(byte[] in) {
        ClassReader cr = new ClassReader(in);
        FirebasePerfClassWriter cw = new FirebasePerfClassWriter(3);
        cr.accept((ClassVisitor)new InstrumentationVisitor((ClassVisitor)cw, this.instrumentationConfig), new Attribute[]{new PerfInstrumentedAttribute("")}, 4);
        return cw.toByteArray();
    }

    private class FirebasePerfClassWriter
    extends ClassWriter {
        public FirebasePerfClassWriter(int flags) {
            super(flags);
        }

        public FirebasePerfClassWriter(ClassReader classReader, int flags) {
            super(classReader, flags);
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> class2;
            Class<?> class1;
            ClassLoader classLoader = Instrument.this.instrumentationConfig.getClassLoader();
            try {
                class1 = Class.forName(type1.replace('/', '.'), false, classLoader);
                class2 = Class.forName(type2.replace('/', '.'), false, classLoader);
            }
            catch (Throwable e) {
                logger.warn(e.toString());
                return "java/lang/Object";
            }
            if (class1.isAssignableFrom(class2)) {
                return type1;
            }
            if (class2.isAssignableFrom(class1)) {
                return type2;
            }
            if (class1.isInterface() || class2.isInterface()) {
                return "java/lang/Object";
            }
            while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
            }
            return class1.getName().replace('.', '/');
        }
    }
}

