/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.plugin.instrumentation;

import com.google.firebase.perf.plugin.FirebasePerfPlugin;
import com.google.firebase.perf.plugin.instrumentation.InstrumentationConfig;
import com.google.firebase.perf.plugin.instrumentation.InstrumentationContext;
import com.google.firebase.perf.plugin.instrumentation.PerfInstrumentedAttribute;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodAdapter;
import com.google.firebase.perf.plugin.instrumentation.annotation.AnnotatedMethodInstrumentationFactory;
import com.google.firebase.perf.plugin.instrumentation.exceptions.AlreadyPerfInstrumentedException;
import com.google.firebase.perf.plugin.instrumentation.model.AnnotationInfo;
import com.google.firebase.perf.plugin.instrumentation.model.ClassInfo;
import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentation;
import com.google.firebase.perf.plugin.instrumentation.network.NetworkObjectInstrumentationFactory;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.slf4j.Logger;

public class InstrumentationVisitor
extends ClassVisitor {
    private static final Logger logger = FirebasePerfPlugin.getLogger();
    private static final boolean LOG_VISITS = false;
    private static final boolean LOG_INSTRUMENTATION = true;
    private final ClassVisitor classVisitor;
    private final InstrumentationConfig instrConfig;
    private static final int ASM_API_VERSION = 458752;
    private final ClassInfo classInfo = new ClassInfo();
    private final InstrumentationContext instrContext = new InstrumentationContext();
    private boolean ending;

    public InstrumentationVisitor(ClassVisitor classVisitor, InstrumentationConfig instrConfig) {
        super(458752, classVisitor);
        this.classVisitor = classVisitor;
        this.instrConfig = instrConfig;
    }

    public void visit(int version, int access, String className, String signature, String superName, String[] interfaces) {
        super.visit(version, access, className, signature, superName, interfaces);
        this.classInfo.type = Type.getObjectType((String)className);
        this.classInfo.interfaces = interfaces;
        this.instrContext.classMap.put("name", this.classInfo.type.getClassName());
    }

    public void visitOuterClass(String owner, String className, String classDesc) {
        super.visitOuterClass(owner, className, classDesc);
    }

    public AnnotationVisitor visitAnnotation(String classDesc, boolean visible) {
        AnnotationInfo annotationInfo = new AnnotationInfo();
        annotationInfo.type = Type.getType((String)classDesc);
        this.classInfo.annotations.add(annotationInfo);
        AnnotationVisitor annotationVisitor = super.visitAnnotation(classDesc, visible);
        return new FirebasePerfAnnotationVisitor(this, 458752, annotationVisitor, annotationInfo);
    }

    public void visitAttribute(Attribute attribute) {
        super.visitAttribute(attribute);
        if (!this.ending && attribute instanceof PerfInstrumentedAttribute) {
            throw new AlreadyPerfInstrumentedException();
        }
    }

    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        this.instrContext.methodMap.clear();
        MethodVisitor rootMethodVisitor = this.classVisitor.visitMethod(access, methodName, methodDesc, signature, exceptions);
        return new FirebasePerfMethodVisitor(this.classInfo.type.getDescriptor(), 458752, rootMethodVisitor, access, methodName, methodDesc, this.instrConfig);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public void visitEnd() {
        this.ending = true;
        this.visitAttribute(new PerfInstrumentedAttribute("instrumented"));
        super.visitEnd();
    }

    private class FirebasePerfAnnotationVisitor
    extends AnnotationVisitor {
        private final AnnotationInfo annotationInfo;

        public FirebasePerfAnnotationVisitor(InstrumentationVisitor instrumentationVisitor, int api, AnnotationVisitor annotationVisitor, AnnotationInfo annotationInfo) {
            super(api, annotationVisitor);
            this.annotationInfo = annotationInfo;
        }

        public void visit(String name, Object value) {
            this.annotationInfo.values.put(name, value);
            super.visit(name, value);
        }
    }

    private class FirebasePerfMethodVisitor
    extends AdviceAdapter {
        private final InstrumentationConfig instrConfig;
        private final String perfClassDesc;
        private final String perfMethodName;
        private final String perfMethodDesc;
        private final List<AnnotatedMethodAdapter> annotatedMethodAdapters;

        protected FirebasePerfMethodVisitor(String perfClassDesc, int api, MethodVisitor methodVisitor, int access, String perfMethodName, String perfMethodDesc, InstrumentationConfig instrConfig) {
            super(api, methodVisitor, access, perfMethodName, perfMethodDesc);
            this.annotatedMethodAdapters = new ArrayList<AnnotatedMethodAdapter>();
            this.instrConfig = instrConfig;
            this.perfClassDesc = perfClassDesc;
            this.perfMethodName = perfMethodName;
            this.perfMethodDesc = perfMethodDesc;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            AnnotationVisitor annotationVisitor = super.visitAnnotationDefault();
            AnnotationInfo annotationInfo = new AnnotationInfo();
            return new FirebasePerfAnnotationVisitor(InstrumentationVisitor.this, 458752, annotationVisitor, annotationInfo);
        }

        public AnnotationVisitor visitAnnotation(String classDesc, boolean visible) {
            AnnotationVisitor annotationVisitor = super.visitAnnotation(classDesc, visible);
            AnnotationInfo annotationInfo = new AnnotationInfo();
            annotationVisitor = new FirebasePerfAnnotationVisitor(InstrumentationVisitor.this, 458752, annotationVisitor, annotationInfo);
            List<AnnotatedMethodInstrumentationFactory> annotatedMethodFactoryList = this.instrConfig.getAnnotatedMethodInstrumentationFactories(classDesc);
            if (annotatedMethodFactoryList != null) {
                String string = this.perfClassDesc;
                String string2 = this.perfMethodName;
                String string3 = this.perfMethodDesc;
                logger.debug(new StringBuilder(62 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Instrumenting annotation: ").append(string).append(", perfMethodName: ").append(string2).append(", perfMethodDesc: ").append(string3).toString());
                for (AnnotatedMethodInstrumentationFactory annotatedMethodFactory : annotatedMethodFactoryList) {
                    this.annotatedMethodAdapters.add(annotatedMethodFactory.newAnnotatedMethodInstrumentation(InstrumentationVisitor.this.instrContext, this, annotationInfo, this.perfMethodName, this.perfMethodDesc));
                }
            }
            return annotationVisitor;
        }

        protected void onMethodEnter() {
            super.onMethodEnter();
            for (AnnotatedMethodAdapter annotationInstr : this.annotatedMethodAdapters) {
                String string = this.perfClassDesc;
                String string2 = this.perfMethodName;
                String string3 = this.perfMethodDesc;
                logger.debug(new StringBuilder(70 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Apply annotation instrumentation: ").append(string).append(", perfMethodName: ").append(string2).append(", perfMethodDesc: ").append(string3).toString());
                annotationInstr.onMethodEnter();
            }
        }

        protected void onMethodExit(int opcode) {
            super.onMethodExit(opcode);
            for (AnnotatedMethodAdapter annotationInstr : this.annotatedMethodAdapters) {
                annotationInstr.onMethodExit();
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            NetworkObjectInstrumentationFactory networkObjectFactory = this.instrConfig.getNetworkObjectInstrumentationFactory(owner, name, desc);
            NetworkObjectInstrumentation networkObjectInstr = null;
            if (networkObjectFactory != null) {
                networkObjectInstr = networkObjectFactory.newObjectInstrumentation(owner, name, desc);
                String string = String.valueOf(networkObjectInstr);
                logger.debug(new StringBuilder(57 + String.valueOf(owner).length() + String.valueOf(name).length() + String.valueOf(desc).length() + String.valueOf(string).length()).append("Instrumenting return obj [owner: ").append(owner).append(", name: ").append(name).append(", desc: ").append(desc).append("] with: ").append(string).toString());
            }
            if (networkObjectInstr != null) {
                networkObjectInstr.injectBefore(this.mv);
                if (!networkObjectInstr.replaceMethod(this.mv, opcode)) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
                networkObjectInstr.injectAfter(this.mv);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }
}

