/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Requirement;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

@Immutable
public final class AlgorithmFamily
implements JSONAware {
    private final String name;
    private final Requirement requirement;
    public static final AlgorithmFamily EC = new AlgorithmFamily("EC", Requirement.RECOMMENDED);
    public static final AlgorithmFamily RSA = new AlgorithmFamily("RSA", Requirement.REQUIRED);

    public AlgorithmFamily(String name, Requirement req) {
        if (name == null) {
            throw new IllegalArgumentException("The algorithm family name must not be null");
        }
        this.name = name;
        this.requirement = req;
    }

    public String getName() {
        return this.name;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof AlgorithmFamily && this.toString().equals(object.toString());
    }

    public String toString() {
        return this.name;
    }

    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(JSONObject.escape((String)this.name));
        sb.append('\"');
        return sb.toString();
    }

    public static AlgorithmFamily parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("The algorithm family string must not be null");
        }
        if (s.equals(EC.getName())) {
            return EC;
        }
        if (s.equals(RSA.getName())) {
            return RSA;
        }
        return new AlgorithmFamily(s, null);
    }
}

