/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.Requirement;
import net.jcip.annotations.Immutable;

@Immutable
public final class JWEAlgorithm
extends Algorithm {
    public static final JWEAlgorithm RSA1_5 = new JWEAlgorithm("RSA1_5", Requirement.REQUIRED);
    public static final JWEAlgorithm RSA_OAEP = new JWEAlgorithm("RSA-OAEP", Requirement.RECOMMENDED);
    public static final JWEAlgorithm A128KW = new JWEAlgorithm("A128KW", Requirement.RECOMMENDED);
    public static final JWEAlgorithm A256KW = new JWEAlgorithm("A256KW", Requirement.RECOMMENDED);
    public static final JWEAlgorithm DIR = new JWEAlgorithm("dir", Requirement.RECOMMENDED);
    public static final JWEAlgorithm ECDH_ES = new JWEAlgorithm("ECDH-ES", Requirement.RECOMMENDED);
    public static final JWEAlgorithm ECDH_ES_A128KW = new JWEAlgorithm("ECDH-ES+A128KW", Requirement.RECOMMENDED);
    public static final JWEAlgorithm ECDH_ES_A256KW = new JWEAlgorithm("ECDH-ES+A256KW", Requirement.RECOMMENDED);

    public JWEAlgorithm(String name, Requirement req) {
        super(name, req);
    }

    public JWEAlgorithm(String name) {
        super(name, null);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof JWEAlgorithm && this.toString().equals(object.toString());
    }

    public static JWEAlgorithm parse(String s) {
        if (s == RSA1_5.getName()) {
            return RSA1_5;
        }
        if (s == RSA_OAEP.getName()) {
            return RSA_OAEP;
        }
        if (s == A128KW.getName()) {
            return A128KW;
        }
        if (s == A256KW.getName()) {
            return A256KW;
        }
        if (s == DIR.getName()) {
            return DIR;
        }
        if (s == ECDH_ES.getName()) {
            return ECDH_ES;
        }
        if (s == ECDH_ES_A128KW.getName()) {
            return ECDH_ES_A128KW;
        }
        if (s == ECDH_ES_A256KW.getName()) {
            return ECDH_ES_A256KW;
        }
        return new JWEAlgorithm(s);
    }
}

