/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.Requirement;
import net.jcip.annotations.Immutable;

@Immutable
public final class JWSAlgorithm
extends Algorithm {
    public static final JWSAlgorithm HS256 = new JWSAlgorithm("HS256", Requirement.REQUIRED);
    public static final JWSAlgorithm HS384 = new JWSAlgorithm("HS384", Requirement.OPTIONAL);
    public static final JWSAlgorithm HS512 = new JWSAlgorithm("HS512", Requirement.OPTIONAL);
    public static final JWSAlgorithm RS256 = new JWSAlgorithm("RS256", Requirement.RECOMMENDED);
    public static final JWSAlgorithm RS384 = new JWSAlgorithm("RS384", Requirement.OPTIONAL);
    public static final JWSAlgorithm RS512 = new JWSAlgorithm("RS512", Requirement.OPTIONAL);
    public static final JWSAlgorithm ES256 = new JWSAlgorithm("ES256", Requirement.RECOMMENDED);
    public static final JWSAlgorithm ES384 = new JWSAlgorithm("ES384", Requirement.OPTIONAL);
    public static final JWSAlgorithm ES512 = new JWSAlgorithm("ES512", Requirement.OPTIONAL);

    public JWSAlgorithm(String name, Requirement req) {
        super(name, req);
    }

    public JWSAlgorithm(String name) {
        super(name, null);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof JWSAlgorithm && this.toString().equals(object.toString());
    }

    public static JWSAlgorithm parse(String s) {
        if (s == HS256.getName()) {
            return HS256;
        }
        if (s == HS384.getName()) {
            return HS384;
        }
        if (s == HS512.getName()) {
            return HS512;
        }
        if (s == RS256.getName()) {
            return RS256;
        }
        if (s == RS384.getName()) {
            return RS384;
        }
        if (s == RS512.getName()) {
            return RS512;
        }
        if (s == ES256.getName()) {
            return ES256;
        }
        if (s == ES384.getName()) {
            return ES384;
        }
        if (s == ES512.getName()) {
            return ES512;
        }
        return new JWSAlgorithm(s);
    }
}

