/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeaderFilter;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.ReadOnlyJWSHeader;
import com.nimbusds.jose.crypto.DefaultJWSHeaderFilter;
import com.nimbusds.jose.crypto.ECDSAParameters;
import com.nimbusds.jose.crypto.ECDSAProvider;
import com.nimbusds.jose.util.Base64URL;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

@ThreadSafe
public class ECDSAVerifier
extends ECDSAProvider
implements JWSVerifier {
    private static final Set<String> ACCEPTED_HEADER_PARAMETERS;
    private DefaultJWSHeaderFilter headerFilter;
    private final BigInteger x;
    private final BigInteger y;

    public ECDSAVerifier(BigInteger x, BigInteger y) {
        if (x == null) {
            throw new IllegalArgumentException("The \"x\" EC coordinate must not be null");
        }
        this.x = x;
        if (y == null) {
            throw new IllegalArgumentException("The \"y\" EC coordinate must not be null");
        }
        this.y = y;
        this.headerFilter = new DefaultJWSHeaderFilter(this.supportedAlgorithms(), ACCEPTED_HEADER_PARAMETERS);
    }

    public BigInteger getX() {
        return this.x;
    }

    public BigInteger getY() {
        return this.y;
    }

    @Override
    public JWSHeaderFilter getJWSHeaderFilter() {
        return this.headerFilter;
    }

    @Override
    public boolean verify(ReadOnlyJWSHeader header, byte[] signedContent, Base64URL signature) throws JOSEException {
        ECDSAParameters initParams = ECDSAVerifier.getECDSAParameters(header.getAlgorithm());
        X9ECParameters x9ECParameters = initParams.getX9ECParameters();
        Digest digest = initParams.getDigest();
        byte[] signatureBytes = signature.decode();
        byte[] rBytes = new byte[32];
        byte[] sBytes = new byte[32];
        try {
            System.arraycopy(signatureBytes, 0, rBytes, 0, 32);
            System.arraycopy(signatureBytes, 32, sBytes, 0, 32);
        }
        catch (Exception e) {
            throw new JOSEException("Invalid ECDSA signature format: " + e.getMessage(), e);
        }
        BigInteger r = new BigInteger(1, rBytes);
        BigInteger s = new BigInteger(1, sBytes);
        ECCurve curve = x9ECParameters.getCurve();
        ECPoint qB = curve.createPoint(this.x, this.y, false);
        ECPoint.Fp q = new ECPoint.Fp(curve, qB.getX(), qB.getY());
        ECDomainParameters ecDomainParameters = new ECDomainParameters(curve, x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters((ECPoint)q, ecDomainParameters);
        ECDSASigner verifier = new ECDSASigner();
        verifier.init(false, (CipherParameters)ecPublicKeyParameters);
        digest.update(signedContent, 0, signedContent.length);
        byte[] out = new byte[digest.getDigestSize()];
        digest.doFinal(out, 0);
        return verifier.verifySignature(out, r, s);
    }

    static {
        HashSet<String> params = new HashSet<String>();
        params.add("alg");
        params.add("typ");
        params.add("cty");
        ACCEPTED_HEADER_PARAMETERS = params;
    }
}

