/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeaderFilter;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.ReadOnlyJWSHeader;
import com.nimbusds.jose.crypto.DefaultJWSHeaderFilter;
import com.nimbusds.jose.crypto.RSASSAProvider;
import com.nimbusds.jose.util.Base64URL;
import java.security.InvalidKeyException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSASSAVerifier
extends RSASSAProvider
implements JWSVerifier {
    private static final Set<String> ACCEPTED_HEADER_PARAMETERS;
    private DefaultJWSHeaderFilter headerFilter;
    private final RSAPublicKey publicKey;

    public RSASSAVerifier(RSAPublicKey publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("The public RSA key must not be null");
        }
        this.publicKey = publicKey;
        this.headerFilter = new DefaultJWSHeaderFilter(this.supportedAlgorithms(), ACCEPTED_HEADER_PARAMETERS);
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public JWSHeaderFilter getJWSHeaderFilter() {
        return this.headerFilter;
    }

    @Override
    public boolean verify(ReadOnlyJWSHeader header, byte[] signedContent, Base64URL signature) throws JOSEException {
        Signature verifier = RSASSAVerifier.getRSASignerAndVerifier(header.getAlgorithm());
        try {
            verifier.initVerify(this.publicKey);
            verifier.update(signedContent);
            return verifier.verify(signature.decode());
        }
        catch (InvalidKeyException e) {
            throw new JOSEException("Invalid public RSA key: " + e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new JOSEException("RSA signature exception: " + e.getMessage(), e);
        }
    }

    static {
        HashSet<String> params = new HashSet<String>();
        params.add("alg");
        params.add("typ");
        params.add("cty");
        ACCEPTED_HEADER_PARAMETERS = params;
    }
}

