/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util;

import com.twitter.util.Duration;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.TimeControl;
import com.twitter.util.TimeFormat;
import com.twitter.util.TimeOverflowException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Time$
implements ScalaObject {
    public static final Time$ MODULE$;
    private final TimeFormat com$twitter$util$Time$$defaultFormat;
    private final TimeFormat rssFormat;
    private final long nanoTimeOffset;
    private Function0<Time> fn;
    private final Time epoch;

    static {
        new Time$();
    }

    public final TimeFormat com$twitter$util$Time$$defaultFormat() {
        return this.com$twitter$util$Time$$defaultFormat;
    }

    private TimeFormat rssFormat() {
        return this.rssFormat;
    }

    public long nanoTimeOffset() {
        return this.nanoTimeOffset;
    }

    public Function0<Time> fn() {
        return this.fn;
    }

    public void fn_$eq(Function0<Time> function0) {
        this.fn = function0;
    }

    public Time apply(long millis) {
        return this.fromMilliseconds(millis);
    }

    public Time fromMilliseconds(long millis) {
        long nanos = TimeUnit.MILLISECONDS.toNanos(millis);
        if (nanos == Long.MAX_VALUE && millis != Long.MAX_VALUE) {
            throw new TimeOverflowException(((Object)BoxesRunTime.boxToLong((long)millis)).toString());
        }
        if (nanos == Long.MIN_VALUE) {
            throw new TimeOverflowException(((Object)BoxesRunTime.boxToLong((long)millis)).toString());
        }
        return new Time(nanos);
    }

    public Time fromSeconds(int seconds) {
        return this.fromMilliseconds(1000L * (long)seconds);
    }

    public Time fromNanoseconds(long nanoseconds) {
        return new Time(nanoseconds);
    }

    public Time now() {
        return (Time)this.fn().apply();
    }

    public Time epoch() {
        return this.epoch;
    }

    public Time apply(Date date) {
        return this.fromMilliseconds(date.getTime());
    }

    public Time at(String datetime) {
        return this.com$twitter$util$Time$$defaultFormat().parse(datetime);
    }

    public <A> A withTimeFunction(Function0<Time> timeFunction, Function1<TimeControl, A> body) {
        Function0<Time> prevFn = this.fn();
        Object exceptionResult1 = null;
        try {
            anon.1 timeControl = new anon.1();
            this.fn_$eq(timeFunction);
            exceptionResult1 = body.apply((Object)timeControl);
            return (A)exceptionResult1;
        }
        finally {
            this.fn_$eq(prevFn);
        }
    }

    public <A> A withTimeAt(Time time$2, Function1<TimeControl, A> body) {
        return this.withTimeFunction((Function0<Time>)new anonfun.withTimeAt.1(time$2), body);
    }

    public <A> A withCurrentTimeFrozen(Function1<TimeControl, A> body) {
        return this.withTimeAt(this.now(), body);
    }

    public Duration measure(Function0<Object> f) {
        Time start = this.now();
        f.apply$mcV$sp();
        Time end = this.now();
        return end.$minus(start);
    }

    public Duration measureMany(int n$1, Function0<Object> f$1) {
        Predef$.MODULE$.require(n$1 > 0);
        Duration d = this.measure((Function0<Object>)new anonfun.1(n$1, f$1));
        return d.$div(n$1);
    }

    public Time fromRss(String rss) {
        return this.rssFormat().parse(rss);
    }

    private Time$() {
        MODULE$ = this;
        this.com$twitter$util$Time$$defaultFormat = new TimeFormat("yyyy-MM-dd HH:mm:ss Z");
        this.rssFormat = new TimeFormat("E, dd MMM yyyy HH:mm:ss Z");
        this.nanoTimeOffset = System.currentTimeMillis() * 1000000L - System.nanoTime();
        this.fn = new anonfun.2();
        this.epoch = this.fromMilliseconds(0L);
    }
}

