/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.mojo.flexmojo.compiler;

import flex2.tools.oem.Library;
import flex2.tools.oem.Logger;
import info.flexmojos.compatibilitykit.FlexCompatibility;
import info.flexmojos.compatibilitykit.FlexCompatibilityAspect;
import info.flexmojos.utilities.PathUtil;
import info.rvin.flexmojos.utilities.MavenUtils;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo;
import info.rvin.mojo.flexmojo.compiler.CompileLogger;
import info.rvin.mojo.flexmojo.compiler.LibraryMojo$AjcClosure1;
import info.rvin.mojo.flexmojo.compiler.LibraryMojo$AjcClosure3;
import info.rvin.mojo.flexmojo.compiler.MavenArtifact;
import info.rvin.mojo.flexmojo.compiler.Stylesheet;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryMojo
extends AbstractFlexCompilerMojo<Library> {
    private boolean computeDigest;
    private String[] includeClasses;
    private String[] includeFiles;
    private String[] includeNamespaces;
    private String[] includeResourceBundles;
    private MavenArtifact[] includeResourceBundlesArtifact;
    protected File[] includeSources;
    private File directory;
    private Stylesheet[] includeStylesheet;
    private boolean debug;
    private boolean addMavenDescriptor;
    private File output;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Override
    public void setUp() throws MojoExecutionException, MojoFailureException {
        int n;
        int n2;
        Object[] objectArray;
        this.builder = new Library();
        if (this.directory != null) {
            ((Library)this.builder).setDirectory(this.directory);
        }
        super.setUp();
        ((Library)this.builder).setOutput(this.getOutput());
        if (this.checkNullOrEmpty(this.includeClasses) && this.checkNullOrEmpty(this.includeFiles) && this.checkNullOrEmpty(this.includeNamespaces) && this.checkNullOrEmpty(this.includeResourceBundles) && this.checkNullOrEmpty(this.includeResourceBundlesArtifact) && this.checkNullOrEmpty(this.includeSources) && this.checkNullOrEmpty(this.includeStylesheet)) {
            this.getLog().warn((CharSequence)"Nothing expecified to include.  Assuming source and resources folders.");
            ArrayList sourcePaths = new ArrayList(Arrays.asList(this.sourcePaths));
            sourcePaths.remove(new File(this.resourceBundlePath));
            this.includeSources = sourcePaths.toArray(new File[0]);
            this.includeFiles = this.listAllResources();
        }
        if (!this.checkNullOrEmpty(this.includeClasses)) {
            objectArray = this.includeClasses;
            n2 = 0;
            n = objectArray.length;
            while (n2 < n) {
                String asClass = objectArray[n2];
                ((Library)this.builder).addComponent(asClass);
                ++n2;
            }
        }
        if (!this.checkNullOrEmpty(this.includeFiles)) {
            objectArray = this.includeFiles;
            n2 = 0;
            n = objectArray.length;
            while (n2 < n) {
                String includeFile = objectArray[n2];
                if (includeFile == null) {
                    throw new MojoFailureException("Cannot include a null file");
                }
                File file = MavenUtils.resolveResourceFile((MavenProject)this.project, (String)includeFile);
                File folder = this.getResourceFolder(file);
                String relativePath = PathUtil.getRelativePath((File)folder, (File)file);
                if (relativePath.startsWith("..")) {
                    relativePath = file.getName();
                }
                ((Library)this.builder).addArchiveFile(relativePath.replace('\\', '/'), file);
                ++n2;
            }
        }
        if (!this.checkNullOrEmpty(this.includeNamespaces)) {
            objectArray = this.includeNamespaces;
            n2 = 0;
            n = objectArray.length;
            while (n2 < n) {
                String uri = objectArray[n2];
                try {
                    ((Library)this.builder).addComponent(new URI(uri));
                }
                catch (URISyntaxException e) {
                    throw new MojoExecutionException("Invalid URI " + uri, (Exception)e);
                }
                ++n2;
            }
        }
        if (!this.checkNullOrEmpty(this.includeResourceBundles)) {
            objectArray = this.includeResourceBundles;
            n2 = 0;
            n = objectArray.length;
            while (n2 < n) {
                Object rb = objectArray[n2];
                ((Library)this.builder).addResourceBundle((String)rb);
                ++n2;
            }
        }
        if (!this.checkNullOrEmpty(this.includeResourceBundlesArtifact)) {
            objectArray = this.includeResourceBundlesArtifact;
            n2 = 0;
            n = objectArray.length;
            while (n2 < n) {
                String[] bundles;
                String bundleFile;
                Object mvnArtifact = objectArray[n2];
                Artifact artifact = this.artifactFactory.createArtifactWithClassifier(((MavenArtifact)mvnArtifact).getGroupId(), ((MavenArtifact)mvnArtifact).getArtifactId(), ((MavenArtifact)mvnArtifact).getVersion(), "properties", "resource-bundle");
                MavenUtils.resolveArtifact((Artifact)artifact, (ArtifactResolver)this.resolver, (ArtifactRepository)this.localRepository, (List)this.remoteRepositories);
                try {
                    bundleFile = FileUtils.readFileToString((File)artifact.getFile());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Ocorreu um erro ao ler o artefato " + artifact, (Exception)e);
                }
                String[] stringArray = bundles = bundleFile.split(" ");
                int n3 = 0;
                int n4 = stringArray.length;
                while (n3 < n4) {
                    String bundle = stringArray[n3];
                    ((Library)this.builder).addResourceBundle(bundle);
                    ++n3;
                }
                ++n2;
            }
        }
        if (!this.checkNullOrEmpty(this.includeSources)) {
            objectArray = this.includeSources;
            n2 = 0;
            n = objectArray.length;
            while (n2 < n) {
                Object file = objectArray[n2];
                if (file == null) {
                    throw new MojoFailureException("Cannot include a null file");
                }
                if (!((File)file).getName().contains("{locale}") && !((File)file).exists()) {
                    throw new MojoFailureException("File " + ((File)file).getName() + " not found");
                }
                ((Library)this.builder).addComponent((File)file);
                ++n2;
            }
        }
        LibraryMojo libraryMojo = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)libraryMojo));
        Object[] objectArray2 = new Object[]{this, libraryMojo, joinPoint};
        FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new LibraryMojo$AjcClosure1(objectArray2), joinPoint);
        LibraryMojo libraryMojo2 = this;
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)libraryMojo2));
        Object[] objectArray3 = new Object[]{this, libraryMojo2, joinPoint2};
        FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new LibraryMojo$AjcClosure3(objectArray3), joinPoint2);
        if (this.addMavenDescriptor) {
            ((Library)this.builder).addArchiveFile("maven/" + this.project.getGroupId() + "/" + this.project.getArtifactId() + "/pom.xml", new File(this.project.getBasedir(), "pom.xml"));
        }
    }

    private String[] listAllResources() {
        ArrayList<String> resources = new ArrayList<String>();
        List resourcesDirs = this.project.getResources();
        for (Resource resource : resourcesDirs) {
            File resourceDir = new File(resource.getDirectory());
            if (!resourceDir.exists()) continue;
            Collection files = FileUtils.listFiles((File)resourceDir, (IOFileFilter)HiddenFileFilter.VISIBLE, (IOFileFilter)TrueFileFilter.INSTANCE);
            for (File file : files) {
                resources.add(file.getAbsolutePath());
            }
        }
        return resources.toArray(new String[resources.size()]);
    }

    @FlexCompatibility(minVersion="3")
    private void computeDigest() {
        this.configuration.enableDigestComputation(this.computeDigest);
    }

    @FlexCompatibility(minVersion="3")
    private void includeStylesheet() throws MojoExecutionException {
        if (!this.checkNullOrEmpty(this.includeStylesheet)) {
            Stylesheet[] stylesheetArray = this.includeStylesheet;
            int n = 0;
            int n2 = stylesheetArray.length;
            while (n < n2) {
                Stylesheet sheet = stylesheetArray[n];
                if (!sheet.getPath().exists()) {
                    throw new MojoExecutionException("Stylesheet not found: " + sheet.getPath());
                }
                ((Library)this.builder).addStyleSheet(sheet.getName(), sheet.getPath());
                ++n;
            }
        }
    }

    private File getResourceFolder(File file) {
        String absolutePath = file.getAbsolutePath();
        File[] fileArray = this.sourcePaths;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File sourcePath = fileArray[n];
            if (absolutePath.startsWith(sourcePath.getAbsolutePath())) {
                return sourcePath;
            }
            ++n;
        }
        List sourceRoots = this.project.getExecutionProject() != null ? this.project.getExecutionProject().getCompileSourceRoots() : this.project.getCompileSourceRoots();
        for (String sourcePath : sourceRoots) {
            if (!absolutePath.startsWith(sourcePath)) continue;
            return new File(sourcePath);
        }
        for (Resource resource : this.project.getResources()) {
            if (!absolutePath.startsWith(resource.getDirectory())) continue;
            return new File(resource.getDirectory());
        }
        return this.project.getBasedir();
    }

    private boolean checkNullOrEmpty(Object[] array) {
        if (array == null) {
            return true;
        }
        if (array.length == 0) {
            return false;
        }
        return false;
    }

    @Override
    protected void writeResourceBundle(String[] bundles, String locale, File localePath) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Generating resource-bundle for " + locale));
        Library localized = new Library();
        localized.setConfiguration(this.configuration);
        this.configuration.setLibraryPath(new File[0]);
        localized.setLogger((Logger)new CompileLogger(this.getLog()));
        this.configuration.addLibraryPath(new File[]{this.getOutput()});
        this.setLocales(locale);
        this.configuration.setSourcePath(new File[]{localePath});
        String[] stringArray = bundles;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String bundle = stringArray[n];
            localized.addResourceBundle(bundle);
            ++n;
        }
        this.configuration.addLibraryPath(this.getResourcesBundles(locale));
        File output = new File(this.build.getDirectory(), String.valueOf(this.build.getFinalName()) + "-" + locale + ".rb.swc");
        localized.setOutput(output);
        this.build(localized);
        this.projectHelper.attachArtifact(this.project, "resource-bundle", locale, output);
    }

    @Override
    protected boolean isDebug() {
        return this.debug;
    }

    @Override
    protected boolean isApplication() {
        return false;
    }

    @Override
    protected String getDefaultLocale() {
        throw new UnsupportedOperationException("Default locale is not available to Libraries");
    }

    @Override
    protected File getOutput() {
        return this.output;
    }

    static {
        Factory factory = new Factory("LibraryMojo.java", Class.forName("info.rvin.mojo.flexmojo.compiler.LibraryMojo"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "includeStylesheet", "info.rvin.mojo.flexmojo.compiler.LibraryMojo", "", "", "org.apache.maven.plugin.MojoExecutionException:", "void"), 335);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "computeDigest", "info.rvin.mojo.flexmojo.compiler.LibraryMojo", "", "", "", "void"), 337);
    }

    static final /* synthetic */ void includeStylesheet_aroundBody0(LibraryMojo libraryMojo, LibraryMojo libraryMojo2, JoinPoint joinPoint) {
        libraryMojo2.includeStylesheet();
    }

    static final /* synthetic */ void computeDigest_aroundBody2(LibraryMojo libraryMojo, LibraryMojo libraryMojo2, JoinPoint joinPoint) {
        libraryMojo2.computeDigest();
    }
}

