/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.alts.internal.AltsChannelCrypter;
import io.grpc.alts.internal.AltsClientOptions;
import io.grpc.alts.internal.AltsHandshakerOptions;
import io.grpc.alts.internal.AltsHandshakerStub;
import io.grpc.alts.internal.Handshaker;
import io.grpc.alts.internal.HandshakerServiceGrpc;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;

class AltsHandshakerClient {
    private static final Logger logger = Logger.getLogger(AltsHandshakerClient.class.getName());
    private static final String APPLICATION_PROTOCOL = "grpc";
    private static final String RECORD_PROTOCOL = "ALTSRP_GCM_AES128_REKEY";
    private static final int KEY_LENGTH = AltsChannelCrypter.getKeyLength();
    private final AltsHandshakerStub handshakerStub;
    private final AltsHandshakerOptions handshakerOptions;
    private Handshaker.HandshakerResult result;
    private Handshaker.HandshakerStatus status;

    AltsHandshakerClient(HandshakerServiceGrpc.HandshakerServiceStub stub, AltsHandshakerOptions options) {
        this.handshakerStub = new AltsHandshakerStub(stub);
        this.handshakerOptions = options;
    }

    @VisibleForTesting
    AltsHandshakerClient(AltsHandshakerStub handshakerStub, AltsHandshakerOptions options) {
        this.handshakerStub = handshakerStub;
        this.handshakerOptions = options;
    }

    static String getApplicationProtocol() {
        return APPLICATION_PROTOCOL;
    }

    static String getRecordProtocol() {
        return RECORD_PROTOCOL;
    }

    private void setStartClientFields(Handshaker.HandshakerReq.Builder req) {
        Handshaker.StartClientHandshakeReq.Builder startClientReq = Handshaker.StartClientHandshakeReq.newBuilder().setHandshakeSecurityProtocol(Handshaker.HandshakeProtocol.ALTS).addApplicationProtocols(APPLICATION_PROTOCOL).addRecordProtocols(RECORD_PROTOCOL);
        if (this.handshakerOptions.getRpcProtocolVersions() != null) {
            startClientReq.setRpcVersions(this.handshakerOptions.getRpcProtocolVersions());
        }
        if (this.handshakerOptions instanceof AltsClientOptions) {
            AltsClientOptions clientOptions = (AltsClientOptions)this.handshakerOptions;
            if (!Strings.isNullOrEmpty((String)clientOptions.getTargetName())) {
                startClientReq.setTargetName(clientOptions.getTargetName());
            }
            for (String serviceAccount : clientOptions.getTargetServiceAccounts()) {
                startClientReq.addTargetIdentitiesBuilder().setServiceAccount(serviceAccount);
            }
        }
        req.setClientStart(startClientReq);
    }

    private void setStartServerFields(Handshaker.HandshakerReq.Builder req, ByteBuffer inBytes) {
        Handshaker.ServerHandshakeParameters serverParameters = Handshaker.ServerHandshakeParameters.newBuilder().addRecordProtocols(RECORD_PROTOCOL).build();
        Handshaker.StartServerHandshakeReq.Builder startServerReq = Handshaker.StartServerHandshakeReq.newBuilder().addApplicationProtocols(APPLICATION_PROTOCOL).putHandshakeParameters(Handshaker.HandshakeProtocol.ALTS.getNumber(), serverParameters).setInBytes(ByteString.copyFrom((ByteBuffer)inBytes.duplicate()));
        if (this.handshakerOptions.getRpcProtocolVersions() != null) {
            startServerReq.setRpcVersions(this.handshakerOptions.getRpcProtocolVersions());
        }
        req.setServerStart(startServerReq);
    }

    public boolean isFinished() {
        if (this.result != null) {
            return true;
        }
        return this.status != null && this.status.getCode() != Status.Code.OK.value();
    }

    public Handshaker.HandshakerStatus getStatus() {
        return this.status;
    }

    public Handshaker.HandshakerResult getResult() {
        return this.result;
    }

    public byte[] getKey() {
        if (this.result == null) {
            return null;
        }
        if (this.result.getKeyData().size() < KEY_LENGTH) {
            throw new IllegalStateException("Could not get enough key data from the handshake.");
        }
        byte[] key = new byte[KEY_LENGTH];
        this.result.getKeyData().copyTo(key, 0, 0, KEY_LENGTH);
        return key;
    }

    private void handleResponse(Handshaker.HandshakerResp resp) throws GeneralSecurityException {
        this.status = resp.getStatus();
        if (resp.hasResult()) {
            this.result = resp.getResult();
            this.close();
        }
        if (this.status.getCode() != Status.Code.OK.value()) {
            String error = "Handshaker service error: " + this.status.getDetails();
            logger.log(Level.INFO, error);
            this.close();
            throw new GeneralSecurityException(error);
        }
    }

    public ByteBuffer startClientHandshake() throws GeneralSecurityException {
        Handshaker.HandshakerResp resp;
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Handshake has already finished.");
        Handshaker.HandshakerReq.Builder req = Handshaker.HandshakerReq.newBuilder();
        this.setStartClientFields(req);
        try {
            resp = this.handshakerStub.send(req.build());
        }
        catch (IOException | InterruptedException e) {
            throw new GeneralSecurityException(e);
        }
        this.handleResponse(resp);
        return resp.getOutFrames().asReadOnlyByteBuffer();
    }

    public ByteBuffer startServerHandshake(ByteBuffer inBytes) throws GeneralSecurityException {
        Handshaker.HandshakerResp resp;
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Handshake has already finished.");
        Handshaker.HandshakerReq.Builder req = Handshaker.HandshakerReq.newBuilder();
        this.setStartServerFields(req, inBytes);
        try {
            resp = this.handshakerStub.send(req.build());
        }
        catch (IOException | InterruptedException e) {
            throw new GeneralSecurityException(e);
        }
        this.handleResponse(resp);
        inBytes.position(inBytes.position() + resp.getBytesConsumed());
        return resp.getOutFrames().asReadOnlyByteBuffer();
    }

    public ByteBuffer next(ByteBuffer inBytes) throws GeneralSecurityException {
        Handshaker.HandshakerResp resp;
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Handshake has already finished.");
        Handshaker.HandshakerReq.Builder req = Handshaker.HandshakerReq.newBuilder().setNext(Handshaker.NextHandshakeMessageReq.newBuilder().setInBytes(ByteString.copyFrom((ByteBuffer)inBytes.duplicate())).build());
        try {
            resp = this.handshakerStub.send(req.build());
        }
        catch (IOException | InterruptedException e) {
            throw new GeneralSecurityException(e);
        }
        this.handleResponse(resp);
        inBytes.position(inBytes.position() + resp.getBytesConsumed());
        return resp.getOutFrames().asReadOnlyByteBuffer();
    }

    public void close() {
        this.handshakerStub.close();
    }
}

