/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import io.grpc.alts.internal.Handshaker;
import io.grpc.alts.internal.HandshakerServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;

class AltsHandshakerStub {
    private final StreamObserver<Handshaker.HandshakerResp> reader = new Reader();
    private final StreamObserver<Handshaker.HandshakerReq> writer;
    private final ArrayBlockingQueue<Optional<Handshaker.HandshakerResp>> responseQueue = new ArrayBlockingQueue(1);
    private final AtomicReference<String> exceptionMessage = new AtomicReference();

    AltsHandshakerStub(HandshakerServiceGrpc.HandshakerServiceStub serviceStub) {
        this.writer = serviceStub.doHandshake(this.reader);
    }

    @VisibleForTesting
    AltsHandshakerStub() {
        this.writer = null;
    }

    @VisibleForTesting
    AltsHandshakerStub(StreamObserver<Handshaker.HandshakerReq> writer) {
        this.writer = writer;
    }

    @VisibleForTesting
    StreamObserver<Handshaker.HandshakerResp> getReaderForTest() {
        return this.reader;
    }

    public Handshaker.HandshakerResp send(Handshaker.HandshakerReq req) throws InterruptedException, IOException {
        this.maybeThrowIoException();
        if (!this.responseQueue.isEmpty()) {
            throw new IOException("Received an unexpected response.");
        }
        this.writer.onNext((Object)req);
        Optional<Handshaker.HandshakerResp> result = this.responseQueue.take();
        if (!result.isPresent()) {
            this.maybeThrowIoException();
        }
        return (Handshaker.HandshakerResp)result.get();
    }

    private void maybeThrowIoException() throws IOException {
        if (this.exceptionMessage.get() != null) {
            throw new IOException(this.exceptionMessage.get());
        }
    }

    public void close() {
        this.writer.onCompleted();
    }

    private class Reader
    implements StreamObserver<Handshaker.HandshakerResp> {
        private Reader() {
        }

        public void onNext(Handshaker.HandshakerResp resp) {
            try {
                AltsHandshakerStub.this.responseQueue.add(Optional.of((Object)resp));
            }
            catch (IllegalStateException e) {
                AltsHandshakerStub.this.exceptionMessage.compareAndSet(null, "Received an unexpected response.");
                AltsHandshakerStub.this.close();
            }
        }

        public void onError(Throwable t) {
            AltsHandshakerStub.this.exceptionMessage.compareAndSet(null, "Received a terminating error: " + t.toString());
            Optional result = Optional.absent();
            AltsHandshakerStub.this.responseQueue.offer(result);
        }

        public void onCompleted() {
            AltsHandshakerStub.this.exceptionMessage.compareAndSet(null, "Response stream closed.");
            Optional result = Optional.absent();
            AltsHandshakerStub.this.responseQueue.offer(result);
        }
    }
}

