/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.svgpath.parser;

import com.sun.javafx.svgpath.ext.awt.geom.ExtendedGeneralPath;
import com.sun.javafx.svgpath.parser.ParseException;
import com.sun.javafx.svgpath.parser.PathHandler;
import com.sun.javafx.svgpath.parser.PathParser;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Reader;
import javafx.scene.shape.FillRule;

public class AWTPathProducer
implements PathHandler {
    protected ExtendedGeneralPath path;
    protected float currentX;
    protected float currentY;
    protected float xCenter;
    protected float yCenter;
    protected int windingRule;

    public static Shape createShape(Reader reader, FillRule fillRule) throws IOException, ParseException {
        PathParser pathParser = new PathParser();
        AWTPathProducer aWTPathProducer = new AWTPathProducer();
        aWTPathProducer.setWindingRule(AWTPathProducer.toWindingRule(fillRule));
        pathParser.setPathHandler((PathHandler)aWTPathProducer);
        pathParser.parse(reader);
        return aWTPathProducer.getShape();
    }

    public static GeneralPath createPath(Reader reader, FillRule fillRule) throws IOException, ParseException {
        PathParser pathParser = new PathParser();
        AWTPathProducer aWTPathProducer = new AWTPathProducer();
        aWTPathProducer.setWindingRule(AWTPathProducer.toWindingRule(fillRule));
        pathParser.setPathHandler((PathHandler)aWTPathProducer);
        pathParser.parse(reader);
        return aWTPathProducer.getPath();
    }

    private static int toWindingRule(FillRule fillRule) {
        if (fillRule == FillRule.NON_ZERO) {
            return 1;
        }
        return 0;
    }

    public void setWindingRule(int n) {
        this.windingRule = n;
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public Shape getShape() {
        return this.path;
    }

    public GeneralPath getPath() {
        return this.path.getPath();
    }

    public void startPath() throws ParseException {
        this.currentX = 0.0f;
        this.currentY = 0.0f;
        this.xCenter = 0.0f;
        this.yCenter = 0.0f;
        this.path = new ExtendedGeneralPath(this.windingRule);
    }

    public void endPath() throws ParseException {
    }

    public void movetoRel(float f, float f2) throws ParseException {
        this.xCenter = this.currentX += f;
        this.yCenter = this.currentY += f2;
        this.path.moveTo(this.currentX, this.currentY);
    }

    public void movetoAbs(float f, float f2) throws ParseException {
        this.xCenter = this.currentX = f;
        this.yCenter = this.currentY = f2;
        this.path.moveTo(this.currentX, this.currentY);
    }

    public void closePath() throws ParseException {
        this.path.closePath();
        Point2D point2D = this.path.getCurrentPoint();
        this.currentX = (float)point2D.getX();
        this.currentY = (float)point2D.getY();
    }

    public void linetoRel(float f, float f2) throws ParseException {
        this.xCenter = this.currentX += f;
        this.yCenter = this.currentY += f2;
        this.path.lineTo(this.currentX, this.currentY);
    }

    public void linetoAbs(float f, float f2) throws ParseException {
        this.xCenter = this.currentX = f;
        this.yCenter = this.currentY = f2;
        this.path.lineTo(this.currentX, this.currentY);
    }

    public void linetoHorizontalRel(float f) throws ParseException {
        this.xCenter = this.currentX += f;
        this.yCenter = this.currentY;
        this.path.lineTo(this.currentX, this.yCenter);
    }

    public void linetoHorizontalAbs(float f) throws ParseException {
        this.xCenter = this.currentX = f;
        this.yCenter = this.currentY;
        this.path.lineTo(this.currentX, this.yCenter);
    }

    public void linetoVerticalRel(float f) throws ParseException {
        this.xCenter = this.currentX;
        this.yCenter = this.currentY += f;
        this.path.lineTo(this.xCenter, this.currentY);
    }

    public void linetoVerticalAbs(float f) throws ParseException {
        this.xCenter = this.currentX;
        this.yCenter = this.currentY = f;
        this.path.lineTo(this.xCenter, this.currentY);
    }

    public void curvetoCubicRel(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
        this.xCenter = this.currentX + f3;
        this.yCenter = this.currentY + f4;
        this.path.curveTo(this.currentX + f, this.currentY + f2, this.xCenter, this.yCenter, this.currentX += f5, this.currentY += f6);
    }

    public void curvetoCubicAbs(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
        this.xCenter = f3;
        this.yCenter = f4;
        this.currentX = f5;
        this.currentY = f6;
        this.path.curveTo(f, f2, this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    public void curvetoCubicSmoothRel(float f, float f2, float f3, float f4) throws ParseException {
        this.xCenter = this.currentX + f;
        this.yCenter = this.currentY + f2;
        this.path.curveTo(this.currentX * 2.0f - this.xCenter, this.currentY * 2.0f - this.yCenter, this.xCenter, this.yCenter, this.currentX += f3, this.currentY += f4);
    }

    public void curvetoCubicSmoothAbs(float f, float f2, float f3, float f4) throws ParseException {
        this.xCenter = f;
        this.yCenter = f2;
        this.currentX = f3;
        this.currentY = f4;
        this.path.curveTo(this.currentX * 2.0f - this.xCenter, this.currentY * 2.0f - this.yCenter, this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    public void curvetoQuadraticRel(float f, float f2, float f3, float f4) throws ParseException {
        this.xCenter = this.currentX + f;
        this.yCenter = this.currentY + f2;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX += f3, this.currentY += f4);
    }

    public void curvetoQuadraticAbs(float f, float f2, float f3, float f4) throws ParseException {
        this.xCenter = f;
        this.yCenter = f2;
        this.currentX = f3;
        this.currentY = f4;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    public void curvetoQuadraticSmoothRel(float f, float f2) throws ParseException {
        this.xCenter = this.currentX * 2.0f - this.xCenter;
        this.yCenter = this.currentY * 2.0f - this.yCenter;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX += f, this.currentY += f2);
    }

    public void curvetoQuadraticSmoothAbs(float f, float f2) throws ParseException {
        this.xCenter = this.currentX * 2.0f - this.xCenter;
        this.yCenter = this.currentY * 2.0f - this.yCenter;
        this.currentX = f;
        this.currentY = f2;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    public void arcRel(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) throws ParseException {
        this.xCenter = this.currentX += f4;
        this.yCenter = this.currentY += f5;
        this.path.arcTo(f, f2, f3, bl, bl2, this.currentX, this.currentY);
    }

    public void arcAbs(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) throws ParseException {
        this.xCenter = this.currentX = f4;
        this.yCenter = this.currentY = f5;
        this.path.arcTo(f, f2, f3, bl, bl2, this.currentX, this.currentY);
    }
}

