/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.swing;

import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.runtime.Checks;
import com.sun.javafx.runtime.FXBase;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.annotation.Public;
import com.sun.javafx.runtime.annotation.PublicInitable;
import com.sun.javafx.runtime.annotation.ScriptPrivate;
import com.sun.javafx.runtime.annotation.SourceName;
import com.sun.javafx.runtime.annotation.Static;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.ObjectArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;
import com.sun.javafx.scene.text.FontManager;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.FontMetrics;
import com.sun.javafx.tk.desktop.JUtil;
import com.sun.javafx.tk.swing.AWTFontLoader;
import com.sun.javafx.tk.swing.AWTFontUtils;
import com.sun.javafx.tk.swing.AmbleMapper;
import com.sun.scenario.utils.Utils;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.AttributedCharacterIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javafx.scene.text.FontPosition;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Public
public class AWTFontLoader
extends FontLoader
implements FXObject {
    private static int VCNT$ = -1;
    public static int VOFF$fontCache;
    private short VFLG$fontCache = 1;
    @ScriptPrivate
    @SourceName(value="fontCache")
    private Map $fontCache;
    @ScriptPrivate
    @SourceName(value="systemFontsLoaded")
    private boolean $systemFontsLoaded = false;
    @ScriptPrivate
    @SourceName(value="embeddedFontsLoaded")
    private boolean $embeddedFontsLoaded = false;
    @ScriptPrivate
    @SourceName(value="runtimeEmbeddedFontsLoaded")
    private boolean $runtimeEmbeddedFontsLoaded = false;
    static short[] MAP$com$sun$javafx$tk$swing$AWTFontLoader$CachedFont;
    static short[] MAP$javafx$scene$text$Font;
    @Static
    @ScriptPrivate
    @SourceName(value="theInstance")
    public static AWTFontLoader $theInstance;
    public static AWTFontLoader.Script $script$com$sun$javafx$tk$swing$AWTFontLoader$;

    public static int VCNT$() {
        if (VCNT$ == -1) {
            int n = VCNT$ = FontLoader.VCNT$() + 1;
            VOFF$fontCache = n + -1;
        }
        return VCNT$;
    }

    public int count$() {
        return AWTFontLoader.VCNT$();
    }

    private Map get$fontCache() {
        return this.$fontCache;
    }

    public void applyDefaults$(int n) {
        if (this.varTestBits$(n, 56, 8)) {
            switch (n - VCNT$) {
                case -1: {
                    this.$fontCache = new HashMap();
                    return;
                }
            }
            super.applyDefaults$(n);
        }
    }

    public Object get$(int n) {
        switch (n - VCNT$) {
            case -1: {
                return this.get$fontCache();
            }
        }
        return super.get$(n);
    }

    public int varChangeBits$(int n, int n2, int n3) {
        switch (n - VCNT$) {
            case -1: {
                this.VFLG$fontCache = (short)(this.VFLG$fontCache & ~n2 | n3);
                return this.VFLG$fontCache;
            }
        }
        return super.varChangeBits$(n, n2, n3);
    }

    public AWTFontLoader() {
        this(false);
        this.initialize$(true);
    }

    public AWTFontLoader(boolean bl) {
        super(bl);
        AWTFontLoader.VCNT$();
    }

    @ScriptPrivate
    public void buildFontCache() {
        AWTFontLoader aWTFontLoader = this;
        PerformanceTracker.logEvent((String)"AWTFontLoader rebuilding font cache");
        this.cacheEmbeddedFonts();
        this.cacheRuntimeEmbeddedFonts();
        this.cacheSystemFonts();
        PerformanceTracker.logEvent((String)"AWTFontLoader rebuilding font cache complete");
    }

    @ScriptPrivate
    public void cacheSystemFonts() {
        AWTFontLoader aWTFontLoader = this;
        if (!this.$systemFontsLoaded) {
            Font[] fontArray;
            PerformanceTracker.logEvent((String)"AWTFontLoader.cacheSystemFonts");
            int n = this.get$fontCache() != null ? this.get$fontCache().size() : 0;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (Font font : fontArray = graphicsEnvironment != null ? graphicsEnvironment.getAllFonts() : null) {
                Font font2 = font;
                String string = this.cleanupName(font2 != null ? font2.getName() : "");
                if (this.get$fontCache() != null && this.get$fontCache().containsKey(string)) continue;
                CachedFont cachedFont = AWTFontLoader.createCachedFont(string, font2);
                if (this.get$fontCache() == null) continue;
                this.get$fontCache().put(string, cachedFont);
            }
            if (PerformanceTracker.isLoggingEnabled()) {
                PerformanceTracker.logEvent((String)String.format("AWTFontLoader cached new %s system fonts, total cached %s", (this.get$fontCache() != null ? this.get$fontCache().size() : 0) - n, this.get$fontCache() != null ? this.get$fontCache().size() : 0));
            }
            this.$systemFontsLoaded = true;
        }
    }

    @ScriptPrivate
    public void cacheRuntimeEmbeddedFonts() {
        AWTFontLoader aWTFontLoader = this;
        if (!this.$runtimeEmbeddedFontsLoaded) {
            PerformanceTracker.logEvent((String)"AWTFontLoader.cacheRuntimeEmbeddedFonts");
            int n = this.get$fontCache() != null ? this.get$fontCache().size() : 0;
            ObjectArraySequence objectArraySequence = new ObjectArraySequence(12, TypeInfo.String);
            objectArraySequence.add((Object)"Amble Regular");
            objectArraySequence.add((Object)"Amble Bold");
            objectArraySequence.add((Object)"Amble Italic");
            objectArraySequence.add((Object)"Amble Bold Italic");
            objectArraySequence.add((Object)"Amble Condensed");
            objectArraySequence.add((Object)"Amble Bold Condensed");
            objectArraySequence.add((Object)"Amble Condensed Italic");
            objectArraySequence.add((Object)"Amble Bold Condensed Italic");
            objectArraySequence.add((Object)"Amble Light");
            objectArraySequence.add((Object)"Amble Light Italic");
            objectArraySequence.add((Object)"Amble Light Condensed");
            objectArraySequence.add((Object)"Amble Light Condensed Italic");
            Sequence sequence = (Sequence)Sequences.incrementSharing((Object)objectArraySequence);
            objectArraySequence = sequence;
            int n2 = Sequences.size((Sequence)objectArraySequence);
            for (int i = 0; i < n2; ++i) {
                Font font;
                String string = (String)objectArraySequence.get(i);
                if (this.get$fontCache() != null && this.get$fontCache().containsKey(string) || (font = AmbleMapper.interceptAmbleRequest(string)) == null) continue;
                CachedFont cachedFont = AWTFontLoader.createCachedFont(string, font);
                if (this.get$fontCache() == null) continue;
                this.get$fontCache().put(string, cachedFont);
            }
            if (PerformanceTracker.isLoggingEnabled()) {
                PerformanceTracker.logEvent((String)String.format("AWTFontLoader cached new %s runtime embedded fonts, total cached %s", (this.get$fontCache() != null ? this.get$fontCache().size() : 0) - n, this.get$fontCache() != null ? this.get$fontCache().size() : 0));
            }
            this.$runtimeEmbeddedFontsLoaded = true;
        }
    }

    @ScriptPrivate
    public void cacheEmbeddedFonts() {
        AWTFontLoader aWTFontLoader = this;
        if (!this.$embeddedFontsLoaded) {
            String[] stringArray;
            PerformanceTracker.logEvent((String)"AWTFontLoader.cacheEmbeddedFonts");
            int n = this.get$fontCache() != null ? this.get$fontCache().size() : 0;
            String[] stringArray2 = FontManager.getInstance();
            stringArray2 = stringArray = stringArray2 != null ? stringArray2.getAllNames() : null;
            int n2 = stringArray2.length;
            for (int i = 0; i < n2; ++i) {
                String string;
                String string2 = string = stringArray2[i];
                if (this.get$fontCache() != null && this.get$fontCache().containsKey(string2)) continue;
                Object object = FontManager.getInstance();
                String string3 = object != null ? object.findPathByName(string2) : "";
                try {
                    object = JUtil.getResourceAsStream((String)string3);
                    Font font = Font.createFont(0, (InputStream)object);
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                    CachedFont cachedFont = AWTFontLoader.createCachedFont(string2, font);
                    if (this.get$fontCache() == null) continue;
                    this.get$fontCache().put(string2, cachedFont);
                    continue;
                }
                catch (Exception exception) {
                    if (System.err != null) {
                        System.err.println(String.format("WARNING: Attempted to find and load font '%s' using path '%s' but failed", string2, string3));
                    }
                    if (exception == null) continue;
                    exception.printStackTrace();
                }
            }
            if (PerformanceTracker.isLoggingEnabled()) {
                PerformanceTracker.logEvent((String)String.format("AWTFontLoader cached new %s embedded fonts, total cached %s", (this.get$fontCache() != null ? this.get$fontCache().size() : 0) - n, this.get$fontCache() != null ? this.get$fontCache().size() : 0));
            }
            this.$embeddedFontsLoaded = true;
        }
    }

    @Public
    public javafx.scene.text.Font font(Object object, float f) {
        AWTFontLoader aWTFontLoader = this;
        try {
            InputStream inputStream = (InputStream)object;
            Font font = Font.createFont(0, inputStream);
            if (inputStream != null) {
                inputStream.close();
            }
            font = font != null ? font.deriveFont(f) : null;
            Object object2 = new javafx.scene.text.Font(true);
            object2.initVars$();
            object2.varChangeBits$(javafx.scene.text.Font.VOFF$name, -1, 8);
            object2.varChangeBits$(javafx.scene.text.Font.VOFF$size, -1, 8);
            int n = object2.count$();
            Object object3 = AWTFontLoader.GETMAP$javafx$scene$text$Font();
            block6: for (int i = 0; i < n; ++i) {
                object2.varChangeBits$(i, 0, 8);
                switch (object3[i]) {
                    case 1: {
                        object2.set$name(font != null ? font.getFontName() : "");
                        continue block6;
                    }
                    case 2: {
                        object2.set$size(f);
                        continue block6;
                    }
                    default: {
                        object2.applyDefaults$(i);
                    }
                }
            }
            object2.complete$();
            javafx.scene.text.Font font2 = object2;
            object2 = font2 != null ? font2.get$name() : "";
            String string = font2 != null ? font2.get$family() : "";
            object3 = font2 != null ? font2.get$style() : "";
            if (font2 != null) {
                font2.impl_setNativeFont((Object)font, (String)object2, string, (String)object3);
            }
            return font2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @ScriptPrivate
    public void addMetrics(Map map, boolean bl, boolean bl2, float f) {
        AWTFontLoader aWTFontLoader = this;
        try {
            Object object;
            Class clazz = Utils.platformClassForName((String)"java.awt.font.TextAttribute", (boolean)true);
            Field field = clazz != null ? clazz.getField("KERNING") : null;
            Object object2 = object = field != null ? field.get(null) : null;
            if (map != null) {
                map.put(object, bl ? Integer.valueOf(1) : Integer.valueOf(0));
            }
            Field field2 = clazz != null ? clazz.getField("LIGATURES") : null;
            Field field3 = field = field2 != null ? field2.get(null) : null;
            if (map != null) {
                map.put(field, bl2 ? Integer.valueOf(1) : Integer.valueOf(0));
            }
            Field field4 = clazz != null ? clazz.getField("TRACKING") : null;
            Field field5 = field2 = field4 != null ? field4.get(null) : null;
            if (map != null) {
                map.put(field2, Float.valueOf(f));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @ScriptPrivate
    public CachedFont lookupAmbleFont(String string) {
        AWTFontLoader aWTFontLoader = this;
        CachedFont cachedFont = this.get$fontCache() != null ? this.get$fontCache().get(string) : null;
        if (cachedFont != null) {
            return cachedFont;
        }
        Font font = AmbleMapper.interceptAmbleRequest(string);
        if (font != null) {
            cachedFont = AWTFontLoader.createCachedFont(string, font);
            if (this.get$fontCache() != null) {
                this.get$fontCache().put(string, cachedFont);
            }
        }
        return cachedFont;
    }

    @ScriptPrivate
    public String cleanupName(String string) {
        AWTFontLoader aWTFontLoader = this;
        String string2 = System.getProperty("os.name");
        if (string2 != null && string2.startsWith("Mac")) {
            String string3;
            String string4 = string3 = string != null ? string.toLowerCase() : "";
            if (string3 != null && string3.startsWith("amble")) {
                if (Checks.equals((String)string, (String)"Amble-Regular")) {
                    return "Amble Regular";
                }
                if (Checks.equals((String)string, (String)"Amble-Bold")) {
                    return "Amble Bold";
                }
                if (Checks.equals((String)string, (String)"Amble-Italic")) {
                    return "Amble Italic";
                }
                if (Checks.equals((String)string, (String)"Amble-BoldItalic")) {
                    return "Amble Bold Italic";
                }
                if (Checks.equals((String)string, (String)"Amble-Condensed")) {
                    return "Amble Condensed";
                }
                if (Checks.equals((String)string, (String)"Amble-BoldCondensed")) {
                    return "Amble Bold Condensed";
                }
                if (Checks.equals((String)string, (String)"Amble-CondensedItalic")) {
                    return "Amble Condensed Italic";
                }
                if (Checks.equals((String)string, (String)"Amble-BoldCondensedItalic")) {
                    return "Amble Bold Condensed Italic";
                }
                if (Checks.equals((String)string, (String)"Amble-Light")) {
                    return "Amble Light";
                }
                if (Checks.equals((String)string, (String)"Amble-LightItalic")) {
                    return "Amble Light Italic";
                }
                if (Checks.equals((String)string, (String)"Amble-LightCondensed")) {
                    return "Amble Light Condensed";
                }
                if (Checks.equals((String)string, (String)"Amble-LightCondensedItalic")) {
                    return "Amble Light Condensed Italic";
                }
            }
        }
        return string;
    }

    @Public
    public Sequence<? extends String> getFamilies() {
        AWTFontLoader aWTFontLoader = this;
        this.buildFontCache();
        Collection collection = this.get$fontCache() != null ? this.get$fontCache().values() : null;
        Object[] objectArray = collection != null ? collection.toArray() : null;
        collection = new HashSet();
        for (Object objectArray2 : objectArray) {
            Object object;
            Object object2 = objectArray2;
            CachedFont cachedFont = (CachedFont)((Object)object2);
            Object object3 = object = cachedFont != null ? cachedFont.getFamily() : "";
            if (collection == null) continue;
            ((HashSet)collection).add((String)object);
        }
        Object[] objectArray4 = collection != null ? ((HashSet)collection).toArray() : null;
        ObjectArraySequence objectArraySequence = new ObjectArraySequence(TypeInfo.String);
        for (Object object : objectArray4) {
            Object object4 = object;
            String string = (String)object4;
            String string2 = string != null ? string : "";
            String string3 = string2 != null ? string2 : "";
            objectArraySequence.add((Object)string3);
        }
        Sequence sequence = (Sequence)Sequences.incrementSharing((Object)objectArraySequence);
        return javafx.util.Sequences.sort((Sequence)sequence);
    }

    @Public
    public Sequence<? extends String> getFontNames() {
        AWTFontLoader aWTFontLoader = this;
        this.buildFontCache();
        Sequence sequence = this.get$fontCache() != null ? this.get$fontCache().keySet() : null;
        Object[] objectArray = sequence != null ? sequence.toArray() : null;
        ObjectArraySequence objectArraySequence = new ObjectArraySequence(TypeInfo.String);
        for (Object object : objectArray) {
            Object object2 = object;
            String string = (String)object2;
            String string2 = string != null ? string : "";
            String string3 = string2 != null ? string2 : "";
            objectArraySequence.add((Object)string3);
        }
        sequence = (Sequence)Sequences.incrementSharing((Object)objectArraySequence);
        return javafx.util.Sequences.sort((Sequence)sequence);
    }

    @Public
    public Sequence<? extends String> getFontNames(String string) {
        AWTFontLoader aWTFontLoader = this;
        this.buildFontCache();
        Sequence sequence = this.get$fontCache() != null ? this.get$fontCache().values() : null;
        Object[] objectArray = sequence != null ? sequence.toArray() : null;
        ObjectArraySequence objectArraySequence = new ObjectArraySequence(TypeInfo.String);
        for (Object object : objectArray) {
            ArraySequence arraySequence;
            String string2;
            Object object2 = object;
            CachedFont cachedFont = (CachedFont)((Object)object2);
            String string3 = string2 = cachedFont != null ? cachedFont.getFamily() : "";
            if (string2 != null && string2.equalsIgnoreCase(string)) {
                ObjectArraySequence objectArraySequence2 = new ObjectArraySequence(1, TypeInfo.String);
                objectArraySequence2.add((Object)(cachedFont != null ? cachedFont.get$name() : ""));
                arraySequence = objectArraySequence2;
            } else {
                arraySequence = TypeInfo.String.emptySequence;
            }
            ArraySequence arraySequence2 = arraySequence;
            objectArraySequence.add((Sequence)arraySequence2);
        }
        sequence = (Sequence)Sequences.incrementSharing((Object)objectArraySequence);
        return javafx.util.Sequences.sort((Sequence)sequence);
    }

    @Public
    public javafx.scene.text.Font font(String string, FontWeight fontWeight, FontPosture fontPosture, float f) {
        Object object;
        Object object2;
        Object object3;
        String string2;
        AWTFontLoader aWTFontLoader = this;
        Font font = null;
        Object object4 = "";
        float f2 = f == 0.0f ? 1.0f : f;
        String string3 = string2 = string != null ? string.toLowerCase() : "";
        if (string2 != null && string2.startsWith("amble")) {
            object4 = "Amble";
            if (Checks.equals((String)string2, (String)"amble")) {
                if (fontWeight != null && (fontWeight != null ? fontWeight.ordinal() : 0) < (FontWeight.REGULAR != null ? FontWeight.REGULAR.ordinal() : 0)) {
                    object4 = String.format("%s Light", object4);
                } else if (fontWeight != null && (fontWeight != null ? fontWeight.ordinal() : 0) > (FontWeight.REGULAR != null ? FontWeight.REGULAR.ordinal() : 0)) {
                    object4 = String.format("%s Bold", object4);
                } else if (!Checks.equals((Object)fontPosture, (Object)FontPosture.ITALIC)) {
                    object4 = String.format("%s Regular", object4);
                }
            } else if (Checks.equals((String)string2, (String)"amble cn")) {
                if (fontWeight != null && (fontWeight != null ? fontWeight.ordinal() : 0) < (FontWeight.REGULAR != null ? FontWeight.REGULAR.ordinal() : 0)) {
                    object4 = String.format("%s Light", object4);
                } else if (fontWeight != null && (fontWeight != null ? fontWeight.ordinal() : 0) > (FontWeight.REGULAR != null ? FontWeight.REGULAR.ordinal() : 0)) {
                    object4 = String.format("%s Bold", object4);
                }
                object4 = String.format("%s Condensed", object4);
            } else if (Checks.equals((String)string2, (String)"amble lt")) {
                if ((fontWeight != null ? fontWeight.ordinal() : 0) <= (FontWeight.REGULAR != null ? FontWeight.REGULAR.ordinal() : 0)) {
                    object4 = String.format("%s Light", object4);
                } else if (fontWeight != null && (fontWeight != null ? fontWeight.ordinal() : 0) < (FontWeight.BOLD != null ? FontWeight.BOLD.ordinal() : 0) && !Checks.equals((Object)fontPosture, (Object)FontPosture.ITALIC)) {
                    object4 = String.format("%s Regular", object4);
                } else if (fontWeight != null && (fontWeight != null ? fontWeight.ordinal() : 0) >= (FontWeight.BOLD != null ? FontWeight.BOLD.ordinal() : 0)) {
                    object4 = String.format("%s Bold", object4);
                }
            } else if (Checks.equals((String)string2, (String)"amble ltcn")) {
                if ((fontWeight != null ? fontWeight.ordinal() : 0) <= (FontWeight.REGULAR != null ? FontWeight.REGULAR.ordinal() : 0)) {
                    object4 = String.format("%s Light", object4);
                } else if (fontWeight != null && (fontWeight != null ? fontWeight.ordinal() : 0) >= (FontWeight.BOLD != null ? FontWeight.BOLD.ordinal() : 0)) {
                    object4 = String.format("%s Bold", object4);
                }
                object4 = String.format("%s Condensed", object4);
            }
            if (Checks.equals((Object)fontPosture, (Object)FontPosture.ITALIC)) {
                object4 = String.format("%s Italic", object4);
            }
            object2 = (object3 = this.lookupAmbleFont((String)object4)) != null ? ((CachedFont)((Object)object3)).getCompositeFont() : null;
            font = object2 != null ? ((Font)object2).deriveFont(f2) : null;
        } else {
            Serializable serializable;
            object3 = null;
            if (Checks.equals((Object)fontWeight, (Object)FontWeight.REGULAR) || fontWeight == null) {
                object3 = TextAttribute.WEIGHT_REGULAR;
            } else if (Checks.equals((Object)fontWeight, (Object)FontWeight.EXTRA_LIGHT)) {
                object3 = TextAttribute.WEIGHT_EXTRA_LIGHT;
            } else if (Checks.equals((Object)fontWeight, (Object)FontWeight.LIGHT)) {
                object3 = TextAttribute.WEIGHT_LIGHT;
            } else if (Checks.equals((Object)fontWeight, (Object)FontWeight.DEMI_LIGHT)) {
                object3 = TextAttribute.WEIGHT_DEMILIGHT;
            } else if (Checks.equals((Object)fontWeight, (Object)FontWeight.SEMI_BOLD)) {
                object3 = TextAttribute.WEIGHT_SEMIBOLD;
            } else if (Checks.equals((Object)fontWeight, (Object)FontWeight.MEDIUM)) {
                object3 = TextAttribute.WEIGHT_MEDIUM;
            } else if (Checks.equals((Object)fontWeight, (Object)FontWeight.DEMI_BOLD)) {
                object3 = TextAttribute.WEIGHT_DEMIBOLD;
            } else if (Checks.equals((Object)fontWeight, (Object)FontWeight.BOLD)) {
                object3 = TextAttribute.WEIGHT_BOLD;
            } else if (Checks.equals((Object)fontWeight, (Object)FontWeight.HEAVY)) {
                object3 = TextAttribute.WEIGHT_HEAVY;
            } else if (Checks.equals((Object)fontWeight, (Object)FontWeight.EXTRA_BOLD)) {
                object3 = TextAttribute.WEIGHT_EXTRABOLD;
            } else {
                object2 = null;
                if (Checks.equals((Object)fontWeight, (Object)FontWeight.ULTRA_BOLD)) {
                    object2 = object3 = TextAttribute.WEIGHT_ULTRABOLD;
                } else {
                    throw new AssertionError((Object)"Unexpected FontWeight");
                }
            }
            object2 = null;
            if (fontPosture == null || Checks.equals((Object)fontPosture, (Object)FontPosture.REGULAR)) {
                object2 = TextAttribute.POSTURE_REGULAR;
            } else {
                serializable = null;
                if (Checks.equals((Object)fontPosture, (Object)FontPosture.ITALIC)) {
                    object2 = TextAttribute.POSTURE_OBLIQUE;
                    serializable = object2;
                } else {
                    throw new AssertionError((Object)"Unexpected FontPosture");
                }
            }
            serializable = new HashMap<TextAttribute, Object>();
            if (!Checks.isNull((String)string) && serializable != null) {
                ((HashMap)serializable).put(TextAttribute.FAMILY, string);
            }
            if (serializable != null) {
                ((HashMap)serializable).put(TextAttribute.WEIGHT, object3);
            }
            if (serializable != null) {
                ((HashMap)serializable).put(TextAttribute.POSTURE, object2);
            }
            object = Float.valueOf(Float.valueOf(f2).floatValue());
            if (serializable != null) {
                ((HashMap)serializable).put(TextAttribute.SIZE, object);
            }
            this.addMetrics((Map)((Object)serializable), true, true, 0.0f);
            font = new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)((Object)serializable));
            font = AWTFontUtils.getCompositeFont(font);
            object = font != null ? font.getFontName() : "";
            Object object5 = object4 = object != null ? object : "";
        }
        if (font == null) {
            String string4;
            object2 = new javafx.scene.text.Font(true);
            object2.initVars$();
            object2.varChangeBits$(javafx.scene.text.Font.VOFF$size, -1, 8);
            int n = object2.count$();
            int n2 = javafx.scene.text.Font.VOFF$size;
            for (int i = 0; i < n; ++i) {
                object2.varChangeBits$(i, 0, 8);
                if (i == n2) {
                    object2.set$size(f2);
                    continue;
                }
                object2.applyDefaults$(i);
            }
            object2.complete$();
            object3 = object2;
            object2 = object3 != null ? object3.impl_getNativeFont() : null;
            String string5 = string4 = object3 != null ? object3.get$name() : "";
            if (object3 != null) {
                object3.impl_setNativeFont(object2, string4, "", "");
            }
            return object3;
        }
        object2 = new javafx.scene.text.Font(true);
        object2.initVars$();
        object2.varChangeBits$(javafx.scene.text.Font.VOFF$name, -1, 8);
        object2.varChangeBits$(javafx.scene.text.Font.VOFF$size, -1, 8);
        int n = object2.count$();
        object = AWTFontLoader.GETMAP$javafx$scene$text$Font();
        block5: for (int i = 0; i < n; ++i) {
            object2.varChangeBits$(i, 0, 8);
            switch (object[i]) {
                case 1: {
                    object2.set$name((String)object4);
                    continue block5;
                }
                case 2: {
                    object2.set$size(f2);
                    continue block5;
                }
                default: {
                    object2.applyDefaults$(i);
                }
            }
        }
        object2.complete$();
        object3 = object2;
        object2 = object3 != null ? object3.get$name() : "";
        String string6 = object3 != null ? object3.get$family() : "";
        Object object6 = object = object3 != null ? object3.get$style() : "";
        if (object3 != null) {
            object3.impl_setNativeFont((Object)font, (String)object2, string6, (String)object);
        }
        return object3;
    }

    @Public
    public void loadFont(javafx.scene.text.Font font) {
        Font font2;
        Object object;
        Object object2;
        Object object3;
        AWTFontLoader aWTFontLoader = this;
        PerformanceTracker.logEvent((String)"AWTFontLoader.loadFont: loading font");
        CachedFont cachedFont = null;
        boolean bl = false;
        Serializable serializable = font != null ? font.get$name() : "";
        cachedFont = this.get$fontCache() != null ? this.get$fontCache().get(serializable) : null;
        if (cachedFont == null && Checks.equals((String)(font != null ? font.get$name() : ""), (String)"Dialog")) {
            serializable = new Font("Dialog", 0, 1);
            cachedFont = AWTFontLoader.createCachedFont(font != null ? font.get$name() : "", serializable);
            Object object4 = object3 = font != null ? font.get$name() : "";
            if (this.get$fontCache() != null) {
                this.get$fontCache().put(object3, cachedFont);
            }
        }
        if (cachedFont == null && !this.$embeddedFontsLoaded) {
            this.cacheEmbeddedFonts();
            serializable = font != null ? font.get$name() : "";
            cachedFont = this.get$fontCache() != null ? this.get$fontCache().get(serializable) : null;
        }
        if (cachedFont == null) {
            cachedFont = this.lookupAmbleFont(font != null ? font.get$name() : "");
        }
        if (cachedFont == null && Checks.equals((String)((serializable = new Font(font != null ? font.get$name() : "", 0, 1)) != null ? ((Font)serializable).getFontName() : ""), (String)(font != null ? font.get$name() : ""))) {
            cachedFont = AWTFontLoader.createCachedFont(font != null ? font.get$name() : "", (Font)serializable);
            Object object5 = object3 = font != null ? font.get$name() : "";
            if (this.get$fontCache() != null) {
                this.get$fontCache().put(object3, cachedFont);
            }
        }
        if (cachedFont == null && !Checks.isNull(serializable = AWTFontUtils.getAltName(font != null ? font.get$name() : "")) && Checks.equals((String)((object3 = new Font((String)((Object)serializable), 0, 1)) != null ? ((Font)object3).getFontName() : ""), (String)((Object)serializable))) {
            cachedFont = AWTFontLoader.createCachedFont(font != null ? font.get$name() : "", (Font)object3);
            Object object6 = object2 = font != null ? font.get$name() : "";
            if (this.get$fontCache() != null) {
                this.get$fontCache().put(object2, cachedFont);
            }
        }
        if (cachedFont == null) {
            serializable = new Font(font != null ? font.get$name() : "", 0, 1);
            cachedFont = AWTFontLoader.createCachedFont(font != null ? font.get$name() : "", (Font)serializable);
            bl = true;
        }
        serializable = new HashMap();
        Object object7 = object3 = font != null ? Float.valueOf(font.get$size()) : Float.valueOf(0.0f);
        if (serializable != null) {
            ((HashMap)serializable).put(TextAttribute.SIZE, object3);
        }
        this.addMetrics((Map)((Object)serializable), font != null ? font.get$autoKern() : false, font != null ? font.get$ligatures() : false, font != null ? font.get$letterSpacing() : 0.0f);
        object3 = null;
        if (font != null && font.get$oblique()) {
            object3 = AffineTransform.getShearInstance(-0.225f, 0.0);
        }
        if (object3 != null) {
            object2 = new TransformAttribute((AffineTransform)object3);
            if (serializable != null) {
                ((HashMap)serializable).put(TextAttribute.TRANSFORM, object2);
            }
        }
        if ((font != null ? font.get$position() : null) != null && !Checks.equals((Object)(font != null ? font.get$position() : null), (Object)FontPosition.REGULAR)) {
            Object object8 = object2 = Checks.equals((Object)(font != null ? font.get$position() : null), (Object)FontPosition.SUPERSCRIPT) ? TextAttribute.SUPERSCRIPT_SUPER : TextAttribute.SUPERSCRIPT_SUB;
            if (serializable != null) {
                ((HashMap)serializable).put(TextAttribute.SUPERSCRIPT, object2);
            }
        }
        PerformanceTracker.logEvent((String)"AWTFontLoader.loadFont: deriving font");
        object2 = System.getProperty("os.name");
        if (object2 != null && ((String)object2).startsWith("Mac")) {
            float f;
            object = cachedFont != null ? cachedFont.get$awtFont() : null;
            float f2 = f = font != null ? font.get$size() : 0.0f;
            font2 = object != null ? ((Font)object).deriveFont(f) : null;
        } else {
            object = cachedFont != null ? cachedFont.getCompositeFont() : null;
            font2 = object != null ? ((Font)object).deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)((Object)serializable)) : null;
        }
        Font font3 = font2;
        PerformanceTracker.logEvent((String)"AWTFontLoader.loadFont: font derived");
        if (bl) {
            Object object9 = object = cachedFont != null ? cachedFont.get$name() : "";
            if (font != null) {
                font.impl_setNativeFont((Object)font3, (String)object, "", "");
            }
        } else {
            String string;
            object = font != null ? font.get$name() : "";
            String string2 = cachedFont != null ? cachedFont.getFamily() : "";
            String string3 = string = cachedFont != null ? cachedFont.getStyle() : "";
            if (font != null) {
                font.impl_setNativeFont((Object)font3, (String)object, string2, string);
            }
        }
        PerformanceTracker.logEvent((String)"AWTFontLoader.loadFont: font loaded");
    }

    @Public
    public FontMetrics getFontMetrics(javafx.scene.text.Font font) {
        AWTFontLoader aWTFontLoader = this;
        FontMetrics fontMetrics = null;
        if (font == null) {
            return null;
        }
        java.awt.FontMetrics fontMetrics2 = AWTFontUtils.getFontMetrics((Font)(font != null ? font.impl_getNativeFont() : null));
        int n = fontMetrics2 != null ? fontMetrics2.getMaxAscent() : 0;
        int n2 = fontMetrics2 != null ? fontMetrics2.getAscent() : 0;
        double d = AWTFontUtils.computeXHeight((Font)(font != null ? font.impl_getNativeFont() : null));
        int n3 = fontMetrics2 != null ? fontMetrics2.getDescent() : 0;
        int n4 = fontMetrics2 != null ? fontMetrics2.getMaxDescent() : 0;
        int n5 = fontMetrics2 != null ? fontMetrics2.getLeading() : 0;
        fontMetrics = FontMetrics.impl_createFontMetrics((float)n, (float)n2, (float)((float)d), (float)n3, (float)n4, (float)n5, (javafx.scene.text.Font)font);
        return fontMetrics;
    }

    @Public
    public float computeStringWidth(String string, javafx.scene.text.Font font) {
        AWTFontLoader aWTFontLoader = this;
        return (float)AWTFontUtils.computeStringWidth((Font)(font != null ? font.impl_getNativeFont() : null), string);
    }

    public static short[] GETMAP$com$sun$javafx$tk$swing$AWTFontLoader$CachedFont() {
        return MAP$com$sun$javafx$tk$swing$AWTFontLoader$CachedFont == null ? (MAP$com$sun$javafx$tk$swing$AWTFontLoader$CachedFont = FXBase.makeInitMap$((int)CachedFont.VCNT$(), (int[])new int[]{CachedFont.VOFF$name, CachedFont.VOFF$awtFont})) : MAP$com$sun$javafx$tk$swing$AWTFontLoader$CachedFont;
    }

    public static short[] GETMAP$javafx$scene$text$Font() {
        return MAP$javafx$scene$text$Font == null ? (MAP$javafx$scene$text$Font = FXBase.makeInitMap$((int)javafx.scene.text.Font.VCNT$(), (int[])new int[]{javafx.scene.text.Font.VOFF$name, javafx.scene.text.Font.VOFF$size})) : MAP$javafx$scene$text$Font;
    }

    @Static
    @Public
    public static AWTFontLoader getInstance() {
        return AWTFontLoader.get$theInstance();
    }

    @Static
    @ScriptPrivate
    public static CachedFont createCachedFont(String string, Font font) {
        CachedFont cachedFont = new CachedFont(true);
        cachedFont.initVars$();
        cachedFont.varChangeBits$(CachedFont.VOFF$name, -1, 8);
        cachedFont.varChangeBits$(CachedFont.VOFF$awtFont, -1, 8);
        int n = cachedFont.count$();
        short[] sArray = AWTFontLoader.GETMAP$com$sun$javafx$tk$swing$AWTFontLoader$CachedFont();
        block4: for (int i = 0; i < n; ++i) {
            cachedFont.varChangeBits$(i, 0, 8);
            switch (sArray[i]) {
                case 1: {
                    String string2 = string;
                    cachedFont.set$name(string2 != null ? string2 : "");
                    continue block4;
                }
                case 2: {
                    cachedFont.set$awtFont(font);
                    continue block4;
                }
                default: {
                    cachedFont.applyDefaults$(i);
                }
            }
        }
        cachedFont.complete$();
        return cachedFont;
    }

    public static AWTFontLoader get$theInstance() {
        return $theInstance;
    }

    static {
        $script$com$sun$javafx$tk$swing$AWTFontLoader$ = new AWTFontLoader.Script(false);
        $script$com$sun$javafx$tk$swing$AWTFontLoader$.initialize$(false);
        $script$com$sun$javafx$tk$swing$AWTFontLoader$.applyDefaults$();
    }

    @Static
    @ScriptPrivate
    public static class CachedFont
    extends FXBase
    implements FXObject {
        private static int VCNT$ = 2;
        public static int VOFF$awtFont = 0;
        public static int VOFF$name = 1;
        public short VFLG$awtFont = 1;
        public short VFLG$name = 1;
        @PublicInitable
        @ScriptPrivate
        @SourceName(value="awtFont")
        public Font $awtFont;
        @PublicInitable
        @ScriptPrivate
        @SourceName(value="name")
        public String $name = "";
        @ScriptPrivate
        @SourceName(value="family")
        private String $family = "";
        @ScriptPrivate
        @SourceName(value="style")
        private String $style = "";
        @ScriptPrivate
        @SourceName(value="compositeFont")
        private Font $compositeFont;

        public static int VCNT$() {
            return 2;
        }

        public int count$() {
            return 2;
        }

        public Font get$awtFont() {
            return this.$awtFont;
        }

        public Font set$awtFont(Font font) {
            if ((this.VFLG$awtFont & 0x200) != 0) {
                this.restrictSet$(this.VFLG$awtFont);
            }
            Font font2 = this.$awtFont;
            short s = this.VFLG$awtFont;
            this.VFLG$awtFont = (short)(this.VFLG$awtFont | 0x18);
            if (font2 != font || (s & 0x10) == 0) {
                this.invalidate$awtFont(97);
                this.$awtFont = font;
                this.invalidate$awtFont(94);
                this.onReplace$awtFont(font2, font);
            }
            this.VFLG$awtFont = (short)(this.VFLG$awtFont & 0xFFFFFFF8 | 1);
            return this.$awtFont;
        }

        public void invalidate$awtFont(int n) {
            boolean bl;
            int n2 = this.VFLG$awtFont & 7;
            boolean bl2 = bl = (n2 & n) == n2;
            if (bl) {
                this.VFLG$awtFont = (short)(this.VFLG$awtFont & 0xFFFFFFF8 | n >> 4);
                this.notifyDependents$(VOFF$awtFont, n &= 0xFFFFFFDD);
            }
        }

        public void onReplace$awtFont(Font font, Font font2) {
        }

        public String get$name() {
            return this.$name;
        }

        public String set$name(String string) {
            if ((this.VFLG$name & 0x200) != 0) {
                this.restrictSet$(this.VFLG$name);
            }
            String string2 = this.$name;
            short s = this.VFLG$name;
            this.VFLG$name = (short)(this.VFLG$name | 0x18);
            if (!Checks.equals((String)string2, (String)string) || (s & 0x10) == 0) {
                this.invalidate$name(97);
                this.$name = string;
                this.invalidate$name(94);
                this.onReplace$name(string2, string);
            }
            this.VFLG$name = (short)(this.VFLG$name & 0xFFFFFFF8 | 1);
            return this.$name;
        }

        public void invalidate$name(int n) {
            boolean bl;
            int n2 = this.VFLG$name & 7;
            boolean bl2 = bl = (n2 & n) == n2;
            if (bl) {
                this.VFLG$name = (short)(this.VFLG$name & 0xFFFFFFF8 | n >> 4);
                this.notifyDependents$(VOFF$name, n &= 0xFFFFFFDD);
            }
        }

        public void onReplace$name(String string, String string2) {
        }

        public Object get$(int n) {
            switch (n) {
                case 0: {
                    return this.get$awtFont();
                }
                case 1: {
                    return this.get$name();
                }
            }
            return super.get$(n);
        }

        public void set$(int n, Object object) {
            switch (n) {
                case 0: {
                    this.set$awtFont((Font)object);
                    return;
                }
                case 1: {
                    this.set$name((String)object);
                    return;
                }
            }
            super.set$(n, object);
        }

        public void invalidate$(int n, int n2, int n3, int n4, int n5) {
            switch (n) {
                case 0: {
                    this.invalidate$awtFont(n5);
                    return;
                }
                case 1: {
                    this.invalidate$name(n5);
                    return;
                }
            }
            super.invalidate$(n, n2, n3, n4, n5);
        }

        public int varChangeBits$(int n, int n2, int n3) {
            switch (n) {
                case 0: {
                    this.VFLG$awtFont = (short)(this.VFLG$awtFont & ~n2 | n3);
                    return this.VFLG$awtFont;
                }
                case 1: {
                    this.VFLG$name = (short)(this.VFLG$name & ~n2 | n3);
                    return this.VFLG$name;
                }
            }
            return super.varChangeBits$(n, n2, n3);
        }

        public CachedFont() {
            this(false);
            this.initialize$(true);
        }

        public CachedFont(boolean bl) {
            super(bl);
        }

        @Public
        public Font getCompositeFont() {
            CachedFont cachedFont = this;
            if (this.$compositeFont == null) {
                this.$compositeFont = AWTFontUtils.getCompositeFont(this.get$awtFont());
            }
            return this.$compositeFont;
        }

        @Public
        public String getFamily() {
            CachedFont cachedFont = this;
            if (Checks.equals((String)this.$family, (String)"")) {
                String string = this.get$awtFont() != null ? this.get$awtFont().getFamily() : "";
                String string2 = System.getProperty("os.name");
                if (string2 != null && string2.startsWith("Mac")) {
                    String string3;
                    String string4 = string3 = string != null ? string.toLowerCase() : "";
                    if (string3 != null && string3.startsWith("amble")) {
                        if (Checks.equals((String)string, (String)"Amble-Bold") || Checks.equals((String)string, (String)"Amble-BoldItalic") || Checks.equals((String)string, (String)"Amble-Regular") || Checks.equals((String)string, (String)"Amble-Italic")) {
                            this.$family = "Amble";
                        } else if (Checks.equals((String)string, (String)"Amble-BoldCondensed") || Checks.equals((String)string, (String)"Amble-BoldCondensedItalic") || Checks.equals((String)string, (String)"Amble-Condensed") || Checks.equals((String)string, (String)"Amble-CondensedItalic")) {
                            this.$family = "Amble Cn";
                        } else if (Checks.equals((String)string, (String)"Amble-Light") || Checks.equals((String)string, (String)"Amble-LightItalic")) {
                            this.$family = "Amble Lt";
                        } else if (Checks.equals((String)string, (String)"Amble-LightCondensed") || Checks.equals((String)string, (String)"Amble-LightCondensedItalic")) {
                            this.$family = "Amble LtCn";
                        } else {
                            if (System.err != null) {
                                System.err.println(String.format("Unexpected family name was '%s'", string));
                            }
                            this.$family = "Amble";
                        }
                    } else {
                        String string5 = string;
                        this.$family = string5 != null ? string5 : "";
                    }
                } else {
                    String string6 = string;
                    this.$family = string6 != null ? string6 : "";
                }
            }
            return this.$family;
        }

        @Public
        public String getStyle() {
            block33: {
                CachedFont cachedFont = this;
                if (Checks.equals((String)this.$style, (String)"")) {
                    String string;
                    String string2 = string = this.get$name() != null ? this.get$name().toLowerCase() : "";
                    if (Checks.equals((String)string, (String)"amble regular")) {
                        this.$style = "Regular";
                    } else if (Checks.equals((String)string, (String)"amble bold")) {
                        this.$style = "Bold";
                    } else if (Checks.equals((String)string, (String)"amble italic")) {
                        this.$style = "Italic";
                    } else if (Checks.equals((String)string, (String)"amble bold italic")) {
                        this.$style = "Bold Italic";
                    } else if (Checks.equals((String)string, (String)"amble condensed")) {
                        this.$style = "Regular";
                    } else if (Checks.equals((String)string, (String)"amble bold condensed")) {
                        this.$style = "Bold";
                    } else if (Checks.equals((String)string, (String)"amble condensed italic")) {
                        this.$style = "Italic";
                    } else if (Checks.equals((String)string, (String)"amble bold condensed italic")) {
                        this.$style = "Bold Italic";
                    } else if (Checks.equals((String)string, (String)"amble light")) {
                        this.$style = "Regular";
                    } else if (Checks.equals((String)string, (String)"amble light italic")) {
                        this.$style = "Italic";
                    } else if (Checks.equals((String)string, (String)"amble light condensed")) {
                        this.$style = "Regular";
                    } else if (Checks.equals((String)string, (String)"amble light condensed italic")) {
                        this.$style = "Italic";
                    } else {
                        try {
                            String string3 = this.getFamily();
                            int n = string3 != null ? string3.length() : 0;
                            String string4 = this.get$name() != null ? this.get$name().substring(n) : "";
                            String string5 = string4 != null ? string4.trim() : "";
                            String string6 = this.$style = string5 != null ? string5 : "";
                            if (this.$style != null && this.$style.startsWith(".") || this.$style != null && this.$style.startsWith("-")) {
                                string4 = this.$style != null ? this.$style.substring(1) : "";
                                String string7 = this.$style = string4 != null ? string4 : "";
                            }
                            if ("".equals(this.$style)) {
                                this.$style = "Regular";
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                String string8 = this.$family != null ? this.$family.replaceAll(" ", "") : "";
                                int n = string8 != null ? string8.length() : 0;
                                String string9 = this.get$name() != null ? this.get$name().substring(n) : "";
                                String string10 = string9 != null ? string9.trim() : "";
                                String string11 = this.$style = string10 != null ? string10 : "";
                                if (this.$style != null && this.$style.startsWith(".") || this.$style != null && this.$style.startsWith("-")) {
                                    string9 = this.$style != null ? this.$style.substring(1) : "";
                                    String string12 = this.$style = string9 != null ? string9 : "";
                                }
                                if ("".equals(this.$style)) {
                                    this.$style = "Regular";
                                }
                            }
                            catch (Throwable throwable2) {
                                if (System.err == null) break block33;
                                System.err.println(String.format("Failed to get style for font '%s'", this.get$name()));
                            }
                        }
                    }
                }
            }
            return this.$style;
        }
    }
}

