/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.swing;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.Bidi;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class AWTFontUtils {
    private static Object KERNING;
    private static Object KERNING_ON;
    private static Object LIGATURES;
    private static Object LIGATURES_ON;
    private static Object TRACKING;
    private static FontRenderContext DEFAULT_FRC;
    private static boolean fontDesignMetricsInitialized;
    private static Class<?> fontDesignMetricsClass;
    private static Method getFontDesignMetrics;
    private static Constructor newFontDesignMetrics;
    private static boolean compositeFontMethodsInitialized;
    private static Method getCompositeFontUIResource;
    private static Method fontSupportsDefaultEncoding;
    static final int ttcfTag = 1953784678;
    static final int v1ttTag = 65536;
    static final int trueTag = 1953658213;
    static final int nameTag = 1851878757;
    static final int TTCHEADERSIZE = 12;
    static final int DIRECTORYHEADERSIZE = 12;
    static final int DIRECTORYENTRYSIZE = 16;
    static byte[] data;
    static Buffer buffer;
    static final int MAC_PLATFORM_ID = 1;
    static final int MACROMAN_SPECIFIC_ID = 0;
    static final int MACROMAN_ENGLISH_LANG = 0;
    static final int MS_PLATFORM_ID = 3;
    static final short MS_ENGLISH_LOCALE_ID = 1033;
    static final int FAMILY_NAME_ID = 1;
    static final int STYLE_NAME_ID = 2;
    static final int FULL_NAME_ID = 4;
    static final int POSTSCRIPT_NAME_ID = 6;
    static final String utf16Encoding = "UTF-16";
    static final String asciiEncoding = "US-ASCII";
    static HashMap<String, String> psToWinMap;
    static HashMap<String, String> winToPSMap;
    static String osName;
    static boolean isOSX;
    static boolean isWindows;

    private AWTFontUtils() {
    }

    static FontMetrics getFontMetrics(Font font) {
        return AWTFontUtils.getFontMetrics(font, DEFAULT_FRC);
    }

    static double computeLineHeight(Font font) {
        if (font == null) {
            return 0.0;
        }
        FontMetrics fontMetrics = AWTFontUtils.getFontMetrics(font, DEFAULT_FRC);
        return fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
    }

    static double computeXHeight(Font font) {
        if (font == null) {
            return 0.0;
        }
        return font.createGlyphVector(DEFAULT_FRC, "x").getGlyphMetrics(0).getBounds2D().getHeight();
    }

    static double computeCenterline(Font font) {
        FontMetrics fontMetrics = AWTFontUtils.getFontMetrics(font, DEFAULT_FRC);
        return fontMetrics.getAscent() / 2;
    }

    static double computeStringWidth(Font font, String string) {
        if (string == null || string.equals("")) {
            return 0.0;
        }
        FontMetrics fontMetrics = AWTFontUtils.getFontMetrics(font, DEFAULT_FRC);
        return AWTFontUtils.computeStringWidth(fontMetrics, string);
    }

    static double computeStringWidth(FontMetrics fontMetrics, String string) {
        if (string == null || string.equals("")) {
            return 0.0;
        }
        return fontMetrics.stringWidth(string);
    }

    private static boolean contains(Map map, Object object, Object object2) {
        Object v = map.get(object);
        return v != null && v.equals(object2);
    }

    private static synchronized FontMetrics getFontMetrics(Font font, FontRenderContext fontRenderContext) {
        FontMetrics fontMetrics;
        block9: {
            fontMetrics = null;
            if (!fontDesignMetricsInitialized) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        fontDesignMetricsInitialized = true;
                        try {
                            fontDesignMetricsClass = Class.forName("sun.font.FontDesignMetrics", true, null);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            return null;
                        }
                        try {
                            newFontDesignMetrics = fontDesignMetricsClass.getConstructor(Font.class, FontRenderContext.class);
                            getFontDesignMetrics = fontDesignMetricsClass.getMethod("getMetrics", Font.class, FontRenderContext.class);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            try {
                if (getFontDesignMetrics != null) {
                    fontMetrics = (FontMetrics)getFontDesignMetrics.invoke(null, font, fontRenderContext);
                } else if (newFontDesignMetrics != null) {
                    fontMetrics = (FontMetrics)newFontDesignMetrics.newInstance(font, fontRenderContext);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                if (!(invocationTargetException.getTargetException() instanceof RuntimeException)) break block9;
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
        }
        if (fontMetrics == null) {
            fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        }
        return fontMetrics;
    }

    private static final boolean isComplexLayout(char c) {
        return c >= '\u0900' && c <= '\u0d7f' || c >= '\u0e00' && c <= '\u0e7f' || c >= '\u1780' && c <= '\u17ff' || c >= '\ud800' && c <= '\udfff';
    }

    private static final boolean isSimpleLayout(char c) {
        return c < '\u0590' || '\u2e00' <= c && c < '\ud800';
    }

    public static final boolean isComplexLayout(char[] cArray, int n, int n2) {
        boolean bl = true;
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (AWTFontUtils.isComplexLayout(c)) {
                return true;
            }
            if (!bl) continue;
            bl = AWTFontUtils.isSimpleLayout(c);
        }
        if (bl) {
            return false;
        }
        return Bidi.requiresBidi(cArray, n, n2);
    }

    private static boolean requiresComplexLayout(Font font, String string) {
        Map<TextAttribute, ?> map = font.getAttributes();
        if (AWTFontUtils.contains(map, KERNING, KERNING_ON) || AWTFontUtils.contains(map, LIGATURES, LIGATURES_ON) || map.containsKey(TRACKING) && map.get(TRACKING) != null) {
            return true;
        }
        return AWTFontUtils.isComplexLayout(string.toCharArray(), 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Font getCompositeFont(Font font) {
        Class<AWTFontUtils> clazz = AWTFontUtils.class;
        synchronized (AWTFontUtils.class) {
            if (!compositeFontMethodsInitialized) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        Class<?> clazz;
                        compositeFontMethodsInitialized = true;
                        try {
                            clazz = Class.forName("sun.font.FontUtilities", true, null);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            try {
                                clazz = Class.forName("sun.font.FontManager", true, null);
                            }
                            catch (ClassNotFoundException classNotFoundException2) {
                                return null;
                            }
                        }
                        try {
                            fontSupportsDefaultEncoding = clazz.getMethod("fontSupportsDefaultEncoding", Font.class);
                            getCompositeFontUIResource = clazz.getMethod("getCompositeFontUIResource", Font.class);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (getCompositeFontUIResource != null && fontSupportsDefaultEncoding != null) {
                try {
                    if (!((Boolean)fontSupportsDefaultEncoding.invoke(null, font)).booleanValue()) {
                        return (Font)getCompositeFontUIResource.invoke(null, font);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return font;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parseFile(String string) throws Exception {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
            randomAccessFile.seek(0L);
            randomAccessFile.read(data, 0, 12);
            buffer.init(data);
            if (buffer.getInt() == 1953784678) {
                int n;
                buffer.skip(4);
                int n2 = buffer.getInt();
                int[] nArray = new int[n2];
                randomAccessFile.read(data, 0, 4 * n2);
                buffer.init(data);
                for (n = 0; n < n2; ++n) {
                    nArray[n] = buffer.getInt();
                }
                for (n = 0; n < n2; ++n) {
                    AWTFontUtils.parseSfnt(randomAccessFile, nArray[n]);
                }
            } else {
                AWTFontUtils.parseSfnt(randomAccessFile, 0);
            }
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    static void parseSfnt(RandomAccessFile randomAccessFile, int n) throws Exception {
        int n2;
        randomAccessFile.seek(n + 4);
        randomAccessFile.read(data, 0, 2);
        buffer.init(data);
        int n3 = buffer.getShort();
        int n4 = n + 12;
        randomAccessFile.seek(n4);
        randomAccessFile.read(data, 0, n3 * 16);
        buffer.init(data);
        int n5 = 0;
        for (n2 = 0; n2 < n3 && (n5 = buffer.getInt()) != 1851878757; ++n2) {
            buffer.skip(12);
        }
        if (n5 != 1851878757) {
            throw new IOException("No name table");
        }
        buffer.skip(4);
        n2 = buffer.getInt();
        int n6 = buffer.getInt();
        if ((long)(n2 + n6) > randomAccessFile.length()) {
            throw new IOException("bad table, tag=" + n5);
        }
        if (n6 > data.length) {
            data = new byte[n6];
        }
        randomAccessFile.seek(n2);
        int n7 = randomAccessFile.read(data, 0, n6);
        buffer.init(data);
        AWTFontUtils.parseNameTable(buffer);
    }

    static void parseNameTable(Buffer buffer) throws Exception {
        byte[] byArray = new byte[256];
        buffer.skip(2);
        int n = buffer.getShort();
        int n2 = buffer.getShort() & 0xFFFF;
        String string = null;
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            short s = buffer.getShort();
            if (s != 3 && s != 1) {
                buffer.skip(10);
                continue;
            }
            short s2 = buffer.getShort();
            if (s == 3 && s2 > 1 || s == 1 && s2 != 0) {
                buffer.skip(8);
                continue;
            }
            short s3 = buffer.getShort();
            if (s == 1 && s3 != 0) {
                buffer.skip(6);
                continue;
            }
            short s4 = buffer.getShort();
            int n3 = buffer.getShort() & 0xFFFF;
            int n4 = (buffer.getShort() & 0xFFFF) + n2;
            switch (s4) {
                case 6: {
                    if (string2 != null) break;
                    if (s == 3 && s3 == 1033) {
                        buffer.get(n4, byArray, 0, n3);
                        string2 = new String(byArray, 0, n3, utf16Encoding);
                        break;
                    }
                    if (s != 1 || s3 != 0) break;
                    buffer.get(n4, byArray, 0, n3);
                    string2 = new String(byArray, 0, n3, asciiEncoding);
                    break;
                }
                case 4: {
                    if (s != 3 || s3 != 1033) break;
                    buffer.get(n4, byArray, 0, n3);
                    string = new String(byArray, 0, n3, utf16Encoding);
                    break;
                }
            }
            if (string == null || string2 == null) continue;
            psToWinMap.put(string2, string);
            winToPSMap.put(string, string2);
            break;
        }
    }

    static void getFontDirectory(String string) {
        File file = new File(string);
        String[] stringArray = file.list(TTFilter.getInstance());
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + "/" + stringArray[i];
            boolean bl = false;
            try {
                AWTFontUtils.parseFile(string2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void getPostscriptNameMap() {
        Object object;
        String[] stringArray = new String[3];
        int n = 0;
        String string = System.getProperty("user.home");
        if (isWindows) {
            String string2 = ":\\Windows\\Fonts";
            for (char c = 'C'; c < 'F'; c = (char)(c + '\u0001')) {
                String string3 = Character.toString(c) + string2;
                object = new File(string3);
                if (!((File)object).exists()) continue;
                stringArray[n++] = string3;
                break;
            }
            if (n == 0) {
                return;
            }
        } else if (isOSX) {
            if (string != null) {
                stringArray[n++] = string + "/Library/Fonts";
            }
            stringArray[n++] = "/Library/Fonts";
            stringArray[n++] = "/System/Library/Fonts";
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            object = new File(stringArray[i]);
            long l2 = ((File)object).lastModified();
            if (l2 <= l) continue;
            l = l2;
        }
        String string4 = "";
        if (!isOSX && !isWindows) {
            try {
                string4 = InetAddress.getLocalHost().getHostName();
                string4 = "-" + string4 + "-";
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        object = File.separator;
        if (string != null) {
            String string5 = string + (String)object + ".javafx" + (String)object + "fontNameMap" + string4 + ".properties";
            File file = new File(string5);
            long l3 = file.lastModified();
            boolean bl = false;
            if (l3 > l) {
                try {
                    AWTFontUtils.readCache(file);
                    bl = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!bl) {
                try {
                    AWTFontUtils.buildCache(stringArray, n);
                    AWTFontUtils.writeCache(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static void buildCache(String[] stringArray, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            AWTFontUtils.getFontDirectory(stringArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readCache(File file) throws IOException {
        Object object;
        Properties properties = new Properties();
        BufferedInputStream bufferedInputStream = null;
        try {
            object = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream((InputStream)object);
            properties.load(bufferedInputStream);
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        object = properties.propertyNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            String string2 = properties.getProperty(string);
            psToWinMap.put(string, string2);
            winToPSMap.put(string2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void writeCache(File file) throws IOException {
        FileOutputStream fileOutputStream;
        Properties properties = new Properties();
        Set<String> set = psToWinMap.keySet();
        for (String object2 : set) {
            properties.setProperty(object2, psToWinMap.get(object2));
        }
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        FileOutputStream fileOutputStream2 = null;
        try {
            File file3 = File.createTempFile("psmap", null, file2);
            FileOutputStream fileOutputStream3 = new FileOutputStream(file3);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream3);
            properties.store(bufferedOutputStream, "Postscript name to full name mappings");
            bufferedOutputStream.close();
            fileOutputStream = null;
            if (file.exists()) {
                file.delete();
            }
            file3.renameTo(file);
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            if (fileOutputStream2 == null) throw throwable;
            fileOutputStream2.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    static String getAltName(String string) {
        if (osName == null) {
            osName = System.getProperty("os.name");
            isOSX = osName.startsWith("Mac");
            isWindows = osName.startsWith("Win");
        }
        if (!isOSX && !isWindows) {
            return null;
        }
        if (isWindows && string.indexOf(32) != -1) {
            return null;
        }
        if (psToWinMap == null) {
            psToWinMap = new HashMap();
            winToPSMap = new HashMap();
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        AWTFontUtils.getPostscriptNameMap();
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isOSX) {
            return winToPSMap.get(string);
        }
        if (isWindows) {
            return psToWinMap.get(string);
        }
        return null;
    }

    static {
        try {
            KERNING = TextAttribute.class.getField("KERNING").get(null);
            KERNING_ON = TextAttribute.class.getField("KERNING_ON").get(null);
            LIGATURES = TextAttribute.class.getField("LIGATURES").get(null);
            LIGATURES_ON = TextAttribute.class.getField("LIGATURES_ON").get(null);
            TRACKING = TextAttribute.class.getField("TRACKING").get(null);
        }
        catch (Exception exception) {
            TRACKING = "unsupported";
            LIGATURES_ON = "unsupported";
            LIGATURES = "unsupported";
            KERNING_ON = "unsupported";
            KERNING = "unsupported";
        }
        DEFAULT_FRC = new FontRenderContext(null, false, false);
        fontDesignMetricsInitialized = false;
        compositeFontMethodsInitialized = false;
        getCompositeFontUIResource = null;
        fontSupportsDefaultEncoding = null;
        data = new byte[8192];
        buffer = new Buffer(data);
        psToWinMap = null;
        winToPSMap = null;
        osName = null;
        isOSX = false;
        isWindows = false;
    }

    static class Buffer {
        byte[] data;
        int pos;

        Buffer(byte[] byArray) {
            this.data = byArray;
        }

        void init(byte[] byArray) {
            this.data = byArray;
            this.pos = 0;
        }

        int getInt() {
            int n = this.data[this.pos++] & 0xFF;
            n <<= 8;
            n |= this.data[this.pos++] & 0xFF;
            n <<= 8;
            n |= this.data[this.pos++] & 0xFF;
            n <<= 8;
            return n |= this.data[this.pos++] & 0xFF;
        }

        short getShort(int n) {
            int n2 = this.data[n++] & 0xFF;
            n2 <<= 8;
            return (short)(n2 |= this.data[n++] & 0xFF);
        }

        short getShort() {
            int n = this.data[this.pos++] & 0xFF;
            n <<= 8;
            return (short)(n |= this.data[this.pos++] & 0xFF);
        }

        char getChar(int n) {
            int n2 = this.data[n++] & 0xFF;
            n2 <<= 8;
            return (char)(n2 |= this.data[n++] & 0xFF);
        }

        char getChar() {
            int n = this.data[this.pos++] & 0xFF;
            n <<= 8;
            return (char)(n |= this.data[this.pos++] & 0xFF);
        }

        byte get() {
            return this.data[this.pos++];
        }

        void skip(int n) {
            this.pos += n;
        }

        void get(int n, byte[] byArray, int n2, int n3) {
            System.arraycopy(this.data, n, byArray, n2, n3);
        }
    }

    static class TTFilter
    implements FilenameFilter {
        static TTFilter ttFilter;

        public boolean accept(File file, String string) {
            int n = string.length() - 4;
            if (n <= 0) {
                return false;
            }
            return string.startsWith(".ttf", n) || string.startsWith(".TTF", n) || string.startsWith(".ttc", n) || string.startsWith(".TTC", n);
        }

        private TTFilter() {
        }

        static TTFilter getInstance() {
            if (ttFilter == null) {
                ttFilter = new TTFilter();
            }
            return ttFilter;
        }
    }
}

