/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.swing;

import com.sun.scenario.paint.ProportionalPaint;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class BackgroundSupport
implements PropertyChangeListener {
    public static final String BACKGROUND_PAINT_PROPERTY = "backgroundPaint";
    private Paint backgroundPaint;
    private Paint validBackgroundPaint;
    private int bgw;
    private int bgh;
    private BackgroundSupportable comp;
    private static final Color NOCOLOR = new Color(0, 0, 0, 0){

        public String toString() {
            return "NOCOLOR";
        }

        public boolean equals(Object object) {
            return object == this;
        }
    };

    public BackgroundSupport(BackgroundSupportable backgroundSupportable) {
        this.comp = backgroundSupportable;
        this.backgroundPaint = backgroundSupportable.getBackground();
        backgroundSupportable.addPropertyChangeListener("background", this);
    }

    public void setBackgroundPaint(Paint paint) {
        Paint paint2 = this.backgroundPaint;
        this.backgroundPaint = paint;
        this.validBackgroundPaint = null;
        if (paint == null) {
            this.comp.setBackground(NOCOLOR);
            this.comp.setOpaque(false);
        } else if (paint instanceof Color && ((Color)paint).getAlpha() == 255) {
            this.comp.setBackground((Color)paint);
            this.comp.setOpaque(true);
        } else {
            this.comp.setBackground(NOCOLOR);
            this.comp.setOpaque(false);
        }
        if (paint2 == null ? paint != null : !paint2.equals(paint)) {
            this.comp.repaint();
        }
        this.comp.fireBackgroundPaintChange(paint2, paint);
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Color color = (Color)propertyChangeEvent.getNewValue();
        if (color != this.backgroundPaint && color != NOCOLOR) {
            this.setBackgroundPaint(color);
        }
    }

    public void paintBackground(Graphics graphics) {
        boolean bl;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.comp.isOpaque()) {
            Color color;
            Rectangle rectangle = graphics2D.getClipBounds();
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, this.comp.getWidth(), this.comp.getHeight());
            }
            if ((color = this.comp.getBackground()) == null || color.equals(NOCOLOR)) {
                color = Color.WHITE;
            }
            graphics2D.setColor(color);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            bl = this.backgroundPaint != null && color != this.backgroundPaint;
        } else {
            boolean bl2 = bl = this.backgroundPaint != null;
        }
        if (bl) {
            int n = this.comp.getWidth();
            int n2 = this.comp.getHeight();
            if (this.validBackgroundPaint == null || n != this.bgw || n2 != this.bgh) {
                if (this.backgroundPaint instanceof ProportionalPaint) {
                    ProportionalPaint proportionalPaint = (ProportionalPaint)this.backgroundPaint;
                    this.validBackgroundPaint = proportionalPaint.getPaint(0.0, 0.0, (double)n, (double)n2);
                } else {
                    this.validBackgroundPaint = this.backgroundPaint;
                }
                this.bgw = n;
                this.bgh = n2;
            }
            graphics2D.setPaint(this.validBackgroundPaint);
            graphics2D.fillRect(0, 0, n, n2);
        }
        graphics2D.dispose();
    }

    public static interface BackgroundSupportable {
        public Color getBackground();

        public void setBackground(Color var1);

        public boolean isOpaque();

        public void setOpaque(boolean var1);

        public void repaint();

        public int getWidth();

        public int getHeight();

        public void addPropertyChangeListener(String var1, PropertyChangeListener var2);

        public void fireBackgroundPaintChange(Paint var1, Paint var2);
    }
}

