/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.swing;

import com.sun.embeddedswing.FullScreenEventsMonitor;
import com.sun.embeddedswing.SwingGlueLayer;
import com.sun.javafx.tk.swing.FullScreenFrame;
import java.awt.AWTEvent;
import java.awt.AWTPermission;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.swing.JFrame;

public class FullScreenManager {
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private static Boolean isFSExclusiveModeAllowed;
    private static AccessControlContext initContext;
    private static Method isSystemGeneratedM;
    private static Object awtEventAccessor;
    private static boolean isFSEnterAllowed;
    private static final AWTPermission fsPermission;
    private static final HashMap<GraphicsDevice, FullScreenFrame> fakeFrames;

    public static synchronized void init() {
        if (isFSExclusiveModeAllowed == null && !(isFSExclusiveModeAllowed = Boolean.valueOf(FullScreenManager.checkFSPermission())).booleanValue()) {
            initContext = AccessController.getContext();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Class<?> clazz = Class.forName("sun.awt.AWTAccessor", true, null);
                        Method method = clazz.getMethod("getAWTEventAccessor", null);
                        method.setAccessible(true);
                        Object object = method.invoke(null, (Object[])null);
                        if (object != null) {
                            isSystemGeneratedM = object.getClass().getMethod("isSystemGenerated", AWTEvent.class);
                            isSystemGeneratedM.setAccessible(true);
                            awtEventAccessor = object;
                        }
                    }
                    catch (Throwable throwable) {
                        isSystemGeneratedM = null;
                        awtEventAccessor = null;
                    }
                    return null;
                }
            });
            if (isSystemGeneratedM != null) {
                SwingGlueLayer.getSwingGlueLayer().setFullScreenEventsMonitor(new FullScreenEventsMonitor(){

                    public void checkFullScreenEnterAllowed(AWTEvent aWTEvent) {
                        FullScreenManager.checkFullScreenEnterAllowed(aWTEvent);
                    }

                    public void disableFullScreenEnter() {
                        isFSEnterAllowed = false;
                    }
                });
            }
        }
    }

    private static final boolean checkFSPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(fsPermission);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    private static boolean isSystemGeneratedEvent(AWTEvent aWTEvent) {
        if (isSystemGeneratedM != null) {
            try {
                Object object = isSystemGeneratedM.invoke(awtEventAccessor, aWTEvent);
                if (object instanceof Boolean) {
                    return (Boolean)object;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    private static void checkFullScreenEnterAllowed(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        if (n == 401 || n == 402 || n == 400 || n == 501 || n == 502 || n == 500) {
            if (aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == 27) {
                return;
            }
            InputEvent inputEvent = (InputEvent)aWTEvent;
            long l = System.currentTimeMillis() - inputEvent.getWhen();
            if (!inputEvent.isConsumed() && l < 500L && FullScreenManager.isSystemGeneratedEvent(aWTEvent) && FullScreenManager.checkFSPermission()) {
                isFSEnterAllowed = true;
            }
        }
    }

    static boolean isFSExclusiveModeAllowed() {
        if (isFSExclusiveModeAllowed == null) {
            return false;
        }
        return isFSExclusiveModeAllowed;
    }

    public static FullScreenFrame createFSFrame(final GraphicsConfiguration graphicsConfiguration) {
        if (!FullScreenManager.isFSExclusiveModeAllowed()) {
            PrivilegedAction<FullScreenFrame> privilegedAction = new PrivilegedAction<FullScreenFrame>(){

                @Override
                public FullScreenFrame run() {
                    return new FullScreenFrame(graphicsConfiguration, isFSEnterAllowed);
                }
            };
            return AccessController.doPrivileged(privilegedAction, isFSEnterAllowed ? null : initContext);
        }
        return new FullScreenFrame(graphicsConfiguration, false);
    }

    private static void enterFakeFSMode(JFrame jFrame, GraphicsDevice graphicsDevice) {
        FullScreenFrame fullScreenFrame = fakeFrames.get(graphicsDevice);
        if (fullScreenFrame != null) {
            fakeFrames.remove(graphicsDevice);
            fullScreenFrame.exitFS();
        }
        Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
        jFrame.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        jFrame.setExtendedState(6);
        try {
            jFrame.setAlwaysOnTop(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        jFrame.setVisible(true);
        jFrame.toFront();
        fakeFrames.put(graphicsDevice, (FullScreenFrame)jFrame);
    }

    private static void exitFakeFSMode(JFrame jFrame, GraphicsDevice graphicsDevice) {
        fakeFrames.remove(graphicsDevice);
        jFrame.dispose();
    }

    public static void enterFullScreenExclusiveMode(final Window window, final GraphicsDevice graphicsDevice) {
        if (!FullScreenManager.isFSExclusiveModeAllowed()) {
            PrivilegedAction<Object> privilegedAction = new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (isWindows) {
                        FullScreenManager.enterFakeFSMode((JFrame)window, graphicsDevice);
                    } else {
                        graphicsDevice.setFullScreenWindow(window);
                    }
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedAction, isFSEnterAllowed ? null : initContext);
        } else if (isWindows) {
            FullScreenManager.enterFakeFSMode((JFrame)window, graphicsDevice);
        } else {
            graphicsDevice.setFullScreenWindow(window);
        }
    }

    public static void exitFullScreenExclusiveMode(final Window window) {
        final GraphicsDevice graphicsDevice = window.getGraphicsConfiguration().getDevice();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (isWindows) {
                    FullScreenManager.exitFakeFSMode((JFrame)window, graphicsDevice);
                } else {
                    graphicsDevice.setFullScreenWindow(null);
                }
                return null;
            }
        });
    }

    static {
        fsPermission = new AWTPermission("fullScreenExclusive");
        fakeFrames = new HashMap(0);
    }
}

