/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.swing;

import com.sun.javafx.scene.transfer.Clipboard;
import com.sun.javafx.scene.transfer.UTI;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;

public class UtiTransferable
implements Transferable {
    private final UTI _uti;
    private final Clipboard _board;
    private final Object _content;

    public UtiTransferable(UTI uTI) {
        this(uTI, null, null);
    }

    public UtiTransferable(UTI uTI, Object object) {
        this(uTI, null, object);
    }

    public UtiTransferable(Clipboard clipboard) {
        this(null, clipboard, null);
    }

    private UtiTransferable(UTI uTI, Clipboard clipboard, Object object) {
        this._uti = uTI;
        this._board = clipboard;
        this._content = object;
    }

    public UTI getUTI() {
        if (this._uti != null) {
            return this._uti;
        }
        if (this._board != null) {
            return this._board.getContentType();
        }
        return null;
    }

    public Object getTransferData(DataFlavor dataFlavor) {
        if (this._content != null) {
            return this._content;
        }
        if (this._board != null) {
            return this._board.getContent();
        }
        return null;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            return false;
        }
        for (DataFlavor dataFlavor2 : this.getTransferDataFlavors()) {
            if (!dataFlavor2.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public DataFlavor[] getTransferDataFlavors() {
        UTI uTI = this.getUTI();
        try {
            if (uTI.conformsTo(UTI.TEXT)) {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }
            if (uTI.conformsTo(UTI.IMAGE)) {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }
            if (uTI.conformsTo(UTI.JAVA_FILE_LIST)) {
                return new DataFlavor[]{DataFlavor.javaFileListFlavor};
            }
            ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
            for (String string : uTI.getMimeTypes()) {
                arrayList.add(new DataFlavor(string));
            }
            return arrayList.toArray(new DataFlavor[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return new DataFlavor[0];
        }
    }
}

