/*
 * The contents of this file are subject to the JOnAS Public License Version 
 * 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License on the JOnAS web site.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific terms governing rights and limitations under 
 * the License.
 *
 * The Original Code is JOnAS application server code released July 1999.
 *
 * The Initial Developer of the Original Code is Bull S.A.
 * The Original Code and portions created by Bull S.A. are
 *    Copyright (C) 1999 Bull S.A. All Rights Reserved.
 *
 * Contributor(s): ______________________________________.
 *
 * --------------------------------------------------------------------------
 * $Id: TraceTimer.java,v 1.3 2000/12/15 15:09:19 jonas Exp $
 * --------------------------------------------------------------------------
 */

package org.objectweb.jonas_timer;

import java.io.PrintWriter;

public class TraceTimer {
    
    static public boolean isDebug = false;	// if the timer is logged
    static public boolean isVerbose = false;	// if we print the verbose message
    static public PrintWriter logWriter = null;	// our log writer
    
    /**
     * set the debug timer
     */
    static public void setDebug(boolean set) {
	isDebug = set;
    }

    /**
     * set the verbose flag
     */
    static public void setVerbose(boolean set) {
	isVerbose = set;
    }
    
    /**
     * set the log writer
     */
    static public void setLogWriter(PrintWriter log) {
	logWriter = log;
    }
    
    /**
     * print the verbose message if the logger is not null
     */
    static public void verbose(String msg) {
	if ((isVerbose) && (logWriter != null))
	    logWriter.println(msg);
    }

    /**
     * print the debug timer message if the logger is not null
     */
    static public void debug(String msg) {
	if ((isDebug) && (logWriter != null))
	    logWriter.println(msg);
    }

    /**
     * print the error message if the logger is not null
     */
    static public void error(String msg) {
	if (logWriter != null)
	    logWriter.println(msg);
    }

    /**
     * print the throwing message if the logger is not null
     */
    static public void error(String msg, Throwable th) {
	if (logWriter != null) {
	    logWriter.println(msg);
	    th.printStackTrace(logWriter);
	}
    }

}
