/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolvedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolvedDataConnector;
import net.shibboleth.idp.attribute.resolver.ResolverAttributeDefinitionDependency;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginDependencySupport {
    private static final Logger LOG = LoggerFactory.getLogger(PluginDependencySupport.class);

    private PluginDependencySupport() {
    }

    @Deprecated
    @Nonnull
    @NonnullElements
    public static List<IdPAttributeValue<?>> getMergedAttributeValues(@Nonnull AttributeResolverWorkContext workContext, @Nonnull @NonnullElements Collection<ResolverPluginDependency> dependencies) {
        Constraint.isNotNull((Object)((Object)workContext), (String)"Attribute resolution context cannot be null");
        Constraint.isNotNull(dependencies, (String)"Resolver dependency collection cannot be null");
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"PluginDependencySupport#getMergedAttributeValues(AttributeResolverWorkContext, Collection)", null, (String)"PluginDependencySupport#getMergedAttributeValues(AttributeResolverWorkContext, Collection, String)");
        return PluginDependencySupport.getMergedAttributeValues(workContext, dependencies, "<unknown>");
    }

    @Nonnull
    @NonnullElements
    public static List<IdPAttributeValue<?>> getMergedAttributeValues(@Nonnull AttributeResolverWorkContext workContext, @Nonnull @NonnullElements Collection<ResolverPluginDependency> dependencies, @Nonnull String attributeDefinitionId) {
        Constraint.isNotNull((Object)((Object)workContext), (String)"Attribute resolution context cannot be null");
        Constraint.isNotNull(dependencies, (String)"Resolver dependency collection cannot be null");
        ArrayList values = new ArrayList();
        for (ResolverPluginDependency dependency : dependencies) {
            ResolvedAttributeDefinition attributeDefinition;
            Constraint.isNotNull((Object)dependency, (String)"Resolver dependency cannot be null");
            String pluginId = dependency.getDependencyPluginId();
            if (dependency instanceof ResolverAttributeDefinitionDependency) {
                attributeDefinition = workContext.getResolvedIdPAttributeDefinitions().get(pluginId);
                IdPAttribute resolvedAttribute = attributeDefinition.getResolvedAttribute();
                PluginDependencySupport.mergeAttributeValues(resolvedAttribute, values);
                continue;
            }
            if (dependency instanceof ResolverDataConnectorDependency) {
                Map<String, IdPAttribute> resolvedAttrs;
                ResolverDataConnectorDependency dataConnectorDependency = (ResolverDataConnectorDependency)dependency;
                ResolvedDataConnector dataConnector = workContext.getResolvedDataConnectors().get(dependency.getDependencyPluginId());
                if (dataConnector == null || null == (resolvedAttrs = dataConnector.getResolvedAttributes())) continue;
                for (Map.Entry<String, IdPAttribute> entry : resolvedAttrs.entrySet()) {
                    if (!dataConnectorDependency.isAllAttributes() && !dataConnectorDependency.getAttributeNames().contains(entry.getKey())) continue;
                    PluginDependencySupport.mergeAttributeValues(entry.getValue(), values);
                }
                continue;
            }
            attributeDefinition = workContext.getResolvedIdPAttributeDefinitions().get(pluginId);
            String dependencyAttributeId = dependency.getDependencyAttributeId();
            if (attributeDefinition != null) {
                if (null == dependencyAttributeId) {
                    LOG.warn("Plugin '{}' was defined without a sourceAttributeID,  but attribute '{}', specified as a <Dependency> will be used.", (Object)attributeDefinitionId, (Object)pluginId);
                } else if (!dependencyAttributeId.equals(pluginId)) {
                    LOG.warn("Plugin '{}' was defined with a sourceAttributeID '{}', but the attribute definition '{}', specified as a <Dependency> will be used as well.", new Object[]{attributeDefinitionId, dependencyAttributeId, pluginId});
                }
                IdPAttribute resolvedAttribute = attributeDefinition.getResolvedAttribute();
                PluginDependencySupport.mergeAttributeValues(resolvedAttribute, values);
                continue;
            }
            ResolvedDataConnector dataConnector = workContext.getResolvedDataConnectors().get(dependency.getDependencyPluginId());
            if (dataConnector == null) continue;
            if (dependency.getDependencyAttributeId() == null) {
                LOG.error("Attribute definition '{}' has a data connector dependency '{}' but no sourceAttributeID.", (Object)attributeDefinitionId, (Object)dataConnector.getId());
                return Collections.EMPTY_LIST;
            }
            if (null == dataConnector.getResolvedAttributes()) continue;
            IdPAttribute resolvedAttribute = dataConnector.getResolvedAttributes().get(dependency.getDependencyAttributeId());
            PluginDependencySupport.mergeAttributeValues(resolvedAttribute, values);
        }
        return values;
    }

    public static Map<String, List<IdPAttributeValue<?>>> getAllAttributeValues(@Nonnull AttributeResolverWorkContext workContext, @Nonnull Collection<ResolverPluginDependency> dependencies) {
        HashMap result = new HashMap();
        for (ResolverPluginDependency dependency : dependencies) {
            ResolvedDataConnector dataConnector;
            ResolvedAttributeDefinition attributeDefinition;
            Constraint.isNotNull((Object)dependency, (String)"Resolver dependency cannot be null");
            if (dependency instanceof ResolverAttributeDefinitionDependency) {
                attributeDefinition = workContext.getResolvedIdPAttributeDefinitions().get(dependency.getDependencyPluginId());
                if (attributeDefinition == null) continue;
                PluginDependencySupport.addAttribute(attributeDefinition.getResolvedAttribute(), result);
                continue;
            }
            if (dependency instanceof ResolverDataConnectorDependency) {
                Map<String, IdPAttribute> resolvedAttrs;
                ResolverDataConnectorDependency dataConnectorDependency = (ResolverDataConnectorDependency)dependency;
                dataConnector = workContext.getResolvedDataConnectors().get(dependency.getDependencyPluginId());
                if (dataConnector == null || null == (resolvedAttrs = dataConnector.getResolvedAttributes())) continue;
                for (Map.Entry<String, IdPAttribute> entry : resolvedAttrs.entrySet()) {
                    if (!dataConnectorDependency.isAllAttributes() && !dataConnectorDependency.getAttributeNames().contains(entry.getKey())) continue;
                    PluginDependencySupport.addAttribute(entry.getValue(), result);
                }
                continue;
            }
            attributeDefinition = workContext.getResolvedIdPAttributeDefinitions().get(dependency.getDependencyPluginId());
            if (attributeDefinition != null) {
                PluginDependencySupport.addAttribute(attributeDefinition.getResolvedAttribute(), result);
                continue;
            }
            dataConnector = workContext.getResolvedDataConnectors().get(dependency.getDependencyPluginId());
            if (dataConnector == null || null == dataConnector.getResolvedAttributes()) continue;
            PluginDependencySupport.mergeAttributes(dataConnector.getResolvedAttributes(), result);
        }
        return result;
    }

    @Nonnull
    private static void mergeAttributes(@Nonnull Map<String, IdPAttribute> sources, @Nullable Map<String, List<IdPAttributeValue<?>>> target) {
        for (IdPAttribute source : sources.values()) {
            if (source == null) continue;
            PluginDependencySupport.addAttribute(source, target);
        }
    }

    @Nonnull
    private static void addAttribute(@Nullable IdPAttribute source, @Nullable Map<String, List<IdPAttributeValue<?>>> target) {
        if (source == null) {
            return;
        }
        List<IdPAttributeValue<?>> attributeValues = target.get(source.getId());
        if (attributeValues == null) {
            attributeValues = new ArrayList();
            target.put(source.getId(), attributeValues);
        }
        PluginDependencySupport.mergeAttributeValues(source, attributeValues);
    }

    @Nonnull
    private static void mergeAttributeValues(@Nullable IdPAttribute source, @Nonnull List<IdPAttributeValue<?>> target) {
        if (source != null) {
            target.addAll(source.getValues());
        }
    }
}

