/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolvedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolvedDataConnector;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;

@NotThreadSafe
public class AttributeResolverWorkContext
extends BaseContext {
    @Nonnull
    @NonnullElements
    private final Map<String, ResolvedAttributeDefinition> resolvedAttributeDefinitions = new HashMap<String, ResolvedAttributeDefinition>();
    @Nonnull
    @NonnullElements
    private final Map<String, ResolvedDataConnector> resolvedDataConnectors = new HashMap<String, ResolvedDataConnector>();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, ResolvedAttributeDefinition> getResolvedIdPAttributeDefinitions() {
        return Collections.unmodifiableMap(this.resolvedAttributeDefinitions);
    }

    public void recordAttributeDefinitionResolution(@Nonnull AttributeDefinition definition, @Nullable IdPAttribute attribute) throws ResolutionException {
        Constraint.isNotNull((Object)definition, (String)"Resolver attribute definition cannot be null");
        if (this.resolvedAttributeDefinitions.containsKey(definition.getId())) {
            throw new ResolutionException("The resolution of attribute definition " + definition.getId() + " has already been recorded");
        }
        ResolvedAttributeDefinition wrapper = new ResolvedAttributeDefinition(definition, attribute);
        this.resolvedAttributeDefinitions.put(definition.getId(), wrapper);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, ResolvedDataConnector> getResolvedDataConnectors() {
        return Collections.unmodifiableMap(this.resolvedDataConnectors);
    }

    public void recordDataConnectorResolution(@Nonnull DataConnector connector, @Nullable Map<String, IdPAttribute> attributes) throws ResolutionException {
        Constraint.isNotNull((Object)connector, (String)"Resolver data connector cannot be null");
        if (this.resolvedDataConnectors.containsKey(connector.getId())) {
            throw new ResolutionException("The resolution of data connector " + connector.getId() + " has already been recorded");
        }
        ResolvedDataConnector wrapper = new ResolvedDataConnector(connector, attributes);
        this.resolvedDataConnectors.put(connector.getId(), wrapper);
    }

    public void recordFailoverResolution(@Nonnull DataConnector failedConnector, @Nonnull DataConnector failoverConnector) throws ResolutionException {
        if (failoverConnector == null) {
            return;
        }
        if (this.resolvedDataConnectors.containsKey(failedConnector.getId())) {
            throw new ResolutionException("The resolution of data connector " + failedConnector.getId() + " has already been recorded");
        }
        ResolvedDataConnector resolvedFailoverConector = this.resolvedDataConnectors.get(failoverConnector.getId());
        if (null == resolvedFailoverConector) {
            throw new ResolutionException("The resolution of failover conector" + failoverConnector.getId() + " was not recorded");
        }
        ResolvedDataConnector wrapper = new ResolvedDataConnector(failedConnector, resolvedFailoverConector.getResolvedAttributes());
        this.resolvedDataConnectors.put(failedConnector.getId(), wrapper);
    }
}

