/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.MultiTableInputFormatTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMultiTableSnapshotInputFormat
extends org.apache.hadoop.hbase.mapreduce.TestMultiTableSnapshotInputFormat {
    private static final Log LOG = LogFactory.getLog(TestMultiTableSnapshotInputFormat.class);

    @Override
    protected void runJob(String jobName, Configuration c, List<Scan> scans) throws IOException, InterruptedException, ClassNotFoundException {
        JobConf job = new JobConf(TEST_UTIL.getConfiguration());
        job.setJobName(jobName);
        job.setMapperClass(Mapper.class);
        job.setReducerClass(Reducer.class);
        TableMapReduceUtil.initMultiTableSnapshotMapperJob(this.getSnapshotScanMapping(scans), Mapper.class, ImmutableBytesWritable.class, ImmutableBytesWritable.class, (JobConf)job, (boolean)true, (Path)this.restoreDir);
        TableMapReduceUtil.addDependencyJars((JobConf)job);
        job.setReducerClass(Reducer.class);
        job.setNumReduceTasks(1);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(job.getJobName()));
        LOG.info((Object)("Started " + job.getJobName()));
        RunningJob runningJob = JobClient.runJob((JobConf)job);
        runningJob.waitForCompletion();
        Assert.assertTrue((boolean)runningJob.isSuccessful());
        LOG.info((Object)("After map/reduce completion - job " + jobName));
    }

    public static class Reducer
    extends MultiTableInputFormatTestBase.ScanReducer
    implements org.apache.hadoop.mapred.Reducer<ImmutableBytesWritable, ImmutableBytesWritable, NullWritable, NullWritable> {
        private JobConf jobConf;

        public void reduce(ImmutableBytesWritable key, Iterator<ImmutableBytesWritable> values, OutputCollector<NullWritable, NullWritable> outputCollector, Reporter reporter) throws IOException {
            this.makeAssertions(key, Lists.newArrayList(values));
        }

        public void close() throws IOException {
            super.cleanup((Configuration)this.jobConf);
        }

        public void configure(JobConf jobConf) {
            this.jobConf = jobConf;
        }
    }

    public static class Mapper
    extends MultiTableInputFormatTestBase.ScanMapper
    implements TableMap<ImmutableBytesWritable, ImmutableBytesWritable> {
        public void map(ImmutableBytesWritable key, Result value, OutputCollector<ImmutableBytesWritable, ImmutableBytesWritable> outputCollector, Reporter reporter) throws IOException {
            this.makeAssertions(key, value);
            outputCollector.collect((Object)key, (Object)key);
        }

        public void close() throws IOException {
        }

        public void configure(JobConf jobConf) {
        }
    }
}

