/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestBaseLoadBalancer
extends BalancerTestBase {
    private static LoadBalancer loadBalancer;
    private static final Log LOG;
    private static final ServerName master;
    private static RackManager rackManager;
    private static final int NUM_SERVERS = 15;
    private static ServerName[] servers;
    int[][] regionsAndServersMocks = new int[][]{{0, 0}, {0, 1}, {1, 1}, {2, 1}, {10, 1}, {1, 2}, {2, 2}, {3, 2}, {1, 3}, {2, 3}, {3, 3}, {25, 3}, {2, 10}, {2, 100}, {12, 10}, {12, 100}};

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setClass("hbase.util.ip.to.rack.determiner", BalancerTestBase.MockMapping.class, DNSToSwitchMapping.class);
        loadBalancer = new MockBalancer();
        loadBalancer.setConf(conf);
        MasterServices st = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)st.getServerName()).thenReturn((Object)master);
        loadBalancer.setMasterServices(st);
        rackManager = (RackManager)Mockito.mock(RackManager.class);
        for (int i = 0; i < 15; ++i) {
            TestBaseLoadBalancer.servers[i] = ServerName.valueOf((String)("foo" + i + ":1234"), (long)-1L);
            if (i < 5) {
                Mockito.when((Object)rackManager.getRack(servers[i])).thenReturn((Object)"rack1");
            }
            if (i >= 5 && i < 10) {
                Mockito.when((Object)rackManager.getRack(servers[i])).thenReturn((Object)"rack2");
            }
            if (i < 10) continue;
            Mockito.when((Object)rackManager.getRack(servers[i])).thenReturn((Object)"rack3");
        }
    }

    @Test(timeout=30000L)
    public void testImmediateAssignment() throws Exception {
        for (int[] mock : this.regionsAndServersMocks) {
            LOG.debug((Object)("testImmediateAssignment with " + mock[0] + " regions and " + mock[1] + " servers"));
            List<HRegionInfo> regions = this.randomRegions(mock[0]);
            List<ServerAndLoad> servers = this.randomServers(mock[1], 0);
            List<ServerName> list = this.getListOfServerNames(servers);
            Map assignments = loadBalancer.immediateAssignment(regions, list);
            this.assertImmediateAssignment(regions, list, assignments);
            this.returnRegions(regions);
            this.returnServers(list);
        }
    }

    private void assertImmediateAssignment(List<HRegionInfo> regions, List<ServerName> servers, Map<HRegionInfo, ServerName> assignments) {
        for (HRegionInfo region : regions) {
            Assert.assertTrue((boolean)assignments.containsKey(region));
        }
    }

    @Test(timeout=180000L)
    public void testBulkAssignment() throws Exception {
        for (int[] mock : this.regionsAndServersMocks) {
            LOG.debug((Object)("testBulkAssignment with " + mock[0] + " regions and " + mock[1] + " servers"));
            List<HRegionInfo> regions = this.randomRegions(mock[0]);
            List<ServerAndLoad> servers = this.randomServers(mock[1], 0);
            List<ServerName> list = this.getListOfServerNames(servers);
            Map assignments = loadBalancer.roundRobinAssignment(regions, list);
            float average = (float)regions.size() / (float)servers.size();
            int min = (int)Math.floor(average);
            int max = (int)Math.ceil(average);
            if (assignments != null && !assignments.isEmpty()) {
                for (List regionList : assignments.values()) {
                    Assert.assertTrue((regionList.size() == min || regionList.size() == max ? 1 : 0) != 0);
                }
            }
            this.returnRegions(regions);
            this.returnServers(list);
        }
    }

    @Test(timeout=180000L)
    public void testRetainAssignment() throws Exception {
        List<ServerAndLoad> servers = this.randomServers(10, 10);
        List<HRegionInfo> regions = this.randomRegions(100);
        TreeMap<HRegionInfo, ServerName> existing = new TreeMap<HRegionInfo, ServerName>();
        for (int i = 0; i < regions.size(); ++i) {
            ServerName sn = servers.get(i % servers.size()).getServerName();
            ServerName snWithOldStartCode = ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)(sn.getStartcode() - 10L));
            existing.put(regions.get(i), snWithOldStartCode);
        }
        List<ServerName> listOfServerNames = this.getListOfServerNames(servers);
        Map assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
        ArrayList<ServerAndLoad> servers2 = new ArrayList<ServerAndLoad>(servers);
        servers2.add(this.randomServer(10));
        servers2.add(this.randomServer(10));
        listOfServerNames = this.getListOfServerNames(servers2);
        assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
        ArrayList<ServerAndLoad> servers3 = new ArrayList<ServerAndLoad>(servers);
        servers3.remove(0);
        servers3.remove(0);
        listOfServerNames = this.getListOfServerNames(servers3);
        assignment = loadBalancer.retainAssignment(existing, listOfServerNames);
        this.assertRetainedAssignment(existing, listOfServerNames, assignment);
    }

    @Test(timeout=180000L)
    public void testRegionAvailability() throws Exception {
        ArrayList<HRegionInfo> list0 = new ArrayList<HRegionInfo>();
        ArrayList<HRegionInfo> list1 = new ArrayList<HRegionInfo>();
        ArrayList<HRegionInfo> list2 = new ArrayList<HRegionInfo>();
        HRegionInfo hri1 = new HRegionInfo(TableName.valueOf((String)"table"), "key1".getBytes(), "key2".getBytes(), false, 100L);
        HRegionInfo hri2 = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)hri1, (int)1);
        HRegionInfo hri3 = new HRegionInfo(TableName.valueOf((String)"table"), "key2".getBytes(), "key3".getBytes(), false, 101L);
        list0.add(hri1);
        list1.add(hri2);
        list2.add(hri3);
        LinkedHashMap clusterState = new LinkedHashMap();
        clusterState.put(servers[0], list0);
        clusterState.put(servers[1], list1);
        clusterState.put(servers[2], list2);
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, rackManager);
        Assert.assertTrue((boolean)cluster.wouldLowerAvailability(hri1, servers[1]));
        Assert.assertTrue((!cluster.wouldLowerAvailability(hri1, servers[2]) ? 1 : 0) != 0);
        Assert.assertTrue((!cluster.wouldLowerAvailability(hri2, servers[2]) ? 1 : 0) != 0);
        Assert.assertTrue((!cluster.wouldLowerAvailability(hri3, servers[1]) ? 1 : 0) != 0);
        list1.add(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)hri3, (int)1));
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, rackManager);
        Assert.assertTrue((boolean)cluster.wouldLowerAvailability(hri3, servers[1]));
        clusterState.clear();
        clusterState.put(servers[0], list0);
        clusterState.put(servers[5], list1);
        clusterState.put(servers[6], list2);
        clusterState.put(servers[10], new ArrayList());
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, rackManager);
        Assert.assertTrue((boolean)cluster.wouldLowerAvailability(hri1, servers[0]));
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        Assert.assertTrue((!cluster.wouldLowerAvailability(hri1, servers[6]) ? 1 : 0) != 0);
    }

    @Test(timeout=180000L)
    public void testRegionAvailabilityWithRegionMoves() throws Exception {
        ArrayList<HRegionInfo> list0 = new ArrayList<HRegionInfo>();
        ArrayList<HRegionInfo> list1 = new ArrayList<HRegionInfo>();
        ArrayList<HRegionInfo> list2 = new ArrayList<HRegionInfo>();
        HRegionInfo hri1 = new HRegionInfo(TableName.valueOf((String)"table"), "key1".getBytes(), "key2".getBytes(), false, 100L);
        HRegionInfo hri2 = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)hri1, (int)1);
        HRegionInfo hri3 = new HRegionInfo(TableName.valueOf((String)"table"), "key2".getBytes(), "key3".getBytes(), false, 101L);
        list0.add(hri1);
        list1.add(hri2);
        list2.add(hri3);
        LinkedHashMap clusterState = new LinkedHashMap();
        clusterState.put(servers[0], list0);
        clusterState.put(servers[1], list1);
        clusterState.put(servers[2], list2);
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, rackManager);
        Assert.assertTrue((!cluster.wouldLowerAvailability(hri1, servers[2]) ? 1 : 0) != 0);
        cluster.doAction((BaseLoadBalancer.Cluster.Action)new BaseLoadBalancer.Cluster.MoveRegionAction(0, 0, 2));
        Assert.assertTrue((boolean)cluster.wouldLowerAvailability(hri1, servers[2]));
        clusterState.clear();
        ArrayList<HRegionInfo> list3 = new ArrayList<HRegionInfo>();
        HRegionInfo hri4 = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)hri3, (int)1);
        list3.add(hri4);
        clusterState.put(servers[0], list0);
        clusterState.put(servers[5], list1);
        clusterState.put(servers[6], list2);
        clusterState.put(servers[12], list3);
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, rackManager);
        Assert.assertTrue((!cluster.wouldLowerAvailability(hri4, servers[0]) ? 1 : 0) != 0);
        cluster.doAction((BaseLoadBalancer.Cluster.Action)new BaseLoadBalancer.Cluster.MoveRegionAction(2, 2, 0));
        Assert.assertTrue((boolean)cluster.wouldLowerAvailability(hri3, servers[0]));
    }

    private List<ServerName> getListOfServerNames(List<ServerAndLoad> sals) {
        ArrayList<ServerName> list = new ArrayList<ServerName>();
        for (ServerAndLoad e : sals) {
            list.add(e.getServerName());
        }
        return list;
    }

    private void assertRetainedAssignment(Map<HRegionInfo, ServerName> existing, List<ServerName> servers, Map<ServerName, List<HRegionInfo>> assignment) {
        TreeSet<ServerName> onlineServerSet = new TreeSet<ServerName>(servers);
        TreeSet<HRegionInfo> assignedRegions = new TreeSet<HRegionInfo>();
        for (Map.Entry<ServerName, List<HRegionInfo>> a : assignment.entrySet()) {
            Assert.assertTrue((String)"Region assigned to server that was not listed as online", (boolean)onlineServerSet.contains(a.getKey()));
            for (HRegionInfo r : a.getValue()) {
                assignedRegions.add(r);
            }
        }
        Assert.assertEquals((long)existing.size(), (long)assignedRegions.size());
        TreeSet<String> onlineHostNames = new TreeSet<String>();
        for (ServerName serverName : servers) {
            onlineHostNames.add(serverName.getHostname());
        }
        for (Map.Entry entry : assignment.entrySet()) {
            ServerName assignedTo = (ServerName)entry.getKey();
            for (HRegionInfo r : (List)entry.getValue()) {
                ServerName address = existing.get(r);
                if (address == null || !onlineHostNames.contains(address.getHostname())) continue;
                Assert.assertEquals((Object)address.getHostname(), (Object)assignedTo.getHostname());
            }
        }
    }

    @Test(timeout=180000L)
    public void testClusterServersWithSameHostPort() {
        List<ServerName> servers = this.getListOfServerNames(this.randomServers(10, 10));
        List<HRegionInfo> regions = this.randomRegions(101);
        HashMap<ServerName, List<HRegionInfo>> clusterState = new HashMap<ServerName, List<HRegionInfo>>();
        this.assignRegions(regions, servers, clusterState);
        ArrayList<ServerName> oldServers = new ArrayList<ServerName>(servers.size());
        for (ServerName sn : servers) {
            oldServers.add(ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)(sn.getStartcode() - 10L)));
        }
        regions = this.randomRegions(9);
        this.assignRegions(regions, oldServers, clusterState);
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        Assert.assertEquals((long)110L, (long)cluster.numRegions);
        Assert.assertEquals((long)10L, (long)cluster.numServers);
    }

    private void assignRegions(List<HRegionInfo> regions, List<ServerName> servers, Map<ServerName, List<HRegionInfo>> clusterState) {
        for (int i = 0; i < regions.size(); ++i) {
            ServerName sn = servers.get(i % servers.size());
            List<HRegionInfo> regionsOfServer = clusterState.get(sn);
            if (regionsOfServer == null) {
                regionsOfServer = new ArrayList<HRegionInfo>(10);
                clusterState.put(sn, regionsOfServer);
            }
            regionsOfServer.add(regions.get(i));
        }
    }

    @Test(timeout=180000L)
    public void testClusterRegionLocations() {
        List<ServerName> servers = this.getListOfServerNames(this.randomServers(10, 10));
        List<HRegionInfo> regions = this.randomRegions(101);
        HashMap<ServerName, List<HRegionInfo>> clusterState = new HashMap<ServerName, List<HRegionInfo>>();
        this.assignRegions(regions, servers, clusterState);
        RegionLocationFinder locationFinder = (RegionLocationFinder)Mockito.mock(RegionLocationFinder.class);
        Mockito.when((Object)locationFinder.getTopBlockLocations(regions.get(0))).thenReturn((Object)Lists.newArrayList((Object[])new ServerName[]{servers.get(0)}));
        Mockito.when((Object)locationFinder.getTopBlockLocations(regions.get(1))).thenReturn((Object)Lists.newArrayList((Object[])new ServerName[]{servers.get(0), servers.get(1)}));
        Mockito.when((Object)locationFinder.getTopBlockLocations(regions.get(42))).thenReturn((Object)Lists.newArrayList((Object[])new ServerName[]{servers.get(4), servers.get(9), servers.get(5)}));
        Mockito.when((Object)locationFinder.getTopBlockLocations(regions.get(43))).thenReturn((Object)Lists.newArrayList((Object[])new ServerName[]{ServerName.valueOf((String)"foo", (int)0, (long)0L)}));
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(clusterState, null, locationFinder, null);
        int r0 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(0));
        int r1 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(1));
        int r10 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(10));
        int r42 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(42));
        int r43 = ArrayUtils.indexOf((Object[])cluster.regions, (Object)regions.get(43));
        int s0 = (Integer)cluster.serversToIndex.get(servers.get(0).getHostAndPort());
        int s1 = (Integer)cluster.serversToIndex.get(servers.get(1).getHostAndPort());
        int s4 = (Integer)cluster.serversToIndex.get(servers.get(4).getHostAndPort());
        int s5 = (Integer)cluster.serversToIndex.get(servers.get(5).getHostAndPort());
        int s9 = (Integer)cluster.serversToIndex.get(servers.get(9).getHostAndPort());
        Assert.assertEquals((long)1L, (long)cluster.regionLocations[r0].length);
        Assert.assertEquals((long)s0, (long)cluster.regionLocations[r0][0]);
        Assert.assertEquals((long)2L, (long)cluster.regionLocations[r1].length);
        Assert.assertEquals((long)s0, (long)cluster.regionLocations[r1][0]);
        Assert.assertEquals((long)s1, (long)cluster.regionLocations[r1][1]);
        Assert.assertEquals((long)0L, (long)cluster.regionLocations[r10].length);
        Assert.assertEquals((long)3L, (long)cluster.regionLocations[r42].length);
        Assert.assertEquals((long)s4, (long)cluster.regionLocations[r42][0]);
        Assert.assertEquals((long)s9, (long)cluster.regionLocations[r42][1]);
        Assert.assertEquals((long)s5, (long)cluster.regionLocations[r42][2]);
        Assert.assertEquals((long)1L, (long)cluster.regionLocations[r43].length);
        Assert.assertEquals((long)-1L, (long)cluster.regionLocations[r43][0]);
    }

    static {
        LOG = LogFactory.getLog(TestBaseLoadBalancer.class);
        master = ServerName.valueOf((String)"fake-master", (int)0, (long)1L);
        servers = new ServerName[15];
    }

    public static class MockBalancer
    extends BaseLoadBalancer {
        public List<RegionPlan> balanceCluster(Map<ServerName, List<HRegionInfo>> clusterState) {
            return null;
        }
    }
}

