/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.normalizer.MergeNormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.SimpleRegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.SplitNormalizationPlan;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestSimpleRegionNormalizer {
    private static final Log LOG = LogFactory.getLog(TestSimpleRegionNormalizer.class);
    private static RegionNormalizer normalizer;
    private static MasterServices masterServices;

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        normalizer = new SimpleRegionNormalizer();
    }

    @Test
    public void testNoNormalizationForMetaTable() throws HBaseIOException {
        TableName testTable = TableName.META_TABLE_NAME;
        ArrayList<HRegionInfo> hris = new ArrayList<HRegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        this.setupMocksForNormalizer(regionSizes, hris);
        List plans = normalizer.computePlanForTable(testTable);
        Assert.assertTrue((plans == null ? 1 : 0) != 0);
    }

    @Test
    public void testNoNormalizationIfTooFewRegions() throws HBaseIOException {
        TableName testTable = TableName.valueOf((String)"testSplitOfSmallRegion");
        ArrayList<HRegionInfo> hris = new ArrayList<HRegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        HRegionInfo hri1 = new HRegionInfo(testTable, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"));
        hris.add(hri1);
        regionSizes.put(hri1.getRegionName(), 10);
        HRegionInfo hri2 = new HRegionInfo(testTable, Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"));
        hris.add(hri2);
        regionSizes.put(hri2.getRegionName(), 15);
        this.setupMocksForNormalizer(regionSizes, hris);
        List plans = normalizer.computePlanForTable(testTable);
        Assert.assertTrue((plans == null ? 1 : 0) != 0);
    }

    @Test
    public void testNoNormalizationOnNormalizedCluster() throws HBaseIOException {
        TableName testTable = TableName.valueOf((String)"testSplitOfSmallRegion");
        ArrayList<HRegionInfo> hris = new ArrayList<HRegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        HRegionInfo hri1 = new HRegionInfo(testTable, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"));
        hris.add(hri1);
        regionSizes.put(hri1.getRegionName(), 10);
        HRegionInfo hri2 = new HRegionInfo(testTable, Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"));
        hris.add(hri2);
        regionSizes.put(hri2.getRegionName(), 15);
        HRegionInfo hri3 = new HRegionInfo(testTable, Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"));
        hris.add(hri3);
        regionSizes.put(hri3.getRegionName(), 8);
        HRegionInfo hri4 = new HRegionInfo(testTable, Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"));
        hris.add(hri4);
        regionSizes.put(hri4.getRegionName(), 10);
        this.setupMocksForNormalizer(regionSizes, hris);
        List plans = normalizer.computePlanForTable(testTable);
        Assert.assertTrue((plans == null ? 1 : 0) != 0);
    }

    @Test
    public void testMergeOfSmallRegions() throws HBaseIOException {
        TableName testTable = TableName.valueOf((String)"testMergeOfSmallRegions");
        ArrayList<HRegionInfo> hris = new ArrayList<HRegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        HRegionInfo hri1 = new HRegionInfo(testTable, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"));
        hris.add(hri1);
        regionSizes.put(hri1.getRegionName(), 15);
        HRegionInfo hri2 = new HRegionInfo(testTable, Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"));
        hris.add(hri2);
        regionSizes.put(hri2.getRegionName(), 5);
        HRegionInfo hri3 = new HRegionInfo(testTable, Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"));
        hris.add(hri3);
        regionSizes.put(hri3.getRegionName(), 5);
        HRegionInfo hri4 = new HRegionInfo(testTable, Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"));
        hris.add(hri4);
        regionSizes.put(hri4.getRegionName(), 15);
        HRegionInfo hri5 = new HRegionInfo(testTable, Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"));
        hris.add(hri5);
        regionSizes.put(hri5.getRegionName(), 16);
        this.setupMocksForNormalizer(regionSizes, hris);
        List plans = normalizer.computePlanForTable(testTable);
        NormalizationPlan plan = (NormalizationPlan)plans.get(0);
        Assert.assertTrue((boolean)(plan instanceof MergeNormalizationPlan));
        Assert.assertEquals((Object)hri2, (Object)((MergeNormalizationPlan)plan).getFirstRegion());
        Assert.assertEquals((Object)hri3, (Object)((MergeNormalizationPlan)plan).getSecondRegion());
    }

    @Test
    public void testMergeOfSecondSmallestRegions() throws HBaseIOException {
        TableName testTable = TableName.valueOf((String)"testMergeOfSmallRegions");
        ArrayList<HRegionInfo> hris = new ArrayList<HRegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        HRegionInfo hri1 = new HRegionInfo(testTable, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"));
        hris.add(hri1);
        regionSizes.put(hri1.getRegionName(), 1);
        HRegionInfo hri2 = new HRegionInfo(testTable, Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"));
        hris.add(hri2);
        regionSizes.put(hri2.getRegionName(), 10000);
        HRegionInfo hri3 = new HRegionInfo(testTable, Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"));
        hris.add(hri3);
        regionSizes.put(hri3.getRegionName(), 10000);
        HRegionInfo hri4 = new HRegionInfo(testTable, Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"));
        hris.add(hri4);
        regionSizes.put(hri4.getRegionName(), 10000);
        HRegionInfo hri5 = new HRegionInfo(testTable, Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"));
        hris.add(hri5);
        regionSizes.put(hri5.getRegionName(), 2700);
        HRegionInfo hri6 = new HRegionInfo(testTable, Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"));
        hris.add(hri6);
        regionSizes.put(hri6.getRegionName(), 2700);
        this.setupMocksForNormalizer(regionSizes, hris);
        List plans = normalizer.computePlanForTable(testTable);
        NormalizationPlan plan = (NormalizationPlan)plans.get(0);
        Assert.assertTrue((boolean)(plan instanceof MergeNormalizationPlan));
        Assert.assertEquals((Object)hri5, (Object)((MergeNormalizationPlan)plan).getFirstRegion());
        Assert.assertEquals((Object)hri6, (Object)((MergeNormalizationPlan)plan).getSecondRegion());
    }

    @Test
    public void testMergeOfSmallNonAdjacentRegions() throws HBaseIOException {
        TableName testTable = TableName.valueOf((String)"testMergeOfSmallRegions");
        ArrayList<HRegionInfo> hris = new ArrayList<HRegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        HRegionInfo hri1 = new HRegionInfo(testTable, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"));
        hris.add(hri1);
        regionSizes.put(hri1.getRegionName(), 15);
        HRegionInfo hri2 = new HRegionInfo(testTable, Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"));
        hris.add(hri2);
        regionSizes.put(hri2.getRegionName(), 5);
        HRegionInfo hri3 = new HRegionInfo(testTable, Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"));
        hris.add(hri3);
        regionSizes.put(hri3.getRegionName(), 16);
        HRegionInfo hri4 = new HRegionInfo(testTable, Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"));
        hris.add(hri4);
        regionSizes.put(hri4.getRegionName(), 15);
        HRegionInfo hri5 = new HRegionInfo(testTable, Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"));
        hris.add(hri4);
        regionSizes.put(hri5.getRegionName(), 5);
        this.setupMocksForNormalizer(regionSizes, hris);
        List plans = normalizer.computePlanForTable(testTable);
        Assert.assertTrue((plans == null ? 1 : 0) != 0);
    }

    @Test
    public void testSplitOfLargeRegion() throws HBaseIOException {
        TableName testTable = TableName.valueOf((String)"testSplitOfLargeRegion");
        ArrayList<HRegionInfo> hris = new ArrayList<HRegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        HRegionInfo hri1 = new HRegionInfo(testTable, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"));
        hris.add(hri1);
        regionSizes.put(hri1.getRegionName(), 8);
        HRegionInfo hri2 = new HRegionInfo(testTable, Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"));
        hris.add(hri2);
        regionSizes.put(hri2.getRegionName(), 6);
        HRegionInfo hri3 = new HRegionInfo(testTable, Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"));
        hris.add(hri3);
        regionSizes.put(hri3.getRegionName(), 10);
        HRegionInfo hri4 = new HRegionInfo(testTable, Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"));
        hris.add(hri4);
        regionSizes.put(hri4.getRegionName(), 30);
        this.setupMocksForNormalizer(regionSizes, hris);
        List plans = normalizer.computePlanForTable(testTable);
        NormalizationPlan plan = (NormalizationPlan)plans.get(0);
        Assert.assertTrue((boolean)(plan instanceof SplitNormalizationPlan));
        Assert.assertEquals((Object)hri4, (Object)((SplitNormalizationPlan)plan).getRegionInfo());
    }

    protected void setupMocksForNormalizer(Map<byte[], Integer> regionSizes, List<HRegionInfo> hris) {
        masterServices = (MasterServices)Mockito.mock(MasterServices.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ServerName sn = ServerName.valueOf((String)"localhost", (int)-1, (long)1L);
        Mockito.when((Object)masterServices.getAssignmentManager().getRegionStates().getRegionsOfTable((TableName)Matchers.any(TableName.class))).thenReturn(hris);
        Mockito.when((Object)masterServices.getAssignmentManager().getRegionStates().getRegionServerOfRegion((HRegionInfo)Matchers.any(HRegionInfo.class))).thenReturn((Object)sn);
        for (Map.Entry<byte[], Integer> region : regionSizes.entrySet()) {
            RegionLoad regionLoad = (RegionLoad)Mockito.mock(RegionLoad.class);
            Mockito.when((Object)regionLoad.getName()).thenReturn((Object)region.getKey());
            Mockito.when((Object)regionLoad.getStorefileSizeMB()).thenReturn((Object)region.getValue());
            Mockito.when(masterServices.getServerManager().getLoad(sn).getRegionsLoad().get(region.getKey())).thenReturn((Object)regionLoad);
        }
        normalizer.setMasterServices(masterServices);
    }
}

