/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.TestLogRolling;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestLogRollAbort {
    private static final Log LOG = LogFactory.getLog(TestLogRolling.class);
    private static MiniDFSCluster dfsCluster;
    private static Admin admin;
    private static MiniHBaseCluster cluster;
    private static final HBaseTestingUtility TEST_UTIL;
    private static final Path HBASEDIR;
    private static final Path OLDLOGDIR;
    private Configuration conf;
    private FileSystem fs;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.logroll.errors.tolerated", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 10000);
        TEST_UTIL.getConfiguration().setLong("hbase.client.pause", 5000L);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.getConfiguration().setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.write.retries", 10);
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(2);
        cluster = TEST_UTIL.getHBaseCluster();
        dfsCluster = TEST_UTIL.getDFSCluster();
        admin = TEST_UTIL.getHBaseAdmin();
        this.conf = TEST_UTIL.getConfiguration();
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        cluster.getMaster().balanceSwitch(false);
        FSUtils.setRootDir((Configuration)this.conf, (Path)HBASEDIR);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRSAbortWithUnflushedEdits() throws Exception {
        LOG.info((Object)"Starting testRSAbortWithUnflushedEdits()");
        new HTable(TEST_UTIL.getConfiguration(), TableName.META_TABLE_NAME).close();
        TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        admin.createTable(desc);
        try (HTable table = new HTable(TEST_UTIL.getConfiguration(), desc.getTableName());){
            HRegionServer server = TEST_UTIL.getRSForFirstRegionInTable(tableName);
            WAL log = server.getWAL(null);
            Assert.assertTrue((String)"Need append support for this test", (boolean)FSUtils.isAppendSupported((Configuration)TEST_UTIL.getConfiguration()));
            Put p = new Put(Bytes.toBytes((String)"row2001"));
            p.add(HConstants.CATALOG_FAMILY, Bytes.toBytes((String)"col"), Bytes.toBytes((int)2001));
            table.put(p);
            log.sync();
            p = new Put(Bytes.toBytes((String)"row2002"));
            p.add(HConstants.CATALOG_FAMILY, Bytes.toBytes((String)"col"), Bytes.toBytes((int)2002));
            table.put(p);
            dfsCluster.restartDataNodes();
            LOG.info((Object)"Restarted datanodes");
            try {
                log.rollWriter(true);
            }
            catch (FailedLogCloseException failedLogCloseException) {
            }
            catch (Throwable t) {
                LOG.fatal((Object)"FAILED TEST: Got wrong exception", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testLogRollAfterSplitStart() throws IOException {
        block9: {
            LOG.info((Object)"Verify wal roll after split starts will fail.");
            String logName = "testLogRollAfterSplitStart";
            Path thisTestsDir = new Path(HBASEDIR, DefaultWALProvider.getWALDirectoryName((String)logName));
            WALFactory wals = new WALFactory(this.conf, null, logName);
            try {
                TableName tableName = TableName.valueOf((String)this.getClass().getName());
                HRegionInfo regioninfo = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
                WAL log = wals.getWAL(regioninfo.getEncodedNameAsBytes());
                MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl(1L);
                int total = 20;
                for (int i = 0; i < 20; ++i) {
                    WALEdit kvs = new WALEdit();
                    kvs.add((Cell)new KeyValue(Bytes.toBytes((int)i), tableName.getName(), tableName.getName()));
                    HTableDescriptor htd = new HTableDescriptor(tableName);
                    htd.addFamily(new HColumnDescriptor("column"));
                    log.append(htd, regioninfo, new WALKey(regioninfo.getEncodedNameAsBytes(), tableName, System.currentTimeMillis(), mvcc), kvs, true);
                }
                log.sync();
                ((FSHLog)log).replaceWriter(((FSHLog)log).getOldPath(), null, null, null);
                Path rsSplitDir = thisTestsDir.suffix("-splitting");
                if (!this.fs.rename(thisTestsDir, rsSplitDir)) {
                    throw new IOException("Failed fs.rename for log split: " + thisTestsDir);
                }
                LOG.debug((Object)("Renamed region directory: " + rsSplitDir));
                LOG.debug((Object)"Processing the old log files.");
                WALSplitter.split((Path)HBASEDIR, (Path)rsSplitDir, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf, (WALFactory)wals);
                LOG.debug((Object)"Trying to roll the WAL.");
                try {
                    log.rollWriter();
                    Assert.fail((String)"rollWriter() did not throw any exception.");
                }
                catch (IOException ioe) {
                    if (ioe.getCause() instanceof FileNotFoundException) {
                        LOG.info((Object)"Got the expected exception: ", ioe.getCause());
                        break block9;
                    }
                    Assert.fail((String)("Unexpected exception: " + ioe));
                }
            }
            finally {
                wals.close();
                if (this.fs.exists(thisTestsDir)) {
                    this.fs.delete(thisTestsDir, true);
                }
            }
        }
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
        HBASEDIR = new Path("/hbase");
        OLDLOGDIR = new Path(HBASEDIR, "oldWALs");
    }
}

