/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMasterReplication {
    private static final Log LOG = LogFactory.getLog(TestReplicationBase.class);
    private Configuration baseConfiguration;
    private HBaseTestingUtility[] utilities;
    private Configuration[] configurations;
    private MiniZooKeeperCluster miniZK;
    private static final long SLEEP_TIME = 1000L;
    private static final int NB_RETRIES = 120;
    private static final TableName tableName = TableName.valueOf((String)"test");
    private static final byte[] famName = Bytes.toBytes((String)"f");
    private static final byte[] row = Bytes.toBytes((String)"row");
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] row2 = Bytes.toBytes((String)"row2");
    private static final byte[] row3 = Bytes.toBytes((String)"row3");
    private static final byte[] row4 = Bytes.toBytes((String)"row4");
    private static final byte[] noRepfamName = Bytes.toBytes((String)"norep");
    private static final byte[] count = Bytes.toBytes((String)"count");
    private static final byte[] put = Bytes.toBytes((String)"put");
    private static final byte[] delete = Bytes.toBytes((String)"delete");
    private HTableDescriptor table;

    @Before
    public void setUp() throws Exception {
        this.baseConfiguration = HBaseConfiguration.create();
        this.baseConfiguration.setInt("hbase.regionserver.hlog.blocksize", 20480);
        this.baseConfiguration.setInt("replication.source.size.capacity", 1024);
        this.baseConfiguration.setLong("replication.source.sleepforretries", 100L);
        this.baseConfiguration.setInt("hbase.regionserver.maxlogs", 10);
        this.baseConfiguration.setLong("hbase.master.logcleaner.ttl", 10L);
        this.baseConfiguration.setBoolean("hbase.replication", true);
        this.baseConfiguration.setBoolean("dfs.support.append", true);
        this.baseConfiguration.setLong("hbase.server.thread.wakefrequency", 100L);
        this.baseConfiguration.setStrings("hbase.coprocessor.user.region.classes", new String[]{CoprocessorCounter.class.getName()});
        this.table = new HTableDescriptor(tableName);
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        this.table.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        this.table.addFamily(fam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCyclicReplication1() throws Exception {
        LOG.info((Object)"testSimplePutDelete");
        int numClusters = 2;
        Table[] htables = null;
        try {
            this.startMiniClusters(numClusters);
            this.createTableOnClusters(this.table);
            htables = this.getHTablesOnClusters(tableName);
            this.addPeer("1", 0, 1);
            this.addPeer("1", 1, 0);
            int[] expectedCounts = new int[]{2, 2};
            this.putAndWait(row, famName, htables[0], htables[1]);
            this.putAndWait(row1, famName, htables[1], htables[0]);
            this.validateCounts(htables, put, expectedCounts);
            this.deleteAndWait(row, htables[0], htables[1]);
            this.deleteAndWait(row1, htables[1], htables[0]);
            this.validateCounts(htables, delete, expectedCounts);
            this.close((Closeable[])htables);
        }
        catch (Throwable throwable) {
            this.close((Closeable[])htables);
            this.shutDownMiniClusters();
            throw throwable;
        }
        this.shutDownMiniClusters();
    }

    @Test(timeout=300000L)
    public void testLoopedReplication() throws Exception {
        LOG.info((Object)"testLoopedReplication");
        this.startMiniClusters(1);
        this.createTableOnClusters(this.table);
        this.addPeer("1", 0, 0);
        Thread.sleep(1000L);
        final ServerName rsName = this.utilities[0].getHBaseCluster().getRegionServer(0).getServerName();
        Waiter.waitFor((Configuration)this.baseConfiguration, (long)10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                ClusterStatus clusterStatus = TestMasterReplication.this.utilities[0].getHBaseAdmin().getClusterStatus();
                ServerLoad serverLoad = clusterStatus.getLoad(rsName);
                List replicationLoadSourceList = serverLoad.getReplicationLoadSourceList();
                return replicationLoadSourceList.size() == 0;
            }
        });
        Table[] htables = this.getHTablesOnClusters(tableName);
        this.putAndWait(row, famName, htables[0], htables[0]);
        this.rollWALAndWait(this.utilities[0], this.table.getTableName(), row);
        ZooKeeperWatcher zkw = this.utilities[0].getZooKeeperWatcher();
        String queuesZnode = ZKUtil.joinZNode((String)zkw.baseZNode, (String)ZKUtil.joinZNode((String)"replication", (String)"rs"));
        List listChildrenNoWatch = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)ZKUtil.joinZNode((String)queuesZnode, (String)rsName.toString()));
        Assert.assertEquals((long)0L, (long)listChildrenNoWatch.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCyclicReplication2() throws Exception {
        LOG.info((Object)"testCyclicReplication1");
        int numClusters = 3;
        Table[] htables = null;
        try {
            this.startMiniClusters(numClusters);
            this.createTableOnClusters(this.table);
            this.addPeer("1", 0, 1);
            this.addPeer("1", 1, 2);
            this.addPeer("1", 2, 0);
            htables = this.getHTablesOnClusters(tableName);
            this.putAndWait(row, famName, htables[0], htables[2]);
            this.putAndWait(row1, famName, htables[1], htables[0]);
            this.putAndWait(row2, famName, htables[2], htables[1]);
            this.deleteAndWait(row, htables[0], htables[2]);
            this.deleteAndWait(row1, htables[1], htables[0]);
            this.deleteAndWait(row2, htables[2], htables[1]);
            int[] expectedCounts = new int[]{3, 3, 3};
            this.validateCounts(htables, put, expectedCounts);
            this.validateCounts(htables, delete, expectedCounts);
            this.disablePeer("1", 2);
            this.putAndWait(row3, famName, htables[0], htables[1]);
            htables[1].put(new Put(row4).add(famName, row4, row4));
            this.enablePeer("1", 2);
            this.wait(row4, htables[0], true);
            this.close((Closeable[])htables);
        }
        catch (Throwable throwable) {
            this.close((Closeable[])htables);
            this.shutDownMiniClusters();
            throw throwable;
        }
        this.shutDownMiniClusters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testCyclicReplication3() throws Exception {
        LOG.info((Object)"testCyclicReplication2");
        int numClusters = 3;
        Table[] htables = null;
        try {
            this.startMiniClusters(numClusters);
            this.createTableOnClusters(this.table);
            this.addPeer("1", 0, 1);
            this.addPeer("1", 1, 2);
            this.addPeer("1", 2, 1);
            htables = this.getHTablesOnClusters(tableName);
            this.putAndWait(row, famName, htables[0], htables[2]);
            this.putAndWait(row1, famName, htables[1], htables[2]);
            this.putAndWait(row2, famName, htables[2], htables[1]);
            this.deleteAndWait(row, htables[0], htables[2]);
            this.deleteAndWait(row1, htables[1], htables[2]);
            this.deleteAndWait(row2, htables[2], htables[1]);
            int[] expectedCounts = new int[]{1, 3, 3};
            this.validateCounts(htables, put, expectedCounts);
            this.validateCounts(htables, delete, expectedCounts);
            this.close((Closeable[])htables);
        }
        catch (Throwable throwable) {
            this.close((Closeable[])htables);
            this.shutDownMiniClusters();
            throw throwable;
        }
        this.shutDownMiniClusters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L, expected=ServiceException.class)
    public void testReplicateWALEntryWhenReplicationIsDisabled() throws Exception {
        LOG.info((Object)"testSimplePutDelete");
        this.baseConfiguration.setBoolean("hbase.replication", false);
        Table[] htables = null;
        try {
            this.startMiniClusters(1);
            this.createTableOnClusters(this.table);
            htables = this.getHTablesOnClusters(tableName);
            HRegionServer rs = this.utilities[0].getRSForFirstRegionInTable(tableName);
            RSRpcServices rsrpc = new RSRpcServices(rs);
            rsrpc.replicateWALEntry(null, null);
            this.close((Closeable[])htables);
        }
        catch (Throwable throwable) {
            this.close((Closeable[])htables);
            this.shutDownMiniClusters();
            throw throwable;
        }
        this.shutDownMiniClusters();
    }

    @After
    public void tearDown() throws IOException {
        this.configurations = null;
        this.utilities = null;
    }

    private void startMiniClusters(int numClusters) throws Exception {
        Random random = new Random();
        this.utilities = new HBaseTestingUtility[numClusters];
        this.configurations = new Configuration[numClusters];
        for (int i = 0; i < numClusters; ++i) {
            Configuration conf = new Configuration(this.baseConfiguration);
            conf.set("zookeeper.znode.parent", "/" + i + random.nextInt());
            HBaseTestingUtility utility = new HBaseTestingUtility(conf);
            if (i == 0) {
                utility.startMiniZKCluster();
                this.miniZK = utility.getZkCluster();
            } else {
                utility.setZkCluster(this.miniZK);
            }
            utility.startMiniCluster();
            this.utilities[i] = utility;
            this.configurations[i] = conf;
            new ZooKeeperWatcher(conf, "cluster" + i, null, true);
        }
    }

    private void shutDownMiniClusters() throws Exception {
        int numClusters = this.utilities.length;
        for (int i = numClusters - 1; i >= 0; --i) {
            if (this.utilities[i] == null) continue;
            this.utilities[i].shutdownMiniCluster();
        }
        this.miniZK.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableOnClusters(HTableDescriptor table) throws Exception {
        int numClusters = this.configurations.length;
        for (int i = 0; i < numClusters; ++i) {
            HBaseAdmin hbaseAdmin = null;
            try {
                hbaseAdmin = new HBaseAdmin(this.configurations[i]);
                hbaseAdmin.createTable(table);
            }
            catch (Throwable throwable) {
                this.close(new Closeable[]{hbaseAdmin});
                throw throwable;
            }
            this.close(new Closeable[]{hbaseAdmin});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPeer(String id, int masterClusterNumber, int slaveClusterNumber) throws Exception {
        ReplicationAdmin replicationAdmin = null;
        try {
            replicationAdmin = new ReplicationAdmin(this.configurations[masterClusterNumber]);
            replicationAdmin.addPeer(id, this.utilities[slaveClusterNumber].getClusterKey());
        }
        catch (Throwable throwable) {
            this.close(new Closeable[]{replicationAdmin});
            throw throwable;
        }
        this.close(new Closeable[]{replicationAdmin});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disablePeer(String id, int masterClusterNumber) throws Exception {
        ReplicationAdmin replicationAdmin = null;
        try {
            replicationAdmin = new ReplicationAdmin(this.configurations[masterClusterNumber]);
            replicationAdmin.disablePeer(id);
        }
        catch (Throwable throwable) {
            this.close(new Closeable[]{replicationAdmin});
            throw throwable;
        }
        this.close(new Closeable[]{replicationAdmin});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enablePeer(String id, int masterClusterNumber) throws Exception {
        ReplicationAdmin replicationAdmin = null;
        try {
            replicationAdmin = new ReplicationAdmin(this.configurations[masterClusterNumber]);
            replicationAdmin.enablePeer(id);
        }
        catch (Throwable throwable) {
            this.close(new Closeable[]{replicationAdmin});
            throw throwable;
        }
        this.close(new Closeable[]{replicationAdmin});
    }

    private void close(Closeable ... closeables) {
        try {
            if (closeables != null) {
                for (Closeable closeable : closeables) {
                    closeable.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception occured while closing the object:", (Throwable)e);
        }
    }

    private Table[] getHTablesOnClusters(TableName tableName) throws Exception {
        int numClusters = this.utilities.length;
        Table[] htables = new Table[numClusters];
        for (int i = 0; i < numClusters; ++i) {
            HTable htable = new HTable(this.configurations[i], tableName);
            htable.setWriteBufferSize(1024L);
            htables[i] = htable;
        }
        return htables;
    }

    private void validateCounts(Table[] htables, byte[] type, int[] expectedCounts) throws IOException {
        for (int i = 0; i < htables.length; ++i) {
            Assert.assertEquals((String)(Bytes.toString((byte[])type) + " were replicated back "), (long)expectedCounts[i], (long)this.getCount(htables[i], type));
        }
    }

    private int getCount(Table t, byte[] type) throws IOException {
        Get test = new Get(row);
        test.setAttribute("count", new byte[0]);
        Result res = t.get(test);
        return Bytes.toInt((byte[])res.getValue(count, type));
    }

    private void deleteAndWait(byte[] row, Table source, Table target) throws Exception {
        Delete del = new Delete(row);
        source.delete(del);
        this.wait(row, target, true);
    }

    private void putAndWait(byte[] row, byte[] fam, Table source, Table target) throws Exception {
        Put put = new Put(row);
        put.add(fam, row, row);
        source.put(put);
        this.wait(row, target, false);
    }

    private void wait(byte[] row, Table target, boolean isDeleted) throws Exception {
        Get get = new Get(row);
        for (int i = 0; i < 120; ++i) {
            boolean sleep;
            if (i == 119) {
                Assert.fail((String)("Waited too much time for replication. Row:" + Bytes.toString((byte[])row) + ". IsDeleteReplication:" + isDeleted));
            }
            Result res = target.get(get);
            boolean bl = isDeleted ? res.size() > 0 : (sleep = res.size() == 0);
            if (!sleep) {
                if (!isDeleted) {
                    Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                }
                LOG.info((Object)("Obtained row:" + Bytes.toString((byte[])row) + ". IsDeleteReplication:" + isDeleted));
                break;
            }
            LOG.info((Object)("Waiting for more time for replication. Row:" + Bytes.toString((byte[])row) + ". IsDeleteReplication:" + isDeleted));
            Thread.sleep(1000L);
        }
    }

    private void rollWALAndWait(HBaseTestingUtility utility, TableName table, byte[] row) throws IOException {
        HBaseAdmin admin = utility.getHBaseAdmin();
        MiniHBaseCluster cluster = utility.getMiniHBaseCluster();
        HRegion region = null;
        for (HRegion candidate : cluster.getRegions(table)) {
            if (!HRegion.rowIsInRange((HRegionInfo)candidate.getRegionInfo(), (byte[])row)) continue;
            region = candidate;
            break;
        }
        Assert.assertNotNull((String)("Couldn't find the region for row '" + Arrays.toString(row) + "'"), (Object)region);
        final CountDownLatch latch = new CountDownLatch(1);
        WALActionsListener.Base listener = new WALActionsListener.Base(){

            public void postLogRoll(Path oldPath, Path newPath) throws IOException {
                latch.countDown();
            }
        };
        region.getWAL().registerWALActionsListener((WALActionsListener)listener);
        admin.rollWALWriter(cluster.getServerHoldingRegion(region.getTableDesc().getTableName(), region.getRegionInfo().getRegionName()));
        try {
            latch.await();
        }
        catch (InterruptedException exception) {
            LOG.warn((Object)("Interrupted while waiting for the wal of '" + region + "' to roll. If later " + "replication tests fail, it's probably because we should still be waiting."));
            Thread.currentThread().interrupt();
        }
        region.getWAL().unregisterWALActionsListener((WALActionsListener)listener);
    }

    public static class CoprocessorCounter
    extends BaseRegionObserver {
        private int nCount = 0;
        private int nDelete = 0;

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            ++this.nCount;
        }

        public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
            ++this.nDelete;
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
            if (get.getAttribute("count") != null) {
                result.clear();
                result.add((Cell)new KeyValue(count, count, delete, Bytes.toBytes((int)this.nDelete)));
                result.add((Cell)new KeyValue(count, count, put, Bytes.toBytes((int)this.nCount)));
                c.bypass();
            }
        }
    }
}

