/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.http.ssl.KeyStoreTestUtil;
import org.apache.hadoop.hbase.ipc.AsyncRpcClient;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientImpl;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.token.TokenProvider;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestGenerateDelegationToken {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static LocalHBaseCluster CLUSTER;
    private static final File KEYTAB_FILE;
    private static MiniKdc KDC;
    private static String HOST;
    private static String USERNAME;
    private static String PRINCIPAL;
    private static String HTTP_PRINCIPAL;

    private static void setHdfsSecuredConfiguration(Configuration conf) throws Exception {
        conf.set("dfs.namenode.kerberos.principal", PRINCIPAL + "@" + KDC.getRealm());
        conf.set("dfs.namenode.keytab.file", KEYTAB_FILE.getAbsolutePath());
        conf.set("dfs.datanode.kerberos.principal", PRINCIPAL + "@" + KDC.getRealm());
        conf.set("dfs.datanode.keytab.file", KEYTAB_FILE.getAbsolutePath());
        conf.set("dfs.web.authentication.kerberos.principal", HTTP_PRINCIPAL + "@" + KDC.getRealm());
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        File keystoresDir = new File(TEST_UTIL.getDataTestDir("keystore").toUri().getPath());
        keystoresDir.mkdirs();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestGenerateDelegationToken.class);
        KeyStoreTestUtil.setupSSLConfig(keystoresDir.getAbsolutePath(), sslConfDir, conf, false);
        conf.setBoolean("ignore.secure.ports.for.testing", true);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        USERNAME = UserGroupInformation.getLoginUser().getShortUserName();
        PRINCIPAL = USERNAME + "/" + HOST;
        HTTP_PRINCIPAL = "HTTP/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL, HTTP_PRINCIPAL});
        TEST_UTIL.startMiniZKCluster();
        HBaseKerberosUtils.setPrincipalForTesting(PRINCIPAL + "@" + KDC.getRealm());
        HBaseKerberosUtils.setSecuredConfiguration(TEST_UTIL.getConfiguration());
        TestGenerateDelegationToken.setHdfsSecuredConfiguration(TEST_UTIL.getConfiguration());
        UserGroupInformation.setConfiguration((Configuration)TEST_UTIL.getConfiguration());
        TEST_UTIL.getConfiguration().setStrings("hbase.coprocessor.region.classes", new String[]{TokenProvider.class.getName()});
        TEST_UTIL.startMiniDFSCluster(1);
        Path rootdir = TEST_UTIL.getDataTestDirOnTestFS("TestGenerateDelegationToken");
        FSUtils.setRootDir((Configuration)TEST_UTIL.getConfiguration(), (Path)rootdir);
        CLUSTER = new LocalHBaseCluster(TEST_UTIL.getConfiguration(), 1);
        CLUSTER.startup();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (CLUSTER != null) {
            CLUSTER.shutdown();
        }
        CLUSTER.join();
        if (KDC != null) {
            KDC.stop();
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    private void testTokenAuth(Class<? extends RpcClient> rpcImplClass) throws IOException, ServiceException {
        TEST_UTIL.getConfiguration().set("hbase.rpc.client.impl", rpcImplClass.getName());
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Table table = conn.getTable(TableName.META_TABLE_NAME);){
            CoprocessorRpcChannel rpcChannel = table.coprocessorService(HConstants.EMPTY_START_ROW);
            AuthenticationProtos.AuthenticationService.BlockingInterface service = AuthenticationProtos.AuthenticationService.newBlockingStub((BlockingRpcChannel)rpcChannel);
            AuthenticationProtos.WhoAmIResponse response = service.whoAmI(null, AuthenticationProtos.WhoAmIRequest.getDefaultInstance());
            Assert.assertEquals((Object)USERNAME, (Object)response.getUsername());
            Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.TOKEN.name(), (Object)response.getAuthMethod());
            try {
                service.getAuthenticationToken(null, AuthenticationProtos.GetAuthenticationTokenRequest.getDefaultInstance());
            }
            catch (ServiceException e) {
                AccessDeniedException exc = (AccessDeniedException)((Object)ProtobufUtil.getRemoteException((ServiceException)e));
                Assert.assertTrue((boolean)exc.getMessage().contains("Token generation only allowed for Kerberos authenticated clients"));
            }
        }
    }

    @Test
    public void test() throws Exception {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
            Token token = TokenUtil.obtainToken((Connection)conn);
            UserGroupInformation.getCurrentUser().addToken(token);
            this.testTokenAuth(RpcClientImpl.class);
            this.testTokenAuth(AsyncRpcClient.class);
        }
    }

    static {
        KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
        HOST = "localhost";
    }
}

