/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.HadoopShims;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PerformanceEvaluation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.KeyValueSerialization;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.NMapInputFormat;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.SimpleTotalOrderPartitioner;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

@Category(value={LargeTests.class})
public class TestHFileOutputFormat2 {
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static final int ROWSPERSPLIT = 1024;
    private static final byte[] FAMILY_NAME = Bytes.toBytes((String)"info");
    private static final byte[][] FAMILIES = new byte[][]{Bytes.add((byte[])FAMILY_NAME, (byte[])Bytes.toBytes((String)"-A")), Bytes.add((byte[])FAMILY_NAME, (byte[])Bytes.toBytes((String)"-B"))};
    private static final TableName TABLE_NAME = TableName.valueOf((String)"TestTable");
    private HBaseTestingUtility util = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestHFileOutputFormat2.class);

    private void setupRandomGeneratorMapper(Job job, boolean putSortReducer) {
        if (putSortReducer) {
            job.setInputFormatClass(NMapInputFormat.class);
            job.setMapperClass(RandomPutGeneratingMapper.class);
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            job.setMapOutputValueClass(Put.class);
        } else {
            job.setInputFormatClass(NMapInputFormat.class);
            job.setMapperClass(RandomKVGeneratingMapper.class);
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            job.setMapOutputValueClass(KeyValue.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void test_LATEST_TIMESTAMP_isReplaced() throws Exception {
        Path dir;
        Configuration conf;
        block3: {
            conf = new Configuration(this.util.getConfiguration());
            RecordWriter writer = null;
            TaskAttemptContext context = null;
            dir = this.util.getDataTestDir("test_LATEST_TIMESTAMP_isReplaced");
            try {
                Job job = new Job(conf);
                FileOutputFormat.setOutputPath((Job)job, (Path)dir);
                context = this.createTestTaskAttemptContext(job);
                HFileOutputFormat2 hof = new HFileOutputFormat2();
                writer = hof.getRecordWriter(context);
                byte[] b = Bytes.toBytes((String)"b");
                KeyValue kv = new KeyValue(b, b, b);
                KeyValue original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertFalse((boolean)original.equals((Object)kv));
                Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)original), (byte[])CellUtil.cloneRow((Cell)kv)));
                Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneFamily((Cell)original), (byte[])CellUtil.cloneFamily((Cell)kv)));
                Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneQualifier((Cell)original), (byte[])CellUtil.cloneQualifier((Cell)kv)));
                Assert.assertNotSame((Object)original.getTimestamp(), (Object)kv.getTimestamp());
                Assert.assertNotSame((Object)Long.MAX_VALUE, (Object)kv.getTimestamp());
                kv = new KeyValue(b, b, b, kv.getTimestamp() - 1L, b);
                original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertTrue((boolean)original.equals((Object)kv));
                if (writer == null || context == null) break block3;
            }
            catch (Throwable throwable) {
                if (writer != null && context != null) {
                    writer.close(context);
                }
                dir.getFileSystem(conf).delete(dir, true);
                throw throwable;
            }
            writer.close(context);
        }
        dir.getFileSystem(conf).delete(dir, true);
    }

    private TaskAttemptContext createTestTaskAttemptContext(Job job) throws Exception {
        HadoopShims hadoop = (HadoopShims)CompatibilitySingletonFactory.getInstance(HadoopShims.class);
        TaskAttemptContext context = (TaskAttemptContext)hadoop.createTestTaskAttemptContext((Object)job, "attempt_201402131733_0001_m_000000_0");
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void test_TIMERANGE() throws Exception {
        Path dir;
        Configuration conf;
        block3: {
            conf = new Configuration(this.util.getConfiguration());
            RecordWriter writer = null;
            TaskAttemptContext context = null;
            dir = this.util.getDataTestDir("test_TIMERANGE_present");
            LOG.info((Object)("Timerange dir writing to dir: " + dir));
            try {
                Job job = new Job(conf);
                FileOutputFormat.setOutputPath((Job)job, (Path)dir);
                context = this.createTestTaskAttemptContext(job);
                HFileOutputFormat2 hof = new HFileOutputFormat2();
                writer = hof.getRecordWriter(context);
                byte[] b = Bytes.toBytes((String)"b");
                KeyValue kv = new KeyValue(b, b, b, 2000L, b);
                KeyValue original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertEquals((Object)original, (Object)kv);
                kv = new KeyValue(b, b, b, 1000L, b);
                original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertEquals((Object)original, (Object)kv);
                writer.close(context);
                FileSystem fs = FileSystem.get((Configuration)conf);
                Path attemptDirectory = hof.getDefaultWorkFile(context, "").getParent();
                FileStatus[] sub1 = fs.listStatus(attemptDirectory);
                FileStatus[] file = fs.listStatus(sub1[0].getPath());
                HFile.Reader rd = HFile.createReader((FileSystem)fs, (Path)file[0].getPath(), (CacheConfig)new CacheConfig(conf), (Configuration)conf);
                Map finfo = rd.loadFileInfo();
                byte[] range = (byte[])finfo.get("TIMERANGE".getBytes());
                Assert.assertNotNull((Object)range);
                TimeRangeTracker timeRangeTracker = new TimeRangeTracker();
                Writables.copyWritable((byte[])range, (Writable)timeRangeTracker);
                LOG.info((Object)(timeRangeTracker.getMin() + "...." + timeRangeTracker.getMax()));
                Assert.assertEquals((long)1000L, (long)timeRangeTracker.getMin());
                Assert.assertEquals((long)2000L, (long)timeRangeTracker.getMax());
                rd.close();
                if (writer == null || context == null) break block3;
            }
            catch (Throwable throwable) {
                if (writer != null && context != null) {
                    writer.close(context);
                }
                dir.getFileSystem(conf).delete(dir, true);
                throw throwable;
            }
            writer.close(context);
        }
        dir.getFileSystem(conf).delete(dir, true);
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testWritingPEData() throws Exception {
        Configuration conf = this.util.getConfiguration();
        Path testDir = this.util.getDataTestDirOnTestFS("testWritingPEData");
        FileSystem fs = testDir.getFileSystem(conf);
        conf.setInt("mapreduce.task.io.sort.mb", 20);
        conf.setLong("hbase.hregion.max.filesize", 65536L);
        Job job = new Job(conf, "testWritingPEData");
        this.setupRandomGeneratorMapper(job, false);
        byte[] startKey = new byte[10];
        byte[] endKey = new byte[10];
        Arrays.fill(startKey, (byte)0);
        Arrays.fill(endKey, (byte)-1);
        job.setPartitionerClass(SimpleTotalOrderPartitioner.class);
        SimpleTotalOrderPartitioner.setStartKey((Configuration)job.getConfiguration(), (byte[])startKey);
        SimpleTotalOrderPartitioner.setEndKey((Configuration)job.getConfiguration(), (byte[])endKey);
        job.setReducerClass(KeyValueSortReducer.class);
        job.setOutputFormatClass(HFileOutputFormat2.class);
        job.setNumReduceTasks(4);
        job.getConfiguration().setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), KeyValueSerialization.class.getName()});
        FileOutputFormat.setOutputPath((Job)job, (Path)testDir);
        Assert.assertTrue((boolean)job.waitForCompletion(false));
        FileStatus[] files = fs.listStatus(testDir);
        Assert.assertTrue((files.length > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void test_WritingTagData() throws Exception {
        Path dir;
        Configuration conf;
        block4: {
            conf = new Configuration(this.util.getConfiguration());
            String HFILE_FORMAT_VERSION_CONF_KEY = "hfile.format.version";
            conf.setInt("hfile.format.version", 3);
            RecordWriter writer = null;
            TaskAttemptContext context = null;
            dir = this.util.getDataTestDir("WritingTagData");
            try {
                Job job = new Job(conf);
                FileOutputFormat.setOutputPath((Job)job, (Path)dir);
                context = this.createTestTaskAttemptContext(job);
                HFileOutputFormat2 hof = new HFileOutputFormat2();
                writer = hof.getRecordWriter(context);
                byte[] b = Bytes.toBytes((String)"b");
                KeyValue kv = new KeyValue(b, b, b, Long.MAX_VALUE, b, new Tag[]{new Tag(8, Bytes.toBytes((int)978670))});
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                writer.close(context);
                writer = null;
                FileSystem fs = dir.getFileSystem(conf);
                RemoteIterator iterator = fs.listFiles(dir, true);
                while (iterator.hasNext()) {
                    LocatedFileStatus keyFileStatus = (LocatedFileStatus)iterator.next();
                    HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)keyFileStatus.getPath(), (CacheConfig)new CacheConfig(conf), (Configuration)conf);
                    HFileScanner scanner = reader.getScanner(false, false, false);
                    scanner.seekTo();
                    Cell cell = scanner.getKeyValue();
                    Iterator tagsIterator = CellUtil.tagsIterator((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength());
                    Assert.assertTrue((boolean)tagsIterator.hasNext());
                    Assert.assertTrue((((Tag)tagsIterator.next()).getType() == 8 ? 1 : 0) != 0);
                }
                if (writer == null || context == null) break block4;
            }
            catch (Throwable throwable) {
                if (writer != null && context != null) {
                    writer.close(context);
                }
                dir.getFileSystem(conf).delete(dir, true);
                throw throwable;
            }
            writer.close(context);
        }
        dir.getFileSystem(conf).delete(dir, true);
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testJobConfiguration() throws Exception {
        Configuration conf = new Configuration(this.util.getConfiguration());
        conf.set("hbase.fs.tmp.dir", this.util.getDataTestDir("testJobConfiguration").toString());
        Job job = new Job(conf);
        job.setWorkingDirectory(this.util.getDataTestDir("testJobConfiguration"));
        RegionLocator regionLocator = (RegionLocator)Mockito.mock(RegionLocator.class);
        this.setupMockStartKeys(regionLocator);
        this.setupMockTableName(regionLocator);
        HFileOutputFormat2.configureIncrementalLoad((Job)job, (HTableDescriptor)new HTableDescriptor(), (RegionLocator)regionLocator);
        Assert.assertEquals((long)job.getNumReduceTasks(), (long)4L);
    }

    private byte[][] generateRandomStartKeys(int numKeys) {
        Random random = new Random();
        byte[][] ret = new byte[numKeys][];
        ret[0] = HConstants.EMPTY_BYTE_ARRAY;
        for (int i = 1; i < numKeys; ++i) {
            ret[i] = PerformanceEvaluation.generateData(random, 1000);
        }
        return ret;
    }

    private byte[][] generateRandomSplitKeys(int numKeys) {
        Random random = new Random();
        byte[][] ret = new byte[numKeys][];
        for (int i = 0; i < numKeys; ++i) {
            ret[i] = PerformanceEvaluation.generateData(random, 1000);
        }
        return ret;
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testMRIncrementalLoad() throws Exception {
        LOG.info((Object)"\nStarting test testMRIncrementalLoad\n");
        this.doIncrementalLoadTest(false, false, false, "testMRIncrementalLoad");
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testMRIncrementalLoadWithSplit() throws Exception {
        LOG.info((Object)"\nStarting test testMRIncrementalLoadWithSplit\n");
        this.doIncrementalLoadTest(true, false, false, "testMRIncrementalLoadWithSplit");
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testMRIncrementalLoadWithLocality() throws Exception {
        LOG.info((Object)"\nStarting test testMRIncrementalLoadWithLocality\n");
        this.doIncrementalLoadTest(false, true, false, "testMRIncrementalLoadWithLocality1");
        this.doIncrementalLoadTest(true, true, false, "testMRIncrementalLoadWithLocality2");
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testMRIncrementalLoadWithPutSortReducer() throws Exception {
        LOG.info((Object)"\nStarting test testMRIncrementalLoadWithPutSortReducer\n");
        this.doIncrementalLoadTest(false, false, true, "testMRIncrementalLoadWithPutSortReducer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIncrementalLoadTest(boolean shouldChangeRegions, boolean shouldKeepLocality, boolean putSortReducer, String tableStr) throws Exception {
        this.util = new HBaseTestingUtility();
        Configuration conf = this.util.getConfiguration();
        conf.setBoolean("hbase.bulkload.locality.sensitive.enabled", shouldKeepLocality);
        int hostCount = 1;
        int regionNum = 5;
        if (shouldKeepLocality) {
            hostCount = 3;
            regionNum = 20;
        }
        byte[][] splitKeys = this.generateRandomSplitKeys(regionNum - 1);
        String[] hostnames = new String[hostCount];
        for (int i = 0; i < hostCount; ++i) {
            hostnames[i] = "datanode_" + i;
        }
        this.util.setJobWithoutMRCluster();
        this.util.startMiniCluster(1, hostCount, hostnames);
        HTable table = this.util.createTable(TABLE_NAME, FAMILIES, splitKeys);
        Path testDir = this.util.getDataTestDirOnTestFS("testLocalMRIncrementalLoad");
        try (RegionLocator r = table.getRegionLocator();
             Admin admin = table.getConnection().getAdmin();){
            Assert.assertEquals((String)"Should start with empty table", (long)0L, (long)this.util.countRows((Table)table));
            int numRegions = r.getStartKeys().length;
            Assert.assertEquals((String)("Should make " + regionNum + " regions"), (long)numRegions, (long)regionNum);
            this.runIncrementalPELoad(conf, table.getTableDescriptor(), table.getRegionLocator(), testDir, putSortReducer);
            Assert.assertEquals((String)"HFOF should not touch actual table", (long)0L, (long)this.util.countRows((Table)table));
            int dir = 0;
            for (FileStatus f : testDir.getFileSystem(conf).listStatus(testDir)) {
                for (byte[] family : FAMILIES) {
                    if (!Bytes.toString((byte[])family).equals(f.getPath().getName())) continue;
                    ++dir;
                }
            }
            Assert.assertEquals((String)"Column family not found in FS.", (long)FAMILIES.length, (long)dir);
            if (shouldChangeRegions) {
                LOG.info((Object)"Changing regions in table");
                admin.disableTable(table.getName());
                this.util.waitUntilNoRegionsInTransition();
                this.util.deleteTable(table.getName());
                byte[][] newSplitKeys = this.generateRandomSplitKeys(14);
                table = this.util.createTable(TABLE_NAME, FAMILIES, newSplitKeys);
                while (table.getRegionLocator().getAllRegionLocations().size() != 15 || !admin.isTableAvailable(table.getName())) {
                    Thread.sleep(200L);
                    LOG.info((Object)"Waiting for new region assignment to happen");
                }
            }
            new LoadIncrementalHFiles(conf).doBulkLoad(testDir, table);
            int expectedRows = 0;
            if (putSortReducer) {
                Assert.assertEquals((String)"LoadIncrementalHFiles should put expected data in table", (long)expectedRows, (long)this.util.countRows((Table)table));
            } else {
                expectedRows = NMapInputFormat.getNumMapTasks(conf) * 1024;
                Assert.assertEquals((String)"LoadIncrementalHFiles should put expected data in table", (long)expectedRows, (long)this.util.countRows((Table)table));
                Scan scan = new Scan();
                ResultScanner results = table.getScanner(scan);
                for (Result res : results) {
                    Assert.assertEquals((long)FAMILIES.length, (long)res.rawCells().length);
                    Cell first = res.rawCells()[0];
                    for (Cell kv : res.rawCells()) {
                        Assert.assertTrue((boolean)CellUtil.matchingRow((Cell)first, (Cell)kv));
                        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)first), (byte[])CellUtil.cloneValue((Cell)kv)));
                    }
                }
                results.close();
            }
            String tableDigestBefore = this.util.checksumRows((Table)table);
            HDFSBlocksDistribution hbd = new HDFSBlocksDistribution();
            for (HRegion region : this.util.getHBaseCluster().getRegions(TABLE_NAME)) {
                hbd.add(region.getHDFSBlocksDistribution());
            }
            for (String hostname : hostnames) {
                float locality = hbd.getBlockLocalityIndex(hostname);
                LOG.info((Object)("locality of [" + hostname + "]: " + locality));
                Assert.assertEquals((long)100L, (long)((int)(locality * 100.0f)));
            }
            admin.disableTable(TABLE_NAME);
            while (!admin.isTableDisabled(TABLE_NAME)) {
                Thread.sleep(200L);
                LOG.info((Object)"Waiting for table to disable");
            }
            admin.enableTable(TABLE_NAME);
            this.util.waitTableAvailable(TABLE_NAME);
            Assert.assertEquals((String)"Data should remain after reopening of regions", (Object)tableDigestBefore, (Object)this.util.checksumRows((Table)table));
        }
        finally {
            testDir.getFileSystem(conf).delete(testDir, true);
            this.util.deleteTable(TABLE_NAME);
            this.util.shutdownMiniCluster();
        }
    }

    private void runIncrementalPELoad(Configuration conf, HTableDescriptor tableDescriptor, RegionLocator regionLocator, Path outDir, boolean putSortReducer) throws IOException, UnsupportedEncodingException, InterruptedException, ClassNotFoundException {
        Job job = new Job(conf, "testLocalMRIncrementalLoad");
        job.setWorkingDirectory(this.util.getDataTestDirOnTestFS("runIncrementalPELoad"));
        job.getConfiguration().setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), KeyValueSerialization.class.getName()});
        this.setupRandomGeneratorMapper(job, putSortReducer);
        HFileOutputFormat2.configureIncrementalLoad((Job)job, (HTableDescriptor)tableDescriptor, (RegionLocator)regionLocator);
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Assert.assertFalse((boolean)this.util.getTestFileSystem().exists(outDir));
        Assert.assertEquals((long)regionLocator.getAllRegionLocations().size(), (long)job.getNumReduceTasks());
        Assert.assertTrue((boolean)job.waitForCompletion(true));
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testSerializeDeserializeFamilyCompressionMap() throws IOException {
        for (int numCfs = 0; numCfs <= 3; ++numCfs) {
            Configuration conf = new Configuration(this.util.getConfiguration());
            Map<String, Compression.Algorithm> familyToCompression = this.getMockColumnFamiliesForCompression(numCfs);
            Table table = (Table)Mockito.mock(HTable.class);
            this.setupMockColumnFamiliesForCompression(table, familyToCompression);
            HFileOutputFormat2.configureCompression((Configuration)conf, (HTableDescriptor)table.getTableDescriptor());
            Map retrievedFamilyToCompressionMap = HFileOutputFormat2.createFamilyCompressionMap((Configuration)conf);
            for (Map.Entry<String, Compression.Algorithm> entry : familyToCompression.entrySet()) {
                Assert.assertEquals((String)("Compression configuration incorrect for column family:" + entry.getKey()), (Object)entry.getValue(), retrievedFamilyToCompressionMap.get(entry.getKey().getBytes()));
            }
        }
    }

    private void setupMockColumnFamiliesForCompression(Table table, Map<String, Compression.Algorithm> familyToCompression) throws IOException {
        HTableDescriptor mockTableDescriptor = new HTableDescriptor(TABLE_NAME);
        for (Map.Entry<String, Compression.Algorithm> entry : familyToCompression.entrySet()) {
            mockTableDescriptor.addFamily(new HColumnDescriptor(entry.getKey()).setMaxVersions(1).setCompressionType(entry.getValue()).setBlockCacheEnabled(false).setTimeToLive(0));
        }
        ((Table)Mockito.doReturn((Object)mockTableDescriptor).when((Object)table)).getTableDescriptor();
    }

    private Map<String, Compression.Algorithm> getMockColumnFamiliesForCompression(int numCfs) {
        HashMap<String, Compression.Algorithm> familyToCompression = new HashMap<String, Compression.Algorithm>();
        if (numCfs-- > 0) {
            familyToCompression.put("Family1!@#!@#&", Compression.Algorithm.LZO);
        }
        if (numCfs-- > 0) {
            familyToCompression.put("Family2=asdads&!AASD", Compression.Algorithm.SNAPPY);
        }
        if (numCfs-- > 0) {
            familyToCompression.put("Family2=asdads&!AASD", Compression.Algorithm.GZ);
        }
        if (numCfs-- > 0) {
            familyToCompression.put("Family3", Compression.Algorithm.NONE);
        }
        return familyToCompression;
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testSerializeDeserializeFamilyBloomTypeMap() throws IOException {
        for (int numCfs = 0; numCfs <= 2; ++numCfs) {
            Configuration conf = new Configuration(this.util.getConfiguration());
            Map<String, BloomType> familyToBloomType = this.getMockColumnFamiliesForBloomType(numCfs);
            Table table = (Table)Mockito.mock(HTable.class);
            this.setupMockColumnFamiliesForBloomType(table, familyToBloomType);
            HFileOutputFormat2.configureBloomType((HTableDescriptor)table.getTableDescriptor(), (Configuration)conf);
            Map retrievedFamilyToBloomTypeMap = HFileOutputFormat2.createFamilyBloomTypeMap((Configuration)conf);
            for (Map.Entry<String, BloomType> entry : familyToBloomType.entrySet()) {
                Assert.assertEquals((String)("BloomType configuration incorrect for column family:" + entry.getKey()), (Object)entry.getValue(), retrievedFamilyToBloomTypeMap.get(entry.getKey().getBytes()));
            }
        }
    }

    private void setupMockColumnFamiliesForBloomType(Table table, Map<String, BloomType> familyToDataBlockEncoding) throws IOException {
        HTableDescriptor mockTableDescriptor = new HTableDescriptor(TABLE_NAME);
        for (Map.Entry<String, BloomType> entry : familyToDataBlockEncoding.entrySet()) {
            mockTableDescriptor.addFamily(new HColumnDescriptor(entry.getKey()).setMaxVersions(1).setBloomFilterType(entry.getValue()).setBlockCacheEnabled(false).setTimeToLive(0));
        }
        ((Table)Mockito.doReturn((Object)mockTableDescriptor).when((Object)table)).getTableDescriptor();
    }

    private Map<String, BloomType> getMockColumnFamiliesForBloomType(int numCfs) {
        HashMap<String, BloomType> familyToBloomType = new HashMap<String, BloomType>();
        if (numCfs-- > 0) {
            familyToBloomType.put("Family1!@#!@#&", BloomType.ROW);
        }
        if (numCfs-- > 0) {
            familyToBloomType.put("Family2=asdads&!AASD", BloomType.ROWCOL);
        }
        if (numCfs-- > 0) {
            familyToBloomType.put("Family3", BloomType.NONE);
        }
        return familyToBloomType;
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testSerializeDeserializeFamilyBlockSizeMap() throws IOException {
        for (int numCfs = 0; numCfs <= 3; ++numCfs) {
            Configuration conf = new Configuration(this.util.getConfiguration());
            Map<String, Integer> familyToBlockSize = this.getMockColumnFamiliesForBlockSize(numCfs);
            Table table = (Table)Mockito.mock(HTable.class);
            this.setupMockColumnFamiliesForBlockSize(table, familyToBlockSize);
            HFileOutputFormat2.configureBlockSize((HTableDescriptor)table.getTableDescriptor(), (Configuration)conf);
            Map retrievedFamilyToBlockSizeMap = HFileOutputFormat2.createFamilyBlockSizeMap((Configuration)conf);
            for (Map.Entry<String, Integer> entry : familyToBlockSize.entrySet()) {
                Assert.assertEquals((String)("BlockSize configuration incorrect for column family:" + entry.getKey()), (Object)entry.getValue(), retrievedFamilyToBlockSizeMap.get(entry.getKey().getBytes()));
            }
        }
    }

    private void setupMockColumnFamiliesForBlockSize(Table table, Map<String, Integer> familyToDataBlockEncoding) throws IOException {
        HTableDescriptor mockTableDescriptor = new HTableDescriptor(TABLE_NAME);
        for (Map.Entry<String, Integer> entry : familyToDataBlockEncoding.entrySet()) {
            mockTableDescriptor.addFamily(new HColumnDescriptor(entry.getKey()).setMaxVersions(1).setBlocksize(entry.getValue().intValue()).setBlockCacheEnabled(false).setTimeToLive(0));
        }
        ((Table)Mockito.doReturn((Object)mockTableDescriptor).when((Object)table)).getTableDescriptor();
    }

    private Map<String, Integer> getMockColumnFamiliesForBlockSize(int numCfs) {
        HashMap<String, Integer> familyToBlockSize = new HashMap<String, Integer>();
        if (numCfs-- > 0) {
            familyToBlockSize.put("Family1!@#!@#&", 1234);
        }
        if (numCfs-- > 0) {
            familyToBlockSize.put("Family2=asdads&!AASD", Integer.MAX_VALUE);
        }
        if (numCfs-- > 0) {
            familyToBlockSize.put("Family2=asdads&!AASD", Integer.MAX_VALUE);
        }
        if (numCfs-- > 0) {
            familyToBlockSize.put("Family3", 0);
        }
        return familyToBlockSize;
    }

    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testSerializeDeserializeFamilyDataBlockEncodingMap() throws IOException {
        for (int numCfs = 0; numCfs <= 3; ++numCfs) {
            Configuration conf = new Configuration(this.util.getConfiguration());
            Map<String, DataBlockEncoding> familyToDataBlockEncoding = this.getMockColumnFamiliesForDataBlockEncoding(numCfs);
            Table table = (Table)Mockito.mock(HTable.class);
            this.setupMockColumnFamiliesForDataBlockEncoding(table, familyToDataBlockEncoding);
            HTableDescriptor tableDescriptor = table.getTableDescriptor();
            HFileOutputFormat2.configureDataBlockEncoding((HTableDescriptor)tableDescriptor, (Configuration)conf);
            Map retrievedFamilyToDataBlockEncodingMap = HFileOutputFormat2.createFamilyDataBlockEncodingMap((Configuration)conf);
            for (Map.Entry<String, DataBlockEncoding> entry : familyToDataBlockEncoding.entrySet()) {
                Assert.assertEquals((String)("DataBlockEncoding configuration incorrect for column family:" + entry.getKey()), (Object)entry.getValue(), retrievedFamilyToDataBlockEncodingMap.get(entry.getKey().getBytes()));
            }
        }
    }

    private void setupMockColumnFamiliesForDataBlockEncoding(Table table, Map<String, DataBlockEncoding> familyToDataBlockEncoding) throws IOException {
        HTableDescriptor mockTableDescriptor = new HTableDescriptor(TABLE_NAME);
        for (Map.Entry<String, DataBlockEncoding> entry : familyToDataBlockEncoding.entrySet()) {
            mockTableDescriptor.addFamily(new HColumnDescriptor(entry.getKey()).setMaxVersions(1).setDataBlockEncoding(entry.getValue()).setBlockCacheEnabled(false).setTimeToLive(0));
        }
        ((Table)Mockito.doReturn((Object)mockTableDescriptor).when((Object)table)).getTableDescriptor();
    }

    private Map<String, DataBlockEncoding> getMockColumnFamiliesForDataBlockEncoding(int numCfs) {
        HashMap<String, DataBlockEncoding> familyToDataBlockEncoding = new HashMap<String, DataBlockEncoding>();
        if (numCfs-- > 0) {
            familyToDataBlockEncoding.put("Family1!@#!@#&", DataBlockEncoding.DIFF);
        }
        if (numCfs-- > 0) {
            familyToDataBlockEncoding.put("Family2=asdads&!AASD", DataBlockEncoding.FAST_DIFF);
        }
        if (numCfs-- > 0) {
            familyToDataBlockEncoding.put("Family2=asdads&!AASD", DataBlockEncoding.PREFIX);
        }
        if (numCfs-- > 0) {
            familyToDataBlockEncoding.put("Family3", DataBlockEncoding.NONE);
        }
        return familyToDataBlockEncoding;
    }

    private void setupMockStartKeys(RegionLocator table) throws IOException {
        byte[][] mockKeys = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"zzz")};
        ((RegionLocator)Mockito.doReturn((Object)mockKeys).when((Object)table)).getStartKeys();
    }

    private void setupMockTableName(RegionLocator table) throws IOException {
        TableName mockTableName = TableName.valueOf((String)"mock_table");
        ((RegionLocator)Mockito.doReturn((Object)mockTableName).when((Object)table)).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testColumnFamilySettings() throws Exception {
        Configuration conf = new Configuration(this.util.getConfiguration());
        RecordWriter writer = null;
        TaskAttemptContext context = null;
        Path dir = this.util.getDataTestDir("testColumnFamilySettings");
        Table table = (Table)Mockito.mock(Table.class);
        RegionLocator regionLocator = (RegionLocator)Mockito.mock(RegionLocator.class);
        HTableDescriptor htd = new HTableDescriptor(TABLE_NAME);
        ((Table)Mockito.doReturn((Object)htd).when((Object)table)).getTableDescriptor();
        for (HColumnDescriptor hcd : HBaseTestingUtility.generateColumnDescriptors()) {
            htd.addFamily(hcd);
        }
        this.setupMockStartKeys(regionLocator);
        try {
            conf.set("io.seqfile.compression.type", "NONE");
            conf.set("hbase.fs.tmp.dir", dir.toString());
            conf.setBoolean("hbase.bulkload.locality.sensitive.enabled", false);
            Job job = new Job(conf, "testLocalMRIncrementalLoad");
            job.setWorkingDirectory(this.util.getDataTestDirOnTestFS("testColumnFamilySettings"));
            this.setupRandomGeneratorMapper(job, false);
            HFileOutputFormat2.configureIncrementalLoad((Job)job, (HTableDescriptor)table.getTableDescriptor(), (RegionLocator)regionLocator);
            FileOutputFormat.setOutputPath((Job)job, (Path)dir);
            context = this.createTestTaskAttemptContext(job);
            HFileOutputFormat2 hof = new HFileOutputFormat2();
            writer = hof.getRecordWriter(context);
            this.writeRandomKeyValues((RecordWriter<ImmutableBytesWritable, Cell>)writer, context, htd.getFamiliesKeys(), 1024);
            writer.close(context);
            FileSystem fs = dir.getFileSystem(conf);
            hof.getOutputCommitter(context).commitTask(context);
            hof.getOutputCommitter(context).commitJob((JobContext)context);
            FileStatus[] families = FSUtils.listStatus((FileSystem)fs, (Path)dir, (PathFilter)new FSUtils.FamilyDirFilter(fs));
            Assert.assertEquals((long)htd.getFamilies().size(), (long)families.length);
            for (FileStatus f : families) {
                String familyStr = f.getPath().getName();
                HColumnDescriptor hcd = htd.getFamily(Bytes.toBytes((String)familyStr));
                Path dataFilePath = fs.listStatus(f.getPath())[0].getPath();
                HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)dataFilePath, (CacheConfig)new CacheConfig(conf), (Configuration)conf);
                Map fileInfo = reader.loadFileInfo();
                byte[] bloomFilter = (byte[])fileInfo.get(StoreFile.BLOOM_FILTER_TYPE_KEY);
                if (bloomFilter == null) {
                    bloomFilter = Bytes.toBytes((String)"NONE");
                }
                Assert.assertEquals((String)("Incorrect bloom filter used for column family " + familyStr + "(reader: " + reader + ")"), (Object)hcd.getBloomFilterType(), (Object)BloomType.valueOf((String)Bytes.toString((byte[])bloomFilter)));
                Assert.assertEquals((String)("Incorrect compression used for column family " + familyStr + "(reader: " + reader + ")"), (Object)hcd.getCompression(), (Object)reader.getFileContext().getCompression());
            }
        }
        finally {
            dir.getFileSystem(conf).delete(dir, true);
        }
    }

    private void writeRandomKeyValues(RecordWriter<ImmutableBytesWritable, Cell> writer, TaskAttemptContext context, Set<byte[]> families, int numRows) throws IOException, InterruptedException {
        byte[] keyBytes = new byte[4];
        int valLength = 10;
        byte[] valBytes = new byte[valLength];
        int taskId = context.getTaskAttemptID().getTaskID().getId();
        assert (taskId < 127) : "Unit tests dont support > 127 tasks!";
        byte[] qualifier = Bytes.toBytes((String)"data");
        Random random = new Random();
        for (int i = 0; i < numRows; ++i) {
            Bytes.putInt((byte[])keyBytes, (int)0, (int)i);
            random.nextBytes(valBytes);
            ImmutableBytesWritable key = new ImmutableBytesWritable(keyBytes);
            for (byte[] family : families) {
                KeyValue kv = new KeyValue(keyBytes, family, qualifier, valBytes);
                writer.write((Object)key, (Object)kv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Flakey: See HBASE-9051")
    @Test
    public void testExcludeAllFromMinorCompaction() throws Exception {
        Configuration conf = this.util.getConfiguration();
        conf.setInt("hbase.hstore.compaction.min", 2);
        this.generateRandomStartKeys(5);
        this.util.setJobWithoutMRCluster();
        this.util.startMiniCluster();
        try (Connection conn = ConnectionFactory.createConnection();){
            Admin admin = conn.getAdmin();
            Throwable throwable = null;
            try {
                DistributedFileSystem fs = this.util.getDFSCluster().getFileSystem();
                HTable table = this.util.createTable(TABLE_NAME, FAMILIES);
                Assert.assertEquals((String)"Should start with empty table", (long)0L, (long)this.util.countRows((Table)table));
                Path storePath = new Path(FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)TABLE_NAME), new Path(((HRegionInfo)admin.getTableRegions(TABLE_NAME).get(0)).getEncodedName(), Bytes.toString((byte[])FAMILIES[0])));
                Assert.assertEquals((long)0L, (long)fs.listStatus(storePath).length);
                conf.setBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", true);
                for (int i = 0; i < 2; ++i) {
                    Path testDir = this.util.getDataTestDirOnTestFS("testExcludeAllFromMinorCompaction_" + i);
                    this.runIncrementalPELoad(conf, table.getTableDescriptor(), conn.getRegionLocator(TABLE_NAME), testDir, false);
                    new LoadIncrementalHFiles(conf).doBulkLoad(testDir, table);
                }
                int expectedRows = 2 * NMapInputFormat.getNumMapTasks(conf) * 1024;
                Assert.assertEquals((String)"LoadIncrementalHFiles should put expected data in table", (long)expectedRows, (long)this.util.countRows((Table)table));
                Assert.assertEquals((long)2L, (long)fs.listStatus(storePath).length);
                admin.compact(TABLE_NAME);
                try {
                    this.quickPoll(new Callable<Boolean>((FileSystem)fs, storePath){
                        final /* synthetic */ FileSystem val$fs;
                        final /* synthetic */ Path val$storePath;
                        {
                            this.val$fs = fileSystem;
                            this.val$storePath = path;
                        }

                        @Override
                        public Boolean call() throws Exception {
                            List<HRegion> regions = TestHFileOutputFormat2.this.util.getMiniHBaseCluster().getRegions(TABLE_NAME);
                            for (HRegion region : regions) {
                                for (Store store : region.getStores()) {
                                    store.closeAndArchiveCompactedFiles();
                                }
                            }
                            return this.val$fs.listStatus(this.val$storePath).length == 1;
                        }
                    }, 5000);
                    throw new IOException("SF# = " + fs.listStatus(storePath).length);
                }
                catch (AssertionError assertionError) {
                    admin.majorCompact(TABLE_NAME);
                    this.quickPoll(new Callable<Boolean>((FileSystem)fs, storePath){
                        final /* synthetic */ FileSystem val$fs;
                        final /* synthetic */ Path val$storePath;
                        {
                            this.val$fs = fileSystem;
                            this.val$storePath = path;
                        }

                        @Override
                        public Boolean call() throws Exception {
                            List<HRegion> regions = TestHFileOutputFormat2.this.util.getMiniHBaseCluster().getRegions(TABLE_NAME);
                            for (HRegion region : regions) {
                                for (Store store : region.getStores()) {
                                    store.closeAndArchiveCompactedFiles();
                                }
                            }
                            return this.val$fs.listStatus(this.val$storePath).length == 1;
                        }
                    }, 5000);
                    if (admin != null) {
                        if (throwable != null) {
                            try {
                                admin.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            admin.close();
                        }
                    }
                }
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (admin != null) {
                        if (throwable != null) {
                            try {
                                admin.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            admin.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
        finally {
            this.util.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Goes zombie too frequently; needs work. See HBASE-14563")
    @Test
    public void testExcludeMinorCompaction() throws Exception {
        Configuration conf = this.util.getConfiguration();
        conf.setInt("hbase.hstore.compaction.min", 2);
        this.generateRandomStartKeys(5);
        this.util.setJobWithoutMRCluster();
        this.util.startMiniCluster();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
            Admin admin = conn.getAdmin();
            Throwable throwable = null;
            try {
                Path testDir = this.util.getDataTestDirOnTestFS("testExcludeMinorCompaction");
                DistributedFileSystem fs = this.util.getDFSCluster().getFileSystem();
                HTable table = this.util.createTable(TABLE_NAME, FAMILIES);
                Assert.assertEquals((String)"Should start with empty table", (long)0L, (long)this.util.countRows((Table)table));
                Path storePath = new Path(FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)TABLE_NAME), new Path(((HRegionInfo)admin.getTableRegions(TABLE_NAME).get(0)).getEncodedName(), Bytes.toString((byte[])FAMILIES[0])));
                Assert.assertEquals((long)0L, (long)fs.listStatus(storePath).length);
                Put p = new Put(Bytes.toBytes((String)"test"));
                p.add(FAMILIES[0], Bytes.toBytes((String)"1"), Bytes.toBytes((String)"1"));
                table.put(p);
                admin.flush(TABLE_NAME);
                Assert.assertEquals((long)1L, (long)this.util.countRows((Table)table));
                this.quickPoll(new Callable<Boolean>((FileSystem)fs, storePath){
                    final /* synthetic */ FileSystem val$fs;
                    final /* synthetic */ Path val$storePath;
                    {
                        this.val$fs = fileSystem;
                        this.val$storePath = path;
                    }

                    @Override
                    public Boolean call() throws Exception {
                        return this.val$fs.listStatus(this.val$storePath).length == 1;
                    }
                }, 5000);
                conf.setBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", true);
                RegionLocator regionLocator = conn.getRegionLocator(TABLE_NAME);
                this.runIncrementalPELoad(conf, table.getTableDescriptor(), regionLocator, testDir, false);
                new LoadIncrementalHFiles(conf).doBulkLoad(testDir, admin, (Table)table, regionLocator);
                int expectedRows = NMapInputFormat.getNumMapTasks(conf) * 1024;
                Assert.assertEquals((String)"LoadIncrementalHFiles should put expected data in table", (long)(expectedRows + 1), (long)this.util.countRows((Table)table));
                Assert.assertEquals((long)2L, (long)fs.listStatus(storePath).length);
                admin.compact(TABLE_NAME);
                try {
                    this.quickPoll(new Callable<Boolean>((FileSystem)fs, storePath){
                        final /* synthetic */ FileSystem val$fs;
                        final /* synthetic */ Path val$storePath;
                        {
                            this.val$fs = fileSystem;
                            this.val$storePath = path;
                        }

                        @Override
                        public Boolean call() throws Exception {
                            return this.val$fs.listStatus(this.val$storePath).length == 1;
                        }
                    }, 5000);
                    throw new IOException("SF# = " + fs.listStatus(storePath).length);
                }
                catch (AssertionError assertionError) {
                    admin.majorCompact(TABLE_NAME);
                    this.quickPoll(new Callable<Boolean>((FileSystem)fs, storePath){
                        final /* synthetic */ FileSystem val$fs;
                        final /* synthetic */ Path val$storePath;
                        {
                            this.val$fs = fileSystem;
                            this.val$storePath = path;
                        }

                        @Override
                        public Boolean call() throws Exception {
                            return this.val$fs.listStatus(this.val$storePath).length == 1;
                        }
                    }, 5000);
                    if (admin != null) {
                        if (throwable != null) {
                            try {
                                admin.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            admin.close();
                        }
                    }
                }
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (admin != null) {
                        if (throwable != null) {
                            try {
                                admin.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            admin.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
        finally {
            this.util.shutdownMiniCluster();
        }
    }

    private void quickPoll(Callable<Boolean> c, int waitMs) throws Exception {
        int sleepMs = 10;
        int retries = (int)Math.ceil((double)waitMs / (double)sleepMs);
        while (retries-- > 0) {
            if (c.call().booleanValue()) {
                return;
            }
            Thread.sleep(sleepMs);
        }
        Assert.fail();
    }

    public static void main(String[] args) throws Exception {
        new TestHFileOutputFormat2().manualTest(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manualTest(String[] args) throws Exception {
        block45: {
            Configuration conf = HBaseConfiguration.create();
            this.util = new HBaseTestingUtility(conf);
            if ("newtable".equals(args[0])) {
                TableName tname = TableName.valueOf((String)args[1]);
                byte[][] splitKeys = this.generateRandomSplitKeys(4);
                HTable table = this.util.createTable(tname, FAMILIES, splitKeys);
                Throwable throwable = null;
                if (table != null) {
                    if (throwable != null) {
                        try {
                            table.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        table.close();
                    }
                }
            } else {
                if ("incremental".equals(args[0])) {
                    TableName tname = TableName.valueOf((String)args[1]);
                    try (Connection c = ConnectionFactory.createConnection((Configuration)conf);
                         Admin admin = c.getAdmin();
                         RegionLocator regionLocator = c.getRegionLocator(tname);){
                        Path outDir = new Path("incremental-out");
                        this.runIncrementalPELoad(conf, admin.getTableDescriptor(tname), regionLocator, outDir, false);
                        break block45;
                    }
                }
                throw new RuntimeException("usage: TestHFileOutputFormat2 newtable | incremental");
            }
        }
    }

    static class RandomPutGeneratingMapper
    extends Mapper<NullWritable, NullWritable, ImmutableBytesWritable, Put> {
        private int keyLength;
        private static final int KEYLEN_DEFAULT = 10;
        private static final String KEYLEN_CONF = "randomkv.key.length";
        private int valLength;
        private static final int VALLEN_DEFAULT = 10;
        private static final String VALLEN_CONF = "randomkv.val.length";
        private static final byte[] QUALIFIER = Bytes.toBytes((String)"data");

        RandomPutGeneratingMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            Configuration conf = context.getConfiguration();
            this.keyLength = conf.getInt(KEYLEN_CONF, 10);
            this.valLength = conf.getInt(VALLEN_CONF, 10);
        }

        protected void map(NullWritable n1, NullWritable n2, Mapper.Context context) throws IOException, InterruptedException {
            byte[] keyBytes = new byte[this.keyLength];
            byte[] valBytes = new byte[this.valLength];
            int taskId = context.getTaskAttemptID().getTaskID().getId();
            assert (taskId < 127) : "Unit tests dont support > 127 tasks!";
            Random random = new Random();
            for (int i = 0; i < 1024; ++i) {
                random.nextBytes(keyBytes);
                keyBytes[this.keyLength - 1] = (byte)(taskId & 0xFF);
                random.nextBytes(valBytes);
                ImmutableBytesWritable key = new ImmutableBytesWritable(keyBytes);
                for (byte[] family : FAMILIES) {
                    Put p = new Put(keyBytes);
                    p.addColumn(family, QUALIFIER, valBytes);
                    p.setTTL(1L);
                    context.write((Object)key, (Object)p);
                }
            }
        }
    }

    static class RandomKVGeneratingMapper
    extends Mapper<NullWritable, NullWritable, ImmutableBytesWritable, Cell> {
        private int keyLength;
        private static final int KEYLEN_DEFAULT = 10;
        private static final String KEYLEN_CONF = "randomkv.key.length";
        private int valLength;
        private static final int VALLEN_DEFAULT = 10;
        private static final String VALLEN_CONF = "randomkv.val.length";
        private static final byte[] QUALIFIER = Bytes.toBytes((String)"data");

        RandomKVGeneratingMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            Configuration conf = context.getConfiguration();
            this.keyLength = conf.getInt(KEYLEN_CONF, 10);
            this.valLength = conf.getInt(VALLEN_CONF, 10);
        }

        protected void map(NullWritable n1, NullWritable n2, Mapper.Context context) throws IOException, InterruptedException {
            byte[] keyBytes = new byte[this.keyLength];
            byte[] valBytes = new byte[this.valLength];
            int taskId = context.getTaskAttemptID().getTaskID().getId();
            assert (taskId < 127) : "Unit tests dont support > 127 tasks!";
            Random random = new Random();
            for (int i = 0; i < 1024; ++i) {
                random.nextBytes(keyBytes);
                keyBytes[this.keyLength - 1] = (byte)(taskId & 0xFF);
                random.nextBytes(valBytes);
                ImmutableBytesWritable key = new ImmutableBytesWritable(keyBytes);
                for (byte[] family : FAMILIES) {
                    KeyValue kv = new KeyValue(keyBytes, family, QUALIFIER, valBytes);
                    context.write((Object)key, (Object)kv);
                }
            }
        }
    }
}

