/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestServerCrashProcedure {
    private final HBaseTestingUtility util = new HBaseTestingUtility();

    @Parameterized.Parameters(name="{index}: setting={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{Boolean.FALSE, -1}});
    }

    @Before
    public void setup() throws Exception {
        this.util.startMiniCluster(3);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)this.util.getHBaseCluster().getMaster().getMasterProcedureExecutor(), (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        HMaster master;
        MiniHBaseCluster cluster = this.util.getHBaseCluster();
        HMaster hMaster = master = cluster == null ? null : cluster.getMaster();
        if (master != null && master.getMasterProcedureExecutor() != null) {
            ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)master.getMasterProcedureExecutor(), (boolean)false);
        }
        this.util.shutdownMiniCluster();
    }

    public TestServerCrashProcedure(Boolean b, int ignore) {
        this.util.getConfiguration().setBoolean("hbase.master.distributed.log.replay", b.booleanValue());
        this.util.getConfiguration().setInt("hbase.master.procedure.threads", 1);
    }

    @Test(timeout=300000L)
    public void testRecoveryAndDoubleExecutionOnline() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRecoveryAndDoubleExecutionOnline");
        this.util.createTable(tableName, HBaseTestingUtility.COLUMNS, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        try (Table t = this.util.getConnection().getTable(tableName);){
            this.util.loadTable(t, HBaseTestingUtility.COLUMNS[0]);
            int count = this.countRows(t);
            HMaster master = this.util.getHBaseCluster().getMaster();
            ProcedureExecutor procExec = master.getMasterProcedureExecutor();
            master.setServerCrashProcessingEnabled(false);
            HRegionServer hrs = this.util.getHBaseCluster().getRegionServer(0);
            boolean carryingMeta = master.getAssignmentManager().isCarryingMeta(hrs.getServerName()) == AssignmentManager.ServerHostRegion.HOSTING_REGION;
            this.util.getHBaseCluster().killRegionServer(hrs.getServerName());
            hrs.join();
            while (!master.getServerManager().isServerDead(hrs.getServerName())) {
                Threads.sleep((long)10L);
            }
            master.setServerCrashProcessingEnabled(true);
            master.getServerManager().moveFromOnlineToDeadServers(hrs.getServerName());
            ProcedureTestingUtility.waitNoProcedureRunning((ProcedureExecutor)procExec);
            ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)procExec, (boolean)true);
            long procId = procExec.submitProcedure((Procedure)new ServerCrashProcedure((MasterProcedureEnv)procExec.getEnvironment(), hrs.getServerName(), true, carryingMeta));
            MasterProcedureTestingUtility.testRecoveryAndDoubleExecution((ProcedureExecutor<MasterProcedureEnv>)procExec, procId);
            Assert.assertEquals((long)count, (long)this.countRows(t));
        }
    }

    int countRows(Table t) throws IOException {
        int count = 0;
        try (ResultScanner scanner = t.getScanner(new Scan());){
            while (scanner.next() != null) {
                ++count;
            }
        }
        return count;
    }
}

