/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class HBaseCluster
implements Closeable,
Configurable {
    static final Logger LOG = LoggerFactory.getLogger((String)HBaseCluster.class.getName());
    protected Configuration conf;
    protected ClusterMetrics initialClusterStatus;

    public HBaseCluster(Configuration conf) {
        this.setConf(conf);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public abstract ClusterMetrics getClusterMetrics() throws IOException;

    public ClusterMetrics getInitialClusterMetrics() throws IOException {
        return this.initialClusterStatus;
    }

    public abstract MasterProtos.MasterService.BlockingInterface getMasterAdminService() throws IOException;

    public abstract AdminProtos.AdminService.BlockingInterface getAdminProtocol(ServerName var1) throws IOException;

    public abstract ClientProtos.ClientService.BlockingInterface getClientProtocol(ServerName var1) throws IOException;

    public abstract void startRegionServer(String var1, int var2) throws IOException;

    public abstract void killRegionServer(ServerName var1) throws IOException;

    public abstract boolean isKilledRS(ServerName var1);

    public abstract void stopRegionServer(ServerName var1) throws IOException;

    public void waitForRegionServerToStart(String hostname, int port, long timeout) throws IOException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            for (ServerName server : this.getClusterMetrics().getLiveServerMetrics().keySet()) {
                if (!server.getHostname().equals(hostname) || server.getPort() != port) continue;
                return;
            }
            Threads.sleep((long)100L);
        }
        throw new IOException("did timeout " + timeout + "ms waiting for region server to start: " + hostname);
    }

    public abstract void waitForRegionServerToStop(ServerName var1, long var2) throws IOException;

    public abstract void startZkNode(String var1, int var2) throws IOException;

    public abstract void killZkNode(ServerName var1) throws IOException;

    public abstract void stopZkNode(ServerName var1) throws IOException;

    public abstract void waitForZkNodeToStart(ServerName var1, long var2) throws IOException;

    public abstract void waitForZkNodeToStop(ServerName var1, long var2) throws IOException;

    public abstract void startDataNode(ServerName var1) throws IOException;

    public abstract void killDataNode(ServerName var1) throws IOException;

    public abstract void stopDataNode(ServerName var1) throws IOException;

    public abstract void waitForDataNodeToStart(ServerName var1, long var2) throws IOException;

    public abstract void waitForDataNodeToStop(ServerName var1, long var2) throws IOException;

    public abstract void startMaster(String var1, int var2) throws IOException;

    public abstract void killMaster(ServerName var1) throws IOException;

    public abstract void stopMaster(ServerName var1) throws IOException;

    public abstract void waitForMasterToStop(ServerName var1, long var2) throws IOException;

    public boolean waitForActiveAndReadyMaster() throws IOException {
        return this.waitForActiveAndReadyMaster(Long.MAX_VALUE);
    }

    public abstract boolean waitForActiveAndReadyMaster(long var1) throws IOException;

    public abstract void waitUntilShutDown() throws IOException;

    public abstract void shutdown() throws IOException;

    public boolean restoreInitialStatus() throws IOException {
        return this.restoreClusterMetrics(this.getInitialClusterMetrics());
    }

    public boolean restoreClusterMetrics(ClusterMetrics desiredStatus) throws IOException {
        return true;
    }

    public ServerName getServerHoldingMeta() throws IOException {
        return this.getServerHoldingRegion(TableName.META_TABLE_NAME, RegionInfoBuilder.FIRST_META_REGIONINFO.getRegionName());
    }

    public abstract ServerName getServerHoldingRegion(TableName var1, byte[] var2) throws IOException;

    public boolean isDistributedCluster() {
        return false;
    }

    @Override
    public abstract void close() throws IOException;

    public void waitForNamenodeAvailable() throws InterruptedException {
    }

    public void waitForDatanodesRegistered(int nbDN) throws Exception {
    }
}

