/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.DelegatingRpcScheduler;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMetaTableAccessor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaTableAccessor.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaTableAccessor.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Connection connection;
    private Random random = new Random();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster(3);
        Configuration c = new Configuration(UTIL.getConfiguration());
        c.setLong("hbase.client.pause", 1000L);
        c.setInt("hbase.client.retries.number", 10);
        connection = ConnectionFactory.createConnection((Configuration)c);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        connection.close();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testGettingMergeRegions() throws IOException {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        Put put = new Put(Bytes.toBytes((String)this.name.getMethodName()));
        ArrayList<RegionInfo> ris = new ArrayList<RegionInfo>();
        int limit = 10;
        byte[] previous = HConstants.EMPTY_START_ROW;
        for (int i = 0; i < limit; ++i) {
            RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(previous).setEndKey(Bytes.toBytes((int)i)).build();
            ris.add(ri);
        }
        put = MetaTableAccessor.addMergeRegions((Put)put, ris);
        List cells = (List)put.getFamilyCellMap().get(HConstants.CATALOG_FAMILY);
        String previousQualifier = null;
        Assert.assertEquals((long)limit, (long)cells.size());
        for (Cell cell : cells) {
            LOG.info(cell.toString());
            String qualifier = Bytes.toString((byte[])cell.getQualifierArray());
            Assert.assertTrue((boolean)qualifier.startsWith("merge"));
            Assert.assertNotEquals((Object)qualifier, previousQualifier);
            previousQualifier = qualifier;
        }
    }

    @Test
    public void testIsMetaWhenAllHealthy() throws InterruptedException {
        HMaster m = UTIL.getMiniHBaseCluster().getMaster();
        Assert.assertTrue((boolean)m.waitForMetaOnline());
    }

    @Test
    public void testIsMetaWhenMetaGoesOffline() throws InterruptedException {
        HMaster m = UTIL.getMiniHBaseCluster().getMaster();
        int index = UTIL.getMiniHBaseCluster().getServerWithMeta();
        HRegionServer rsWithMeta = UTIL.getMiniHBaseCluster().getRegionServer(index);
        rsWithMeta.abort("TESTING");
        Assert.assertTrue((boolean)m.waitForMetaOnline());
    }

    @Test
    public void testRetrying() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        LOG.info("Started " + tableName);
        Table t = UTIL.createMultiRegionTable(tableName, HConstants.CATALOG_FAMILY);
        int regionCount = -1;
        try (RegionLocator r = UTIL.getConnection().getRegionLocator(tableName);){
            regionCount = r.getStartKeys().length;
        }
        final List<RegionInfo> regions = TestMetaTableAccessor.testGettingTableRegions(connection, tableName, regionCount);
        MetaTask reader = new MetaTask(connection, "reader"){

            @Override
            void metaTask() throws Throwable {
                TestMetaTableAccessor.testGetRegion(this.connection, (RegionInfo)regions.get(0));
                LOG.info("Read " + ((RegionInfo)regions.get(0)).getEncodedName());
            }
        };
        MetaTask writer = new MetaTask(connection, "writer"){

            @Override
            void metaTask() throws Throwable {
                MetaTableAccessor.addRegionToMeta((Connection)this.connection, (RegionInfo)((RegionInfo)regions.get(0)));
                LOG.info("Wrote " + ((RegionInfo)regions.get(0)).getEncodedName());
            }
        };
        reader.start();
        writer.start();
        long timeOut = 180000L;
        long startTime = System.currentTimeMillis();
        try {
            Assert.assertTrue((boolean)reader.isProgressing());
            Assert.assertTrue((boolean)writer.isProgressing());
            for (int i = 0; i < 2; ++i) {
                LOG.info("Restart=" + i);
                UTIL.ensureSomeRegionServersAvailable(2);
                int index = -1;
                while ((index = UTIL.getMiniHBaseCluster().getServerWithMeta()) == -1 && startTime + 180000L < System.currentTimeMillis()) {
                }
                if (index == -1) continue;
                UTIL.getMiniHBaseCluster().abortRegionServer(index);
                UTIL.getMiniHBaseCluster().waitOnRegionServer(index);
            }
            Assert.assertTrue((String)("reader: " + reader.toString()), (boolean)reader.isProgressing());
            Assert.assertTrue((String)("writer: " + writer.toString()), (boolean)writer.isProgressing());
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            reader.stop = true;
            writer.stop = true;
            reader.join();
            writer.join();
            t.close();
        }
        long exeTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)("Timeout: test took " + exeTime / 1000L + " sec"), (exeTime < 180000L ? 1 : 0) != 0);
    }

    @Test
    public void testGetRegionsFromMetaTable() throws IOException, InterruptedException {
        MetaTableLocator mtl = new MetaTableLocator();
        List regions = mtl.getMetaRegions(UTIL.getZooKeeperWatcher());
        Assert.assertTrue((regions.size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((mtl.getMetaRegionsAndLocations(UTIL.getZooKeeperWatcher()).size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testTableExists() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Assert.assertFalse((boolean)MetaTableAccessor.tableExists((Connection)connection, (TableName)tableName));
        UTIL.createTable(tableName, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)MetaTableAccessor.tableExists((Connection)connection, (TableName)tableName));
        Admin admin = UTIL.getAdmin();
        admin.disableTable(tableName);
        admin.deleteTable(tableName);
        Assert.assertFalse((boolean)MetaTableAccessor.tableExists((Connection)connection, (TableName)tableName));
        Assert.assertTrue((boolean)MetaTableAccessor.tableExists((Connection)connection, (TableName)TableName.META_TABLE_NAME));
        UTIL.createTable(tableName, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)MetaTableAccessor.tableExists((Connection)connection, (TableName)tableName));
        admin.disableTable(tableName);
        admin.deleteTable(tableName);
        Assert.assertFalse((boolean)MetaTableAccessor.tableExists((Connection)connection, (TableName)tableName));
    }

    @Test
    public void testGetRegion() throws IOException, InterruptedException {
        String name = this.name.getMethodName();
        LOG.info("Started " + name);
        Pair pair = MetaTableAccessor.getRegion((Connection)connection, (byte[])Bytes.toBytes((String)"nonexistent-region"));
        Assert.assertNull((Object)pair);
        LOG.info("Finished " + name);
    }

    @Test
    public void testScanMetaForTable() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        LOG.info("Started " + tableName);
        UTIL.createTable(tableName, HConstants.CATALOG_FAMILY);
        TableName greaterName = TableName.valueOf((String)"testScanMetaForTablf");
        UTIL.createTable(greaterName, HConstants.CATALOG_FAMILY);
        Assert.assertEquals((long)1L, (long)MetaTableAccessor.getTableRegions((Connection)connection, (TableName)tableName).size());
        Assert.assertEquals((long)1L, (long)MetaTableAccessor.getTableRegions((Connection)connection, (TableName)greaterName).size());
    }

    private static List<RegionInfo> testGettingTableRegions(Connection connection, TableName name, int regionCount) throws IOException, InterruptedException {
        List regions = MetaTableAccessor.getTableRegions((Connection)connection, (TableName)name);
        Assert.assertEquals((long)regionCount, (long)regions.size());
        Pair pair = MetaTableAccessor.getRegion((Connection)connection, (byte[])((RegionInfo)regions.get(0)).getRegionName());
        Assert.assertEquals((Object)((RegionInfo)regions.get(0)).getEncodedName(), (Object)((RegionInfo)pair.getFirst()).getEncodedName());
        return regions;
    }

    private static void testGetRegion(Connection connection, RegionInfo region) throws IOException, InterruptedException {
        Pair pair = MetaTableAccessor.getRegion((Connection)connection, (byte[])region.getRegionName());
        Assert.assertEquals((Object)region.getEncodedName(), (Object)((RegionInfo)pair.getFirst()).getEncodedName());
    }

    @Test
    public void testParseReplicaIdFromServerColumn() {
        String column1 = "server";
        Assert.assertEquals((long)0L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])Bytes.toBytes((String)column1)));
        String column2 = column1 + '_';
        Assert.assertEquals((long)-1L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])Bytes.toBytes((String)column2)));
        String column3 = column2 + "00";
        Assert.assertEquals((long)-1L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])Bytes.toBytes((String)column3)));
        String column4 = column3 + "2A";
        Assert.assertEquals((long)42L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])Bytes.toBytes((String)column4)));
        String column5 = column4 + "2A";
        Assert.assertEquals((long)-1L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])Bytes.toBytes((String)column5)));
        String column6 = "serverstartcode";
        Assert.assertEquals((long)-1L, (long)MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])Bytes.toBytes((String)column6)));
    }

    @Test
    public void testMetaReaderGetColumnMethods() {
        Assert.assertArrayEquals((byte[])HConstants.SERVER_QUALIFIER, (byte[])MetaTableAccessor.getServerColumn((int)0));
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"server_002A"), (byte[])MetaTableAccessor.getServerColumn((int)42));
        Assert.assertArrayEquals((byte[])HConstants.STARTCODE_QUALIFIER, (byte[])MetaTableAccessor.getStartCodeColumn((int)0));
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"serverstartcode_002A"), (byte[])MetaTableAccessor.getStartCodeColumn((int)42));
        Assert.assertArrayEquals((byte[])HConstants.SEQNUM_QUALIFIER, (byte[])MetaTableAccessor.getSeqNumColumn((int)0));
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"seqnumDuringOpen_002A"), (byte[])MetaTableAccessor.getSeqNumColumn((int)42));
    }

    @Test
    public void testMetaLocationsForRegionReplicas() throws IOException {
        ServerName serverName0 = ServerName.valueOf((String)"foo", (int)60010, (long)this.random.nextLong());
        ServerName serverName1 = ServerName.valueOf((String)"bar", (int)60010, (long)this.random.nextLong());
        ServerName serverName100 = ServerName.valueOf((String)"baz", (int)60010, (long)this.random.nextLong());
        long regionId = System.currentTimeMillis();
        RegionInfo primary = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo replica1 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(1).build();
        RegionInfo replica100 = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(100).build();
        long seqNum0 = this.random.nextLong();
        long seqNum1 = this.random.nextLong();
        long seqNum100 = this.random.nextLong();
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            MetaTableAccessor.updateRegionLocation((Connection)connection, (RegionInfo)primary, (ServerName)serverName0, (long)seqNum0, (long)EnvironmentEdgeManager.currentTime());
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName0, seqNum0, 0, true);
            MetaTableAccessor.updateRegionLocation((Connection)connection, (RegionInfo)replica1, (ServerName)serverName1, (long)seqNum1, (long)EnvironmentEdgeManager.currentTime());
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName0, seqNum0, 0, true);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName1, seqNum1, 1, true);
            MetaTableAccessor.updateRegionLocation((Connection)connection, (RegionInfo)replica100, (ServerName)serverName100, (long)seqNum100, (long)EnvironmentEdgeManager.currentTime());
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName0, seqNum0, 0, true);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName1, seqNum1, 1, true);
            TestMetaTableAccessor.assertMetaLocation(meta, primary.getRegionName(), serverName100, seqNum100, 100, true);
        }
    }

    public static void assertMetaLocation(Table meta, byte[] row, ServerName serverName, long seqNum, int replicaId, boolean checkSeqNum) throws IOException {
        Get get = new Get(row);
        Result result = meta.get(get);
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)replicaId)), (byte[])Bytes.toBytes((String)serverName.getHostAndPort())));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)replicaId)), (byte[])Bytes.toBytes((long)serverName.getStartcode())));
        if (checkSeqNum) {
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn((int)replicaId)), (byte[])Bytes.toBytes((long)seqNum)));
        }
    }

    public static void assertEmptyMetaLocation(Table meta, byte[] row, int replicaId) throws IOException {
        Get get = new Get(row);
        Result result = meta.get(get);
        Cell serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)replicaId));
        Cell startCodeCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)replicaId));
        Assert.assertNotNull((Object)serverCell);
        Assert.assertNotNull((Object)startCodeCell);
        Assert.assertEquals((long)0L, (long)serverCell.getValueLength());
        Assert.assertEquals((long)0L, (long)startCodeCell.getValueLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaLocationForRegionReplicasIsRemovedAtTableDeletion() throws IOException {
        long regionId = System.currentTimeMillis();
        RegionInfo primary = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{primary});
            MetaTableAccessor.addRegionsToMeta((Connection)connection, (List)regionInfos, (int)3);
            MetaTableAccessor.removeRegionReplicasFromMeta((Set)Sets.newHashSet((Object[])new byte[][]{primary.getRegionName()}), (int)1, (int)2, (Connection)connection);
            Get get = new Get(primary.getRegionName());
            Result result = meta.get(get);
            for (int replicaId = 0; replicaId < 3; ++replicaId) {
                Cell serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)replicaId));
                Cell startCodeCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)replicaId));
                Cell stateCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getRegionStateColumn((int)replicaId));
                Cell snCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerNameColumn((int)replicaId));
                if (replicaId == 0) {
                    Assert.assertNotNull((Object)stateCell);
                    continue;
                }
                Assert.assertNull((Object)serverCell);
                Assert.assertNull((Object)startCodeCell);
                Assert.assertNull((Object)stateCell);
                Assert.assertNull((Object)snCell);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaLocationForRegionReplicasIsAddedAtTableCreation() throws IOException {
        long regionId = System.currentTimeMillis();
        RegionInfo primary = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{primary});
            MetaTableAccessor.addRegionsToMeta((Connection)connection, (List)regionInfos, (int)3);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, primary.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, primary.getRegionName(), 2);
        }
    }

    @Test
    public void testMetaLocationForRegionReplicasIsAddedAtRegionSplit() throws IOException {
        long regionId = System.currentTimeMillis();
        ServerName serverName0 = ServerName.valueOf((String)"foo", (int)60010, (long)this.random.nextLong());
        RegionInfo parent = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo splitA = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(Bytes.toBytes((String)"a")).setSplit(false).setRegionId(regionId + 1L).setReplicaId(0).build();
        RegionInfo splitB = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(Bytes.toBytes((String)"a")).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId + 1L).setReplicaId(0).build();
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{parent});
            MetaTableAccessor.addRegionsToMeta((Connection)connection, (List)regionInfos, (int)3);
            MetaTableAccessor.splitRegion((Connection)connection, (RegionInfo)parent, (long)-1L, (RegionInfo)splitA, (RegionInfo)splitB, (ServerName)serverName0, (int)3);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitA.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitA.getRegionName(), 2);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitB.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, splitB.getRegionName(), 2);
        }
    }

    @Test
    public void testMetaLocationForRegionReplicasIsAddedAtRegionMerge() throws IOException {
        long regionId = System.currentTimeMillis();
        ServerName serverName0 = ServerName.valueOf((String)"foo", (int)60010, (long)this.random.nextLong());
        RegionInfo parentA = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(Bytes.toBytes((String)"a")).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo parentB = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(Bytes.toBytes((String)"a")).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo merged = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId + 1L).setReplicaId(0).build();
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{parentA, parentB});
            MetaTableAccessor.addRegionsToMeta((Connection)connection, (List)regionInfos, (int)3);
            MetaTableAccessor.mergeRegions((Connection)connection, (RegionInfo)merged, this.getMapOfRegionsToSeqNum(parentA, parentB), (ServerName)serverName0, (int)3);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, merged.getRegionName(), 1);
            TestMetaTableAccessor.assertEmptyMetaLocation(meta, merged.getRegionName(), 2);
        }
    }

    private Map<RegionInfo, Long> getMapOfRegionsToSeqNum(RegionInfo ... regions) {
        HashMap<RegionInfo, Long> mids = new HashMap<RegionInfo, Long>(regions.length);
        for (RegionInfo region : regions) {
            mids.put(region, -1L);
        }
        return mids;
    }

    @Test
    public void testMetaScanner() throws Exception {
        LOG.info("Starting " + this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"region_a"), Bytes.toBytes((String)"region_b")};
        UTIL.createTable(tableName, FAMILY, (byte[][])SPLIT_KEYS);
        Table table = connection.getTable(tableName);
        UTIL.countRows(table);
        MetaTableAccessor.Visitor visitor = (MetaTableAccessor.Visitor)Mockito.mock(MetaTableAccessor.Visitor.class);
        ((MetaTableAccessor.Visitor)Mockito.doReturn((Object)true).when((Object)visitor)).visit((Result)ArgumentMatchers.anyObject());
        MetaTableAccessor.scanMetaForTableRegions((Connection)connection, (MetaTableAccessor.Visitor)visitor, (TableName)tableName);
        ((MetaTableAccessor.Visitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)3))).visit((Result)ArgumentMatchers.anyObject());
        Mockito.reset((Object[])new MetaTableAccessor.Visitor[]{visitor});
        ((MetaTableAccessor.Visitor)Mockito.doReturn((Object)true).when((Object)visitor)).visit((Result)ArgumentMatchers.anyObject());
        MetaTableAccessor.scanMeta((Connection)connection, (MetaTableAccessor.Visitor)visitor, (TableName)tableName, null, (int)1000);
        ((MetaTableAccessor.Visitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)3))).visit((Result)ArgumentMatchers.anyObject());
        Mockito.reset((Object[])new MetaTableAccessor.Visitor[]{visitor});
        ((MetaTableAccessor.Visitor)Mockito.doReturn((Object)true).when((Object)visitor)).visit((Result)ArgumentMatchers.anyObject());
        MetaTableAccessor.scanMeta((Connection)connection, (MetaTableAccessor.Visitor)visitor, (TableName)tableName, (byte[])Bytes.toBytes((String)"region_ac"), (int)1000);
        ((MetaTableAccessor.Visitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)2))).visit((Result)ArgumentMatchers.anyObject());
        Mockito.reset((Object[])new MetaTableAccessor.Visitor[]{visitor});
        ((MetaTableAccessor.Visitor)Mockito.doReturn((Object)true).when((Object)visitor)).visit((Result)ArgumentMatchers.anyObject());
        MetaTableAccessor.scanMeta((Connection)connection, (MetaTableAccessor.Visitor)visitor, (TableName)tableName, (byte[])Bytes.toBytes((String)"region_ac"), (int)1);
        ((MetaTableAccessor.Visitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)1))).visit((Result)ArgumentMatchers.anyObject());
        table.close();
    }

    @Test
    public void testMastersSystemTimeIsUsedInUpdateLocations() throws IOException {
        long regionId = System.currentTimeMillis();
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        ServerName sn = ServerName.valueOf((String)"bar", (int)0, (long)0L);
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{regionInfo});
            MetaTableAccessor.addRegionsToMeta((Connection)connection, (List)regionInfos, (int)1);
            long masterSystemTime = EnvironmentEdgeManager.currentTime() + 123456789L;
            MetaTableAccessor.updateRegionLocation((Connection)connection, (RegionInfo)regionInfo, (ServerName)sn, (long)1L, (long)masterSystemTime);
            Get get = new Get(regionInfo.getRegionName());
            Result result = meta.get(get);
            Cell serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)0));
            Cell startCodeCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)0));
            Cell seqNumCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn((int)0));
            Assert.assertNotNull((Object)serverCell);
            Assert.assertNotNull((Object)startCodeCell);
            Assert.assertNotNull((Object)seqNumCell);
            Assert.assertTrue((serverCell.getValueLength() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((startCodeCell.getValueLength() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((seqNumCell.getValueLength() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)masterSystemTime, (long)serverCell.getTimestamp());
            Assert.assertEquals((long)masterSystemTime, (long)startCodeCell.getTimestamp());
            Assert.assertEquals((long)masterSystemTime, (long)seqNumCell.getTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMastersSystemTimeIsUsedInMergeRegions() throws IOException {
        long regionId = System.currentTimeMillis();
        RegionInfo regionInfoA = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(new byte[]{97}).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo regionInfoB = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(new byte[]{97}).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo mergedRegionInfo = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        ServerName sn = ServerName.valueOf((String)"bar", (int)0, (long)0L);
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{regionInfoA, regionInfoB});
            MetaTableAccessor.addRegionsToMeta((Connection)connection, (List)regionInfos, (int)1);
            long serverNameTime = EnvironmentEdgeManager.currentTime() + 100000000L;
            long masterSystemTime = EnvironmentEdgeManager.currentTime() + 123456789L;
            MetaTableAccessor.updateRegionLocation((Connection)connection, (RegionInfo)regionInfoA, (ServerName)sn, (long)1L, (long)serverNameTime);
            Get get = new Get(mergedRegionInfo.getRegionName());
            Result result = meta.get(get);
            Cell serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)0));
            Assert.assertNotNull((Object)serverCell);
            Assert.assertEquals((long)serverNameTime, (long)serverCell.getTimestamp());
            ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
            edge.setValue(masterSystemTime);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
            try {
                MetaTableAccessor.mergeRegions((Connection)connection, (RegionInfo)mergedRegionInfo, this.getMapOfRegionsToSeqNum(regionInfoA, regionInfoB), (ServerName)sn, (int)1);
            }
            finally {
                EnvironmentEdgeManager.reset();
            }
            result = meta.get(get);
            serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)0));
            Cell startCodeCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)0));
            Cell seqNumCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn((int)0));
            Assert.assertNull((Object)serverCell);
            Assert.assertNull((Object)startCodeCell);
            Assert.assertNull((Object)seqNumCell);
        }
    }

    @Test
    public void testMetaUpdatesGoToPriorityQueue() throws Exception {
        Configuration c = UTIL.getConfiguration();
        c.set("hbase.region.server.rpc.scheduler.factory.class", SpyingRpcSchedulerFactory.class.getName());
        TestMetaTableAccessor.afterClass();
        TestMetaTableAccessor.beforeClass();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Admin admin = connection.getAdmin();
             RegionLocator rl = connection.getRegionLocator(tableName);){
            UTIL.createTable(tableName, "cf1");
            HRegionLocation loc = (HRegionLocation)rl.getAllRegionLocations().get(0);
            HRegionInfo parent = loc.getRegionInfo();
            long rid = 1000L;
            byte[] splitKey = Bytes.toBytes((String)"a");
            RegionInfo splitA = RegionInfoBuilder.newBuilder((TableName)parent.getTable()).setStartKey(parent.getStartKey()).setEndKey(splitKey).setSplit(false).setRegionId(rid).build();
            RegionInfo splitB = RegionInfoBuilder.newBuilder((TableName)parent.getTable()).setStartKey(splitKey).setEndKey(parent.getEndKey()).setSplit(false).setRegionId(rid).build();
            MiniHBaseCluster cluster = UTIL.getMiniHBaseCluster();
            int rsIndex = cluster.getServerWithMeta();
            Object rs = rsIndex >= 0 ? cluster.getRegionServer(rsIndex) : cluster.getMaster();
            SpyingRpcScheduler scheduler = (SpyingRpcScheduler)rs.getRpcServer().getScheduler();
            long prevCalls = scheduler.numPriorityCalls;
            MetaTableAccessor.splitRegion((Connection)connection, (RegionInfo)parent, (long)-1L, (RegionInfo)splitA, (RegionInfo)splitB, (ServerName)loc.getServerName(), (int)1);
            Assert.assertTrue((prevCalls < scheduler.numPriorityCalls ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyMetaDaughterLocationDuringSplit() throws IOException {
        long regionId = System.currentTimeMillis();
        ServerName serverName0 = ServerName.valueOf((String)"foo", (int)60010, (long)this.random.nextLong());
        RegionInfo parent = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"table_foo")).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        RegionInfo splitA = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"table_foo")).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(Bytes.toBytes((String)"a")).setSplit(false).setRegionId(regionId + 1L).setReplicaId(0).build();
        RegionInfo splitB = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"table_foo")).setStartKey(Bytes.toBytes((String)"a")).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId + 1L).setReplicaId(0).build();
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)connection);){
            ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{parent});
            MetaTableAccessor.addRegionsToMeta((Connection)connection, (List)regionInfos, (int)3);
            MetaTableAccessor.splitRegion((Connection)connection, (RegionInfo)parent, (long)-1L, (RegionInfo)splitA, (RegionInfo)splitB, (ServerName)serverName0, (int)3);
            Get get1 = new Get(splitA.getRegionName());
            Result resultA = meta.get(get1);
            Cell serverCellA = resultA.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)splitA.getReplicaId()));
            Cell startCodeCellA = resultA.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)splitA.getReplicaId()));
            Assert.assertNull((Object)serverCellA);
            Assert.assertNull((Object)startCodeCellA);
            Get get2 = new Get(splitA.getRegionName());
            Result resultB = meta.get(get2);
            Cell serverCellB = resultB.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)splitB.getReplicaId()));
            Cell startCodeCellB = resultB.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)splitB.getReplicaId()));
            Assert.assertNull((Object)serverCellB);
            Assert.assertNull((Object)startCodeCellB);
        }
    }

    @Test
    public void testScanByRegionEncodedNameExistingRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)"testScanByRegionEncodedNameExistingRegion");
        UTIL.createTable(tableName, "cf");
        List<HRegion> regions = UTIL.getHBaseCluster().getRegions(tableName);
        String encodedName = regions.get(0).getRegionInfo().getEncodedName();
        Result result = MetaTableAccessor.scanByRegionEncodedName((Connection)UTIL.getConnection(), (String)encodedName);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.advance());
        String resultingRowKey = CellUtil.getCellKeyAsString((Cell)result.current());
        Assert.assertTrue((boolean)resultingRowKey.contains(encodedName));
        UTIL.deleteTable(tableName);
    }

    @Test
    public void testScanByRegionEncodedNameNonExistingRegion() throws Exception {
        String encodedName = "nonexistingregion";
        Result result = MetaTableAccessor.scanByRegionEncodedName((Connection)UTIL.getConnection(), (String)"nonexistingregion");
        Assert.assertNull((Object)result);
    }

    public static class SpyingRpcScheduler
    extends DelegatingRpcScheduler {
        long numPriorityCalls = 0L;

        public SpyingRpcScheduler(RpcScheduler delegate) {
            super(delegate);
        }

        @Override
        public boolean dispatch(CallRunner task) throws IOException, InterruptedException {
            int priority = task.getRpcCall().getPriority();
            if (priority > 10) {
                ++this.numPriorityCalls;
            }
            return super.dispatch(task);
        }
    }

    public static class SpyingRpcSchedulerFactory
    extends SimpleRpcSchedulerFactory {
        public RpcScheduler create(Configuration conf, PriorityFunction priority, Abortable server) {
            RpcScheduler delegate = super.create(conf, priority, server);
            return new SpyingRpcScheduler(delegate);
        }
    }

    static abstract class MetaTask
    extends Thread {
        boolean stop = false;
        int count = 0;
        Throwable t = null;
        final Connection connection;

        MetaTask(Connection connection, String name) {
            super(name);
            this.connection = connection;
        }

        @Override
        public void run() {
            try {
                while (!this.stop) {
                    LOG.info("Before " + this.getName() + ", count=" + this.count);
                    this.metaTask();
                    ++this.count;
                    LOG.info("After " + this.getName() + ", count=" + this.count);
                    Thread.sleep(100L);
                }
            }
            catch (Throwable t) {
                LOG.info(this.getName() + " failed", t);
                this.t = t;
            }
        }

        boolean isProgressing() throws InterruptedException {
            int currentCount = this.count;
            while (currentCount == this.count) {
                if (!this.isAlive()) {
                    return false;
                }
                if (this.t != null) {
                    return false;
                }
                Thread.sleep(10L);
            }
            return true;
        }

        @Override
        public String toString() {
            return "count=" + this.count + ", t=" + (this.t == null ? "null" : this.t.toString());
        }

        abstract void metaTask() throws Throwable;
    }
}

