/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRpcServerTraceLogging {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcServerTraceLogging.class);
    static Logger rpcServerLog = Logger.getLogger(RpcServer.class);
    static final String TRACE_LOG_MSG = "This is dummy message for testing:: region { type: REGION_NAME value: \"hbase:meta,,1\" } scan { column { family: \"info\" } time_range { from: 0 to: 9223372036854775807 } max_versions: 1 cache_blocks: true max_result_size: 2097152 caching: 2147483647 } number_of_rows: 2147483647 close_scanner: false client_handles_partials: true client_handles_heartbeats: true track_scan_metrics: false";
    static final int TRACE_LOG_LENGTH = "This is dummy message for testing:: region { type: REGION_NAME value: \"hbase:meta,,1\" } scan { column { family: \"info\" } time_range { from: 0 to: 9223372036854775807 } max_versions: 1 cache_blocks: true max_result_size: 2097152 caching: 2147483647 } number_of_rows: 2147483647 close_scanner: false client_handles_partials: true client_handles_heartbeats: true track_scan_metrics: false".length();
    static final RpcServer mockRpcServer = (RpcServer)Mockito.mock(RpcServer.class);
    static final Configuration conf = new Configuration(false);

    @BeforeClass
    public static void setUp() {
        Mockito.when((Object)mockRpcServer.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)mockRpcServer.truncateTraceLog((String)Mockito.any(String.class))).thenCallRealMethod();
    }

    @Test
    public void testLoggingWithTraceOff() {
        conf.setInt("hbase.ipc.trace.log.max.length", 250);
        rpcServerLog.setLevel(Level.DEBUG);
        String truncatedString = mockRpcServer.truncateTraceLog(TRACE_LOG_MSG);
        Assert.assertEquals((long)(150 + " <TRUNCATED>".length()), (long)truncatedString.length());
        Assert.assertTrue((boolean)truncatedString.contains(" <TRUNCATED>"));
    }

    @Test
    public void testLoggingWithTraceOn() {
        conf.setInt("hbase.ipc.trace.log.max.length", 250);
        rpcServerLog.setLevel(Level.TRACE);
        String truncatedString = mockRpcServer.truncateTraceLog(TRACE_LOG_MSG);
        Assert.assertEquals((long)(250 + " <TRUNCATED>".length()), (long)truncatedString.length());
        Assert.assertTrue((boolean)truncatedString.contains(" <TRUNCATED>"));
    }

    @Test
    public void testLoggingWithTraceOnLargeMax() {
        conf.setInt("hbase.ipc.trace.log.max.length", 2000);
        rpcServerLog.setLevel(Level.TRACE);
        String truncatedString = mockRpcServer.truncateTraceLog(TRACE_LOG_MSG);
        Assert.assertEquals((long)TRACE_LOG_LENGTH, (long)truncatedString.length());
        Assert.assertFalse((boolean)mockRpcServer.truncateTraceLog(TRACE_LOG_MSG).contains(" <TRUNCATED>"));
    }
}

