/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, LargeTests.class})
public class TestCatalogJanitorCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCatalogJanitorCluster.class);
    @Rule
    public final TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName T1 = TableName.valueOf((String)"t1");
    private static final TableName T2 = TableName.valueOf((String)"t2");
    private static final TableName T3 = TableName.valueOf((String)"t3");

    @Before
    public void before() throws Exception {
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.createMultiRegionTable(T1, new byte[][]{HConstants.CATALOG_FAMILY});
        TEST_UTIL.createMultiRegionTable(T2, new byte[][]{HConstants.CATALOG_FAMILY});
        TEST_UTIL.createMultiRegionTable(T3, new byte[][]{HConstants.CATALOG_FAMILY});
    }

    @After
    public void after() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testConsistency() throws IOException {
        CatalogJanitor janitor = TEST_UTIL.getHBaseCluster().getMaster().getCatalogJanitor();
        int gc = janitor.scan();
        CatalogJanitor.Report report = janitor.getLastReport();
        Assert.assertTrue((boolean)report.isEmpty());
        List t2Ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)T2);
        MetaTableAccessor.deleteRegionInfo((Connection)TEST_UTIL.getConnection(), (RegionInfo)((RegionInfo)t2Ris.get(0)));
        gc = janitor.scan();
        report = janitor.getLastReport();
        Assert.assertFalse((boolean)report.isEmpty());
        Assert.assertEquals((long)1L, (long)report.getHoles().size());
        Assert.assertTrue((boolean)((RegionInfo)((Pair)report.getHoles().get(0)).getFirst()).getTable().equals((Object)T1));
        Assert.assertTrue((boolean)((RegionInfo)((Pair)report.getHoles().get(0)).getFirst()).isLast());
        Assert.assertTrue((boolean)((RegionInfo)((Pair)report.getHoles().get(0)).getSecond()).getTable().equals((Object)T2));
        Assert.assertEquals((long)0L, (long)report.getOverlaps().size());
        List t3Ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)T3);
        RegionInfo ri = (RegionInfo)t3Ris.get(0);
        RegionInfo newRi1 = RegionInfoBuilder.newBuilder((TableName)ri.getTable()).setStartKey(TestCatalogJanitorCluster.incrementRow(ri.getStartKey())).setEndKey(TestCatalogJanitorCluster.incrementRow(ri.getEndKey())).build();
        Put p1 = MetaTableAccessor.makePutFromRegionInfo((RegionInfo)newRi1, (long)System.currentTimeMillis());
        RegionInfo newRi2 = RegionInfoBuilder.newBuilder((TableName)newRi1.getTable()).setStartKey(TestCatalogJanitorCluster.incrementRow(newRi1.getStartKey())).setEndKey(TestCatalogJanitorCluster.incrementRow(newRi1.getEndKey())).build();
        Put p2 = MetaTableAccessor.makePutFromRegionInfo((RegionInfo)newRi2, (long)System.currentTimeMillis());
        MetaTableAccessor.putsToMetaTable((Connection)TEST_UTIL.getConnection(), Arrays.asList(p1, p2));
        gc = janitor.scan();
        report = janitor.getLastReport();
        Assert.assertFalse((boolean)report.isEmpty());
        Assert.assertEquals((long)3L, (long)report.getOverlaps().size());
        Assert.assertEquals((long)1L, (long)report.getHoles().size());
        Assert.assertTrue((boolean)report.getEmptyRegionInfo().isEmpty());
        Assert.assertTrue((boolean)report.getUnknownServers().isEmpty());
        List t1Ris = MetaTableAccessor.getTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)T1);
        RegionInfo t1Ri1 = (RegionInfo)t1Ris.get(1);
        Put pServer = new Put(t1Ri1.getRegionName());
        pServer.addColumn(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getServerColumn((int)0), Bytes.toBytes((String)"bad.server.example.org:1234"));
        MetaTableAccessor.putsToMetaTable((Connection)TEST_UTIL.getConnection(), Arrays.asList(pServer));
        gc = janitor.scan();
        report = janitor.getLastReport();
        Assert.assertFalse((boolean)report.isEmpty());
        RegionInfo t1Ri2 = (RegionInfo)t1Ris.get(2);
        Put pEmptyRI = new Put(t1Ri2.getRegionName());
        pEmptyRI.addColumn(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getRegionInfoColumn(), HConstants.EMPTY_BYTE_ARRAY);
        MetaTableAccessor.putsToMetaTable((Connection)TEST_UTIL.getConnection(), Arrays.asList(pEmptyRI));
        gc = janitor.scan();
        report = janitor.getLastReport();
        Assert.assertEquals((long)1L, (long)report.getEmptyRegionInfo().size());
    }

    private static byte[] incrementRow(byte[] row) {
        if (row.length == 0) {
            return new byte[]{48};
        }
        row[row.length - 1] = (byte)(row[row.length - 1] + 1);
        return row;
    }
}

