/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.favored.FavoredNodeLoadBalancer;
import org.apache.hadoop.hbase.favored.FavoredNodesPlan;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.balancer.LoadBalancerFactory;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRegionPlacement2 {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionPlacement2.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionPlacement2.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int SLAVES = 7;
    private static final int PRIMARY = FavoredNodesPlan.Position.PRIMARY.ordinal();
    private static final int SECONDARY = FavoredNodesPlan.Position.SECONDARY.ordinal();
    private static final int TERTIARY = FavoredNodesPlan.Position.TERTIARY.ordinal();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setClass("hbase.master.loadbalancer.class", FavoredNodeLoadBalancer.class, LoadBalancer.class);
        conf.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        TEST_UTIL.startMiniCluster(7);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFavoredNodesPresentForRoundRobinAssignment() throws HBaseIOException {
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)TEST_UTIL.getConfiguration());
        balancer.setMasterServices((MasterServices)TEST_UTIL.getMiniHBaseCluster().getMaster());
        balancer.initialize();
        ArrayList<ServerName> servers = new ArrayList<ServerName>();
        for (int i = 0; i < 7; ++i) {
            ServerName server = TEST_UTIL.getMiniHBaseCluster().getRegionServer(i).getServerName();
            servers.add(server);
        }
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(1);
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        regions.add(region);
        Map assignmentMap = balancer.roundRobinAssignment(regions, servers);
        Set<ServerName> serverBefore = assignmentMap.keySet();
        List favoredNodesBefore = ((FavoredNodeLoadBalancer)balancer).getFavoredNodes(region);
        Assert.assertTrue((favoredNodesBefore.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ServerName.isSameAddress((ServerName)((ServerName)serverBefore.iterator().next()), (ServerName)((ServerName)favoredNodesBefore.get(PRIMARY))));
        List<ServerName> removedServers = this.removeMatchingServers(serverBefore, servers);
        assignmentMap = balancer.roundRobinAssignment(regions, servers);
        List favoredNodesAfter = ((FavoredNodeLoadBalancer)balancer).getFavoredNodes(region);
        Assert.assertTrue((favoredNodesAfter.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)favoredNodesAfter.containsAll(favoredNodesBefore));
        Set serverAfter = assignmentMap.keySet();
        Assert.assertTrue((ServerName.isSameAddress((ServerName)((ServerName)serverAfter.iterator().next()), (ServerName)((ServerName)favoredNodesBefore.get(SECONDARY))) || ServerName.isSameAddress((ServerName)((ServerName)serverAfter.iterator().next()), (ServerName)((ServerName)favoredNodesBefore.get(TERTIARY))) ? 1 : 0) != 0);
        servers.addAll(removedServers);
        assignmentMap = balancer.roundRobinAssignment(regions, servers);
        Set serverWithPrimary = assignmentMap.keySet();
        Assert.assertTrue((boolean)serverBefore.containsAll(serverWithPrimary));
        this.removeMatchingServers(favoredNodesAfter, servers);
        assignmentMap = balancer.roundRobinAssignment(regions, servers);
        List favoredNodesNow = ((FavoredNodeLoadBalancer)balancer).getFavoredNodes(region);
        Assert.assertTrue((favoredNodesNow.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((!favoredNodesNow.contains(favoredNodesAfter.get(PRIMARY)) && !favoredNodesNow.contains(favoredNodesAfter.get(SECONDARY)) && !favoredNodesNow.contains(favoredNodesAfter.get(TERTIARY)) ? 1 : 0) != 0);
    }

    @Test
    public void testFavoredNodesPresentForRandomAssignment() throws HBaseIOException {
        LoadBalancer balancer = LoadBalancerFactory.getLoadBalancer((Configuration)TEST_UTIL.getConfiguration());
        balancer.setMasterServices((MasterServices)TEST_UTIL.getMiniHBaseCluster().getMaster());
        balancer.initialize();
        ArrayList<ServerName> servers = new ArrayList<ServerName>();
        for (int i = 0; i < 7; ++i) {
            ServerName server = TEST_UTIL.getMiniHBaseCluster().getRegionServer(i).getServerName();
            servers.add(server);
        }
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(1);
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        regions.add(region);
        ServerName serverBefore = balancer.randomAssignment(region, servers);
        List favoredNodesBefore = ((FavoredNodeLoadBalancer)balancer).getFavoredNodes(region);
        Assert.assertTrue((favoredNodesBefore.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ServerName.isSameAddress((ServerName)serverBefore, (ServerName)((ServerName)favoredNodesBefore.get(PRIMARY))));
        this.removeMatchingServers(serverBefore, servers);
        ServerName serverAfter = balancer.randomAssignment(region, servers);
        List favoredNodesAfter = ((FavoredNodeLoadBalancer)balancer).getFavoredNodes(region);
        Assert.assertTrue((favoredNodesAfter.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)favoredNodesAfter.containsAll(favoredNodesBefore));
        Assert.assertTrue((ServerName.isSameAddress((ServerName)serverAfter, (ServerName)((ServerName)favoredNodesBefore.get(SECONDARY))) || ServerName.isSameAddress((ServerName)serverAfter, (ServerName)((ServerName)favoredNodesBefore.get(TERTIARY))) ? 1 : 0) != 0);
        this.removeMatchingServers(favoredNodesAfter, servers);
        balancer.randomAssignment(region, servers);
        List favoredNodesNow = ((FavoredNodeLoadBalancer)balancer).getFavoredNodes(region);
        Assert.assertTrue((favoredNodesNow.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((!favoredNodesNow.contains(favoredNodesAfter.get(PRIMARY)) && !favoredNodesNow.contains(favoredNodesAfter.get(SECONDARY)) && !favoredNodesNow.contains(favoredNodesAfter.get(TERTIARY)) ? 1 : 0) != 0);
    }

    private List<ServerName> removeMatchingServers(Collection<ServerName> serversWithoutStartCode, List<ServerName> servers) {
        ArrayList<ServerName> serversToRemove = new ArrayList<ServerName>();
        for (ServerName s : serversWithoutStartCode) {
            serversToRemove.addAll(this.removeMatchingServers(s, servers));
        }
        return serversToRemove;
    }

    private List<ServerName> removeMatchingServers(ServerName serverWithoutStartCode, List<ServerName> servers) {
        ArrayList<ServerName> serversToRemove = new ArrayList<ServerName>();
        for (ServerName s : servers) {
            if (!ServerName.isSameAddress((ServerName)s, (ServerName)serverWithoutStartCode)) continue;
            serversToRemove.add(s);
        }
        servers.removeAll(serversToRemove);
        return serversToRemove;
    }
}

