/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.assignment.MockMasterServices;
import org.apache.hadoop.hbase.master.assignment.TestAssignmentManagerBase;
import org.apache.hadoop.hbase.master.assignment.UnassignProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestAssignmentManager
extends TestAssignmentManagerBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestAssignmentManager.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAssignmentManager.class);

    @Test(expected=NullPointerException.class)
    public void testWaitServerReportEventWithNullServer() throws UnexpectedStateException {
        if (this.am.waitServerReportEvent(null, null)) {
            throw new UnexpectedStateException();
        }
    }

    @Test
    public void testAssignWithGoodExec() throws Exception {
        this.collectAssignmentManagerMetrics();
        this.testAssign(new TestAssignmentManagerBase.GoodRsExecutor());
        Assert.assertEquals((long)(this.assignSubmittedCount + 1000L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testAssignAndCrashBeforeResponse() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAssignAndCrashBeforeResponse");
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.HangThenRSCrashExecutor());
        AssignProcedure proc = this.am.createAssignProcedure(hri);
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)proc));
    }

    @Test
    public void testUnassignAndCrashBeforeResponse() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAssignAndCrashBeforeResponse");
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.HangOnCloseThenRSCrashExecutor());
        for (int i = 0; i < 6; ++i) {
            AssignProcedure assign = this.am.createAssignProcedure(hri);
            this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)assign));
            UnassignProcedure unassign = this.am.createUnassignProcedure(hri, this.am.getRegionStates().getRegionServerOfRegion(hri), false);
            this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)unassign));
        }
    }

    @Test
    public void testAssignWithRandExec() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAssignWithRandExec");
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.RandRsExecutor());
        for (int i = 0; i < 10; ++i) {
            LOG.info("ROUND=" + i);
            AssignProcedure proc = this.am.createAssignProcedure(hri);
            this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)proc));
        }
    }

    @Ignore
    @Test
    public void testSocketTimeout() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.collectAssignmentManagerMetrics();
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.SocketTimeoutRsExecutor(20, 3));
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createAssignProcedure(hri)));
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.SocketTimeoutRsExecutor(20, 1));
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createUnassignProcedure(hri, null, false)));
        Assert.assertEquals((long)(this.assignSubmittedCount + 1L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
        Assert.assertEquals((long)(this.unassignSubmittedCount + 1L), (long)this.unassignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)(this.unassignFailedCount + 1L), (long)this.unassignProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testServerNotYetRunning() throws Exception {
        this.testRetriesExhaustedFailure(TableName.valueOf((String)this.name.getMethodName()), new TestAssignmentManagerBase.ServerNotYetRunningRsExecutor());
    }

    private void testRetriesExhaustedFailure(TableName tableName, TestAssignmentManagerBase.MockRSExecutor executor) throws Exception {
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.collectAssignmentManagerMetrics();
        this.rsDispatcher.setMockRsExecutor(executor);
        try {
            this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createAssignProcedure(hri)));
            Assert.fail((String)"unexpected assign completion");
        }
        catch (RetriesExhaustedException e) {
            LOG.info("expected exception from assign operation: " + e.getMessage(), (Throwable)e);
        }
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.GoodRsExecutor());
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createAssignProcedure(hri)));
    }

    @Test
    public void testIOExceptionOnAssignment() throws Exception {
        this.collectAssignmentManagerMetrics();
        this.testFailedOpen(TableName.valueOf((String)"testExceptionOnAssignment"), new TestAssignmentManagerBase.FaultyRsExecutor(new IOException("test fault")));
        Assert.assertEquals((long)(this.assignSubmittedCount + 1L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)(this.assignFailedCount + 1L), (long)this.assignProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testDoNotRetryExceptionOnAssignment() throws Exception {
        this.collectAssignmentManagerMetrics();
        this.testFailedOpen(TableName.valueOf((String)"testDoNotRetryExceptionOnAssignment"), new TestAssignmentManagerBase.FaultyRsExecutor((IOException)((Object)new DoNotRetryIOException("test do not retry fault"))));
        Assert.assertEquals((long)(this.assignSubmittedCount + 1L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)(this.assignFailedCount + 1L), (long)this.assignProcMetrics.getFailedCounter().getCount());
    }

    private void testFailedOpen(TableName tableName, TestAssignmentManagerBase.MockRSExecutor executor) throws Exception {
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.rsDispatcher.setMockRsExecutor(executor);
        try {
            this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createAssignProcedure(hri)));
            Assert.fail((String)"unexpected assign completion");
        }
        catch (RetriesExhaustedException e) {
            LOG.info("REGION STATE " + this.am.getRegionStates().getRegionStateNode(hri));
            LOG.info("expected exception from assign operation: " + e.getMessage(), (Throwable)e);
            Assert.assertEquals((Object)true, (Object)this.am.getRegionStates().getRegionState(hri).isFailedOpen());
        }
    }

    private void testAssign(TestAssignmentManagerBase.MockRSExecutor executor) throws Exception {
        this.testAssign(executor, 1000);
    }

    private void testAssign(TestAssignmentManagerBase.MockRSExecutor executor, int nregions) throws Exception {
        this.rsDispatcher.setMockRsExecutor(executor);
        AssignProcedure[] assignments = new AssignProcedure[nregions];
        long st = System.currentTimeMillis();
        this.bulkSubmit(assignments);
        for (int i = 0; i < assignments.length; ++i) {
            ProcedureTestingUtility.waitProcedure(this.master.getMasterProcedureExecutor(), (Procedure)assignments[i]);
            Assert.assertTrue((String)assignments[i].toString(), (boolean)assignments[i].isSuccess());
        }
        long et = System.currentTimeMillis();
        float sec = (float)(et - st) / 1000.0f;
        LOG.info(String.format("[T] Assigning %dprocs in %s (%.2fproc/sec)", assignments.length, StringUtils.humanTimeDiff((long)(et - st)), Float.valueOf((float)assignments.length / sec)));
    }

    @Test
    public void testAssignAnAssignedRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAssignAnAssignedRegion");
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.collectAssignmentManagerMetrics();
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.GoodRsExecutor());
        Future<byte[]> futureA = this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createAssignProcedure(hri));
        this.waitOnFuture(futureA);
        this.am.getRegionStates().isRegionInState(hri, new RegionState.State[]{RegionState.State.OPEN});
        Future<byte[]> futureB = this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createAssignProcedure(hri));
        this.waitOnFuture(futureB);
        this.am.getRegionStates().isRegionInState(hri, new RegionState.State[]{RegionState.State.OPEN});
        Assert.assertEquals((long)(this.assignSubmittedCount + 2L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testUnassignAnUnassignedRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)"testUnassignAnUnassignedRegion");
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.collectAssignmentManagerMetrics();
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.GoodRsExecutor());
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createAssignProcedure(hri)));
        Future<byte[]> futureA = this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createUnassignProcedure(hri, null, false));
        this.waitOnFuture(futureA);
        this.am.getRegionStates().isRegionInState(hri, new RegionState.State[]{RegionState.State.CLOSED});
        Future<byte[]> futureB = this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createUnassignProcedure(hri, ServerName.valueOf((String)"example.org,1234,1"), false));
        this.waitOnFuture(futureB);
        this.am.getRegionStates().isRegionInState(hri, new RegionState.State[]{RegionState.State.CLOSED});
        Assert.assertEquals((long)(this.assignSubmittedCount + 1L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
        Assert.assertEquals((long)(this.unassignSubmittedCount + 2L), (long)this.unassignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.unassignFailedCount, (long)this.unassignProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testAssignMetaAndCrashBeforeResponse() throws Exception {
        this.tearDown();
        this.UTIL = new HBaseTestingUtility();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.setupConfiguration(this.UTIL.getConfiguration());
        this.master = new MockMasterServices(this.UTIL.getConfiguration(), this.regionsToRegionServers);
        this.rsDispatcher = new TestAssignmentManagerBase.MockRSProcedureDispatcher(this.master);
        this.master.start(NSERVERS, this.rsDispatcher);
        this.am = this.master.getAssignmentManager();
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.HangThenRSRestartExecutor());
        this.am.assign(RegionInfoBuilder.FIRST_META_REGIONINFO);
        Assert.assertEquals((Object)true, (Object)this.am.isMetaAssigned());
        this.am.wakeMetaLoadedEvent();
    }

    @Test
    public void testAssignQueueFullOnce() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.collectAssignmentManagerMetrics();
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.CallQueueTooBigOnceRsExecutor());
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createAssignProcedure(hri)));
        Assert.assertEquals((long)(this.assignSubmittedCount + 1L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testTimeoutThenQueueFull() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        this.collectAssignmentManagerMetrics();
        this.rsDispatcher.setMockRsExecutor((TestAssignmentManagerBase)this.new TestAssignmentManagerBase.TimeoutThenCallQueueTooBigRsExecutor(10));
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createAssignProcedure(hri)));
        this.rsDispatcher.setMockRsExecutor((TestAssignmentManagerBase)this.new TestAssignmentManagerBase.TimeoutThenCallQueueTooBigRsExecutor(15));
        this.waitOnFuture(this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createUnassignProcedure(hri)));
        Assert.assertEquals((long)(this.assignSubmittedCount + 1L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
        Assert.assertEquals((long)(this.unassignSubmittedCount + 1L), (long)this.unassignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.unassignFailedCount, (long)this.unassignProcMetrics.getFailedCounter().getCount());
    }
}

