/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.HbckChore;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.assignment.TestAssignmentManagerBase;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestHbckChore
extends TestAssignmentManagerBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestHbckChore.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHbckChore.class);
    private HbckChore hbckChore;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.hbckChore = new HbckChore((MasterServices)this.master);
    }

    @Test
    public void testForMeta() throws Exception {
        byte[] metaRegionNameAsBytes = RegionInfoBuilder.FIRST_META_REGIONINFO.getRegionName();
        String metaRegionName = RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedName();
        List serverNames = this.master.getServerManager().getOnlineServersList();
        Assert.assertEquals((long)NSERVERS, (long)serverNames.size());
        this.hbckChore.choreForTesting();
        Map inconsistentRegions = this.hbckChore.getInconsistentRegions();
        Assert.assertTrue((boolean)inconsistentRegions.containsKey(metaRegionName));
        Pair pair = (Pair)inconsistentRegions.get(metaRegionName);
        ServerName locationInMeta = (ServerName)pair.getFirst();
        List reportedRegionServers = (List)pair.getSecond();
        Assert.assertTrue((boolean)serverNames.contains(locationInMeta));
        Assert.assertEquals((long)0L, (long)reportedRegionServers.size());
        this.am.reportOnlineRegions(locationInMeta, Collections.singleton(metaRegionNameAsBytes));
        this.hbckChore.choreForTesting();
        inconsistentRegions = this.hbckChore.getInconsistentRegions();
        Assert.assertFalse((boolean)inconsistentRegions.containsKey(metaRegionName));
    }

    @Test
    public void testForUserTable() throws Exception {
        TableName tableName = TableName.valueOf((String)"testForUserTable");
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        String regionName = hri.getEncodedName();
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.GoodRsExecutor());
        Future<byte[]> future = this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createAssignProcedure(hri));
        this.waitOnFuture(future);
        List serverNames = this.master.getServerManager().getOnlineServersList();
        Assert.assertEquals((long)NSERVERS, (long)serverNames.size());
        this.hbckChore.choreForTesting();
        Map inconsistentRegions = this.hbckChore.getInconsistentRegions();
        Assert.assertTrue((boolean)inconsistentRegions.containsKey(regionName));
        Pair pair = (Pair)inconsistentRegions.get(regionName);
        ServerName locationInMeta = (ServerName)pair.getFirst();
        List reportedRegionServers = (List)pair.getSecond();
        Assert.assertTrue((boolean)serverNames.contains(locationInMeta));
        Assert.assertEquals((long)0L, (long)reportedRegionServers.size());
        ServerName tempLocationInMeta = locationInMeta;
        ServerName anotherServer = serverNames.stream().filter(s -> !s.equals((Object)tempLocationInMeta)).findFirst().get();
        this.am.reportOnlineRegions(anotherServer, Collections.singleton(hri.getRegionName()));
        this.hbckChore.choreForTesting();
        inconsistentRegions = this.hbckChore.getInconsistentRegions();
        Assert.assertTrue((boolean)inconsistentRegions.containsKey(regionName));
        pair = (Pair)inconsistentRegions.get(regionName);
        locationInMeta = (ServerName)pair.getFirst();
        reportedRegionServers = (List)pair.getSecond();
        Assert.assertEquals((long)1L, (long)reportedRegionServers.size());
        Assert.assertFalse((boolean)reportedRegionServers.contains(locationInMeta));
        Assert.assertTrue((boolean)reportedRegionServers.contains(anotherServer));
        this.am.reportOnlineRegions(locationInMeta, Collections.singleton(hri.getRegionName()));
        this.hbckChore.choreForTesting();
        inconsistentRegions = this.hbckChore.getInconsistentRegions();
        Assert.assertTrue((boolean)inconsistentRegions.containsKey(regionName));
        pair = (Pair)inconsistentRegions.get(regionName);
        locationInMeta = (ServerName)pair.getFirst();
        reportedRegionServers = (List)pair.getSecond();
        Assert.assertEquals((long)2L, (long)reportedRegionServers.size());
        Assert.assertTrue((boolean)reportedRegionServers.contains(locationInMeta));
        Assert.assertTrue((boolean)reportedRegionServers.contains(anotherServer));
        this.am.reportOnlineRegions(anotherServer, Collections.EMPTY_SET);
        this.hbckChore.choreForTesting();
        inconsistentRegions = this.hbckChore.getInconsistentRegions();
        Assert.assertFalse((boolean)inconsistentRegions.containsKey(regionName));
    }

    @Test
    public void testForDisabledTable() throws Exception {
        TableName tableName = TableName.valueOf((String)"testForDisabledTable");
        RegionInfo hri = this.createRegionInfo(tableName, 1L);
        String regionName = hri.getEncodedName();
        this.rsDispatcher.setMockRsExecutor(new TestAssignmentManagerBase.GoodRsExecutor());
        Future<byte[]> future = this.submitProcedure((Procedure<MasterProcedureEnv>)this.am.createAssignProcedure(hri));
        this.waitOnFuture(future);
        List serverNames = this.master.getServerManager().getOnlineServersList();
        Assert.assertEquals((long)NSERVERS, (long)serverNames.size());
        this.hbckChore.choreForTesting();
        Map inconsistentRegions = this.hbckChore.getInconsistentRegions();
        Assert.assertTrue((boolean)inconsistentRegions.containsKey(regionName));
        Pair pair = (Pair)inconsistentRegions.get(regionName);
        ServerName locationInMeta = (ServerName)pair.getFirst();
        List reportedRegionServers = (List)pair.getSecond();
        Assert.assertTrue((boolean)serverNames.contains(locationInMeta));
        Assert.assertEquals((long)0L, (long)reportedRegionServers.size());
        TableStateManager tableStateManager = this.master.getTableStateManager();
        Mockito.when((Object)tableStateManager.isTableState(tableName, new TableState.State[]{TableState.State.DISABLED})).thenReturn((Object)true);
        this.hbckChore.choreForTesting();
        inconsistentRegions = this.hbckChore.getInconsistentRegions();
        Assert.assertFalse((boolean)inconsistentRegions.containsKey(regionName));
    }

    @Test
    public void testOrphanRegionsOnFS() throws Exception {
        TableName tableName = TableName.valueOf((String)"testOrphanRegionsOnFS");
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        Configuration conf = this.UTIL.getConfiguration();
        this.hbckChore.choreForTesting();
        Assert.assertEquals((long)0L, (long)this.hbckChore.getOrphanRegionsOnFS().size());
        HRegion.createRegionDir((Configuration)conf, (RegionInfo)regionInfo, (Path)FSUtils.getRootDir((Configuration)conf));
        this.hbckChore.choreForTesting();
        Assert.assertEquals((long)1L, (long)this.hbckChore.getOrphanRegionsOnFS().size());
        Assert.assertTrue((boolean)this.hbckChore.getOrphanRegionsOnFS().containsKey(regionInfo.getEncodedName()));
        FSUtils.deleteRegionDir((Configuration)conf, (HRegionInfo)new HRegionInfo(regionInfo));
        this.hbckChore.choreForTesting();
        Assert.assertEquals((long)0L, (long)this.hbckChore.getOrphanRegionsOnFS().size());
    }

    @Test
    public void testChoreDisable() {
        long lastRunTime = this.hbckChore.getCheckingEndTimestamp();
        this.hbckChore.choreForTesting();
        boolean ran = lastRunTime != this.hbckChore.getCheckingEndTimestamp();
        Assert.assertTrue((boolean)ran);
        this.master.getConfiguration().setInt("hbase.master.hbck.chore.interval", 0);
        HbckChore hbckChoreWithChangedConf = new HbckChore((MasterServices)this.master);
        lastRunTime = hbckChoreWithChangedConf.getCheckingEndTimestamp();
        hbckChoreWithChangedConf.choreForTesting();
        ran = lastRunTime != hbckChoreWithChangedConf.getCheckingEndTimestamp();
        Assert.assertFalse((boolean)ran);
    }
}

