/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.assignment.MoveRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestMoveSystemTableWithStopMaster {
    private static final Logger LOG = LoggerFactory.getLogger(TestMoveSystemTableWithStopMaster.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMoveSystemTableWithStopMaster.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1, 2);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMoveMetaRegoinWithStopMaster() throws Exception {
        ClusterConnection conn = (ClusterConnection)UTIL.getConnection();
        MiniHBaseCluster miniHBaseCluster = UTIL.getHBaseCluster();
        List namespaceRegionLocations = conn.locateRegions(TableName.META_TABLE_NAME);
        RegionInfo regionInfo = ((HRegionLocation)namespaceRegionLocations.get(0)).getRegion();
        ServerName source = ((HRegionLocation)namespaceRegionLocations.get(0)).getServerName();
        ServerName dstServerName = UTIL.getOtherRegionServer(miniHBaseCluster.getRegionServer(source)).getServerName();
        RegionPlan rp = new RegionPlan(regionInfo, source, dstServerName);
        HMaster master = UTIL.getHBaseCluster().getMaster();
        CountDownLatch moveRegionAssignLatch = new CountDownLatch(1);
        CountDownLatch masterAbortLatch = new CountDownLatch(1);
        MoveRegionProcedureHoldBeforeAssign proc = new MoveRegionProcedureHoldBeforeAssign((MasterProcedureEnv)master.getMasterProcedureExecutor().getEnvironment(), rp, true);
        proc.moveRegionAssignLatch = moveRegionAssignLatch;
        proc.masterStoppedLatch = masterAbortLatch;
        ProcedureSyncWait.submitProcedure((ProcedureExecutor)master.getMasterProcedureExecutor(), (Procedure)proc);
        moveRegionAssignLatch.await();
        master.abort("for test");
        master.getEventLoopGroupConfig().group().shutdownGracefully();
        miniHBaseCluster.waitForMasterToStop(master.getServerName(), 30000L);
        masterAbortLatch.countDown();
        UTIL.getMiniHBaseCluster().startMaster();
        Assert.assertTrue((boolean)miniHBaseCluster.waitForActiveAndReadyMaster(60000L));
    }

    @Test
    public void testMoveNamespaceRegoinWithStopMaster() throws Exception {
        ClusterConnection conn = (ClusterConnection)UTIL.getConnection();
        MiniHBaseCluster miniHBaseCluster = UTIL.getHBaseCluster();
        List namespaceRegionLocations = conn.locateRegions(TableName.NAMESPACE_TABLE_NAME);
        RegionInfo regionInfo = ((HRegionLocation)namespaceRegionLocations.get(0)).getRegion();
        ServerName source = ((HRegionLocation)namespaceRegionLocations.get(0)).getServerName();
        ServerName dstServerName = UTIL.getOtherRegionServer(miniHBaseCluster.getRegionServer(source)).getServerName();
        RegionPlan rp = new RegionPlan(regionInfo, source, dstServerName);
        HMaster master = UTIL.getHBaseCluster().getMaster();
        CountDownLatch moveRegionAssignLatch = new CountDownLatch(1);
        CountDownLatch masterAbortLatch = new CountDownLatch(1);
        MoveRegionProcedureHoldBeforeAssign proc = new MoveRegionProcedureHoldBeforeAssign((MasterProcedureEnv)master.getMasterProcedureExecutor().getEnvironment(), rp, true);
        proc.moveRegionAssignLatch = moveRegionAssignLatch;
        proc.masterStoppedLatch = masterAbortLatch;
        ProcedureSyncWait.submitProcedure((ProcedureExecutor)master.getMasterProcedureExecutor(), (Procedure)proc);
        moveRegionAssignLatch.await();
        master.abort("for test");
        miniHBaseCluster.waitForMasterToStop(master.getServerName(), 30000L);
        masterAbortLatch.countDown();
        UTIL.getMiniHBaseCluster().startMaster();
        Assert.assertTrue((boolean)miniHBaseCluster.waitForActiveAndReadyMaster(60000L));
    }

    public static class MoveRegionProcedureHoldBeforeAssign
    extends MoveRegionProcedure {
        CountDownLatch masterStoppedLatch;
        CountDownLatch moveRegionAssignLatch;

        public MoveRegionProcedureHoldBeforeAssign() {
        }

        public MoveRegionProcedureHoldBeforeAssign(MasterProcedureEnv env, RegionPlan plan, boolean check) throws HBaseIOException {
            super(env, plan, check);
        }

        protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.MoveRegionState state) throws InterruptedException {
            if (state == MasterProcedureProtos.MoveRegionState.MOVE_REGION_ASSIGN && this.moveRegionAssignLatch != null) {
                this.moveRegionAssignLatch.countDown();
                this.masterStoppedLatch.await();
            }
            return super.executeFromState(env, state);
        }
    }
}

