/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestUrgentProcedureWorker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestUrgentProcedureWorker.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestUrgentProcedureWorker.class);
    private static final int PROCEDURE_EXECUTOR_SLOTS = 1;
    private static final CountDownLatch metaFinished = new CountDownLatch(1);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"TestUrgentProcedureWorker");
    private static WALProcedureStore procStore;
    private static ProcedureExecutor<TestEnv> procExec;

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        UTIL.cleanupTestDir();
    }

    @BeforeClass
    public static void setUp() throws IOException {
        UTIL.getConfiguration().setInt("hbase.procedure.worker.stuck.threshold.msec", 6000000);
        procStore = ProcedureTestingUtility.createWalStore((Configuration)UTIL.getConfiguration(), (Path)UTIL.getDataTestDir("TestUrgentProcedureWorker"));
        procStore.start(1);
        MasterProcedureScheduler scheduler = new MasterProcedureScheduler(pid -> null);
        procExec = new ProcedureExecutor(UTIL.getConfiguration(), (Object)new TestEnv(scheduler), (ProcedureStore)procStore, (ProcedureScheduler)scheduler);
        procExec.init(1, 1, false);
        procExec.startWorkers();
    }

    @Test
    public void test() throws Exception {
        WaitingMetaProcedure waitingMetaProcedure = new WaitingMetaProcedure();
        long waitProc = procExec.submitProcedure((Procedure)waitingMetaProcedure);
        MetaProcedure metaProcedure = new MetaProcedure();
        long metaProc = procExec.submitProcedure((Procedure)metaProcedure);
        UTIL.waitFor(5000L, () -> procExec.isFinished(waitProc));
    }

    public static class MetaProcedure
    extends ProcedureTestingUtility.NoopProcedure<TestEnv>
    implements TableProcedureInterface {
        protected Procedure<TestEnv>[] execute(TestEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            metaFinished.countDown();
            return null;
        }

        protected Procedure.LockState acquireLock(TestEnv env) {
            if (env.getScheduler().waitTableExclusiveLock((Procedure)this, this.getTableName())) {
                return Procedure.LockState.LOCK_EVENT_WAIT;
            }
            return Procedure.LockState.LOCK_ACQUIRED;
        }

        protected void releaseLock(TestEnv env) {
            env.getScheduler().wakeTableExclusiveLock((Procedure)this, this.getTableName());
        }

        protected boolean holdLock(TestEnv env) {
            return true;
        }

        public TableName getTableName() {
            return TableName.META_TABLE_NAME;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return TableProcedureInterface.TableOperationType.EDIT;
        }
    }

    public static class WaitingMetaProcedure
    extends ProcedureTestingUtility.NoopProcedure<TestEnv>
    implements TableProcedureInterface {
        protected Procedure<TestEnv>[] execute(TestEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            metaFinished.await();
            return null;
        }

        protected Procedure.LockState acquireLock(TestEnv env) {
            if (env.getScheduler().waitTableExclusiveLock((Procedure)this, this.getTableName())) {
                return Procedure.LockState.LOCK_EVENT_WAIT;
            }
            return Procedure.LockState.LOCK_ACQUIRED;
        }

        protected void releaseLock(TestEnv env) {
            env.getScheduler().wakeTableExclusiveLock((Procedure)this, this.getTableName());
        }

        protected boolean holdLock(TestEnv env) {
            return true;
        }

        public TableName getTableName() {
            return TABLE_NAME;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return TableProcedureInterface.TableOperationType.EDIT;
        }
    }

    private static final class TestEnv {
        private final MasterProcedureScheduler scheduler;

        public TestEnv(MasterProcedureScheduler scheduler) {
            this.scheduler = scheduler;
        }

        public MasterProcedureScheduler getScheduler() {
            return this.scheduler;
        }
    }
}

