/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestSpaceQuotaDropTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSpaceQuotaDropTable.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSpaceQuotaDropTable.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName testName = new TestName();
    private SpaceQuotaHelperForTests helper;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, new AtomicLong(0L));
        this.helper.removeAllQuotas();
    }

    @Test
    public void testSetQuotaAndThenDropTableWithNoInserts() throws Exception {
        this.setQuotaAndThenDropTable(SpaceViolationPolicy.NO_INSERTS);
    }

    @Test
    public void testSetQuotaAndThenDropTableWithNoWrite() throws Exception {
        this.setQuotaAndThenDropTable(SpaceViolationPolicy.NO_WRITES);
    }

    @Test
    public void testSetQuotaAndThenDropTableWithNoWritesCompactions() throws Exception {
        this.setQuotaAndThenDropTable(SpaceViolationPolicy.NO_WRITES_COMPACTIONS);
    }

    @Test
    public void testSetQuotaAndThenDropTableWithDisable() throws Exception {
        this.setQuotaAndThenDropTable(SpaceViolationPolicy.DISABLE);
    }

    private void setQuotaAndThenDropTable(SpaceViolationPolicy policy) throws Exception {
        Put put = new Put(Bytes.toBytes((String)"to_reject"));
        put.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn = this.helper.writeUntilViolationAndVerifyViolation(policy, (Mutation)put);
        TEST_UTIL.deleteTable(tn);
        LOG.debug("Successfully deleted table ", (Object)tn);
        TEST_UTIL.createTable(tn, Bytes.toBytes((String)"f1"));
        LOG.debug("Successfully re-created table ", (Object)tn);
        this.helper.verifyNoViolation(tn, (Mutation)put);
    }
}

