/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestSpaceQuotaRemoval {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSpaceQuotaRemoval.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName testName = new TestName();
    private SpaceQuotaHelperForTests helper;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, new AtomicLong(0L));
        this.helper.removeAllQuotas();
    }

    @Test
    public void testSetQuotaAndThenRemoveInOneWithNoInserts() throws Exception {
        this.setQuotaAndThenRemoveInOneAmongTwoTables(SpaceViolationPolicy.NO_INSERTS);
    }

    @Test
    public void testSetQuotaAndThenRemoveInOneWithNoWrite() throws Exception {
        this.setQuotaAndThenRemoveInOneAmongTwoTables(SpaceViolationPolicy.NO_WRITES);
    }

    @Test
    public void testSetQuotaAndThenRemoveInOneWithNoWritesCompaction() throws Exception {
        this.setQuotaAndThenRemoveInOneAmongTwoTables(SpaceViolationPolicy.NO_WRITES_COMPACTIONS);
    }

    @Test
    public void testSetQuotaAndThenRemoveInOneWithDisable() throws Exception {
        this.setQuotaAndThenRemoveInOneAmongTwoTables(SpaceViolationPolicy.DISABLE);
    }

    @Test
    public void testSetQuotaAndThenRemoveWithNoInserts() throws Exception {
        this.setQuotaAndThenRemove(SpaceViolationPolicy.NO_INSERTS);
    }

    @Test
    public void testSetQuotaAndThenRemoveWithNoWrite() throws Exception {
        this.setQuotaAndThenRemove(SpaceViolationPolicy.NO_WRITES);
    }

    @Test
    public void testSetQuotaAndThenRemoveWithNoWritesCompactions() throws Exception {
        this.setQuotaAndThenRemove(SpaceViolationPolicy.NO_WRITES_COMPACTIONS);
    }

    @Test
    public void testSetQuotaAndThenRemoveWithDisable() throws Exception {
        this.setQuotaAndThenRemove(SpaceViolationPolicy.DISABLE);
    }

    @Test
    public void testSetQuotaAndThenDisableIncrEnableWithNoInserts() throws Exception {
        this.setQuotaNextDisableThenIncreaseFinallyEnable(SpaceViolationPolicy.NO_INSERTS);
    }

    @Test
    public void testSetQuotaAndThenDisableIncrEnableWithNoWrite() throws Exception {
        this.setQuotaNextDisableThenIncreaseFinallyEnable(SpaceViolationPolicy.NO_WRITES);
    }

    @Test
    public void testSetQuotaAndThenDisableIncrEnableWithNoWritesCompaction() throws Exception {
        this.setQuotaNextDisableThenIncreaseFinallyEnable(SpaceViolationPolicy.NO_WRITES_COMPACTIONS);
    }

    @Test
    public void testSetQuotaAndThenDisableIncrEnableWithDisable() throws Exception {
        this.setQuotaNextDisableThenIncreaseFinallyEnable(SpaceViolationPolicy.DISABLE);
    }

    private void setQuotaAndThenRemove(SpaceViolationPolicy policy) throws Exception {
        Put put = new Put(Bytes.toBytes((String)"to_reject"));
        put.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn = this.helper.writeUntilViolationAndVerifyViolation(policy, (Mutation)put);
        this.helper.removeQuotaFromtable(tn);
        this.helper.verifyNoViolation(tn, (Mutation)put);
    }

    private void setQuotaAndThenRemoveInOneAmongTwoTables(SpaceViolationPolicy policy) throws Exception {
        Put put = new Put(Bytes.toBytes((String)"to_reject"));
        put.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn1 = this.helper.writeUntilViolationAndVerifyViolation(policy, (Mutation)put);
        TableName tn2 = this.helper.writeUntilViolationAndVerifyViolation(policy, (Mutation)put);
        this.helper.removeQuotaFromtable(tn1);
        this.helper.verifyNoViolation(tn1, (Mutation)put);
        this.helper.verifyViolation(policy, tn2, (Mutation)put);
    }

    private void setQuotaNextDisableThenIncreaseFinallyEnable(SpaceViolationPolicy policy) throws Exception {
        Put put = new Put(Bytes.toBytes((String)"to_reject"));
        put.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn = this.helper.writeUntilViolationAndVerifyViolation(policy, (Mutation)put);
        if (!policy.equals((Object)SpaceViolationPolicy.DISABLE)) {
            TEST_UTIL.getAdmin().disableTable(tn);
            TEST_UTIL.waitTableDisabled(tn, 10000L);
        }
        this.helper.setQuotaLimit(tn, policy, 4L);
        if (!policy.equals((Object)SpaceViolationPolicy.DISABLE)) {
            TEST_UTIL.getAdmin().enableTable(tn);
        }
        TEST_UTIL.waitTableEnabled(tn, 10000L);
        this.helper.verifyNoViolation(tn, (Mutation)put);
    }
}

