/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactorSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MemStoreMergerSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SegmentFactory;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMemStoreSegmentsIterator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMemStoreSegmentsIterator.class);
    protected static String TABLE = "test_mscsi";
    protected static String FAMILY = "f";
    protected static String COLUMN = "c";
    protected static String ROOT_SUB_PATH = "testMemStoreSegmentsIterator";
    protected static long LESS_THAN_INTEGER_MAX_VALUE_SEQ_ID = Long.valueOf(Integer.MAX_VALUE) - 1L;
    protected static long GREATER_THAN_INTEGER_MAX_VALUE_SEQ_ID = Long.valueOf(Integer.MAX_VALUE) + 1L;
    protected CellComparator comparator;
    protected int compactionKVMax;
    protected WAL wal;
    protected HRegion region;
    protected HStore store;

    @Before
    public void setup() throws IOException {
        Configuration conf = new Configuration();
        HBaseTestingUtility hbaseUtility = HBaseTestingUtility.createLocalHTU(conf);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)TABLE));
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(TableName.valueOf((String)TABLE), null, null, false);
        Path rootPath = hbaseUtility.getDataTestDir(ROOT_SUB_PATH);
        this.wal = HBaseTestingUtility.createWal(conf, rootPath, (RegionInfo)info);
        this.region = HRegion.createHRegion((RegionInfo)info, (Path)rootPath, (Configuration)conf, (TableDescriptor)htd, (WAL)this.wal, (boolean)true);
        this.store = new HStore(this.region, (ColumnFamilyDescriptor)hcd, conf);
        this.comparator = CellComparator.getInstance();
        this.compactionKVMax = 10;
    }

    @Test
    public void testMemStoreCompactorSegmentsIteratorNext() throws IOException {
        List<ImmutableSegment> segments = Arrays.asList(this.createTestImmutableSegment());
        MemStoreCompactorSegmentsIterator iterator = new MemStoreCompactorSegmentsIterator(segments, this.comparator, this.compactionKVMax, this.store);
        this.verifyNext((MemStoreSegmentsIterator)iterator);
        this.closeTestSegments(segments);
    }

    @Test
    public void testMemStoreMergerSegmentsIteratorNext() throws IOException {
        List<ImmutableSegment> segments = Arrays.asList(this.createTestImmutableSegment());
        MemStoreMergerSegmentsIterator iterator = new MemStoreMergerSegmentsIterator(segments, this.comparator, this.compactionKVMax);
        this.verifyNext((MemStoreSegmentsIterator)iterator);
        this.closeTestSegments(segments);
    }

    protected ImmutableSegment createTestImmutableSegment() {
        ImmutableSegment segment1 = SegmentFactory.instance().createImmutableSegment(this.comparator);
        byte[] one = Bytes.toBytes((int)1);
        byte[] two = Bytes.toBytes((int)2);
        byte[] f = Bytes.toBytes((String)FAMILY);
        byte[] q = Bytes.toBytes((String)COLUMN);
        byte[] v = Bytes.toBytes((int)3);
        KeyValue kv1 = new KeyValue(one, f, q, System.currentTimeMillis(), v);
        KeyValue kv2 = new KeyValue(two, f, q, System.currentTimeMillis(), v);
        kv1.setSequenceId(LESS_THAN_INTEGER_MAX_VALUE_SEQ_ID);
        kv2.setSequenceId(GREATER_THAN_INTEGER_MAX_VALUE_SEQ_ID);
        segment1.internalAdd((Cell)kv1, false, null);
        segment1.internalAdd((Cell)kv2, false, null);
        return segment1;
    }

    protected void closeTestSegments(List<ImmutableSegment> segments) {
        for (Segment segment : segments) {
            segment.close();
        }
    }

    protected void verifyNext(MemStoreSegmentsIterator iterator) {
        Assert.assertTrue((boolean)iterator.hasNext());
        Cell firstCell = (Cell)iterator.next();
        Assert.assertEquals((long)LESS_THAN_INTEGER_MAX_VALUE_SEQ_ID, (long)firstCell.getSequenceId());
        Assert.assertTrue((boolean)iterator.hasNext());
        Cell secondCell = (Cell)iterator.next();
        Assert.assertEquals((long)GREATER_THAN_INTEGER_MAX_VALUE_SEQ_ID, (long)secondCell.getSequenceId());
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
        if (this.store != null) {
            try {
                this.store.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.store = null;
        }
        if (this.region != null) {
            this.region.close();
            this.region = null;
        }
        if (this.wal != null) {
            this.wal.close();
            this.wal = null;
        }
    }
}

