/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.TestTableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContextImpl;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, LargeTests.class})
public class TestWithDisabledAuthorization
extends SecureTestUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWithDisabledAuthorization.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestWithDisabledAuthorization.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"f1");
    private static final byte[] TEST_FAMILY2 = Bytes.toBytes((String)"f2");
    private static final byte[] TEST_ROW = Bytes.toBytes((String)"testrow");
    private static final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
    private static final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
    private static final byte[] TEST_Q3 = Bytes.toBytes((String)"q3");
    private static final byte[] TEST_Q4 = Bytes.toBytes((String)"q4");
    private static final byte[] ZERO = Bytes.toBytes((long)0L);
    private static MasterCoprocessorEnvironment CP_ENV;
    private static AccessController ACCESS_CONTROLLER;
    private static RegionServerCoprocessorEnvironment RSCP_ENV;
    private RegionCoprocessorEnvironment RCP_ENV;
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();
    private static User SUPERUSER;
    private static User USER_ADMIN;
    private static User USER_RW;
    private static User USER_RO;
    private static User USER_OWNER;
    private static User USER_CREATE;
    private static User USER_NONE;
    private static User USER_QUAL;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 10);
        TestWithDisabledAuthorization.enableSecurity(conf);
        conf.setBoolean("hbase.security.access.early_out", false);
        conf.setBoolean("hbase.security.exec.permission.checks", true);
        TestWithDisabledAuthorization.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.authorization", false);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        ACCESS_CONTROLLER = (AccessController)cpHost.findCoprocessor(AccessController.class.getName());
        CP_ENV = cpHost.createEnvironment((MasterCoprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getRegionServerCoprocessorHost();
        RSCP_ENV = rsHost.createEnvironment((RegionServerCoprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        TEST_UTIL.waitUntilAllRegionsAssigned(AccessControlLists.ACL_TABLE_NAME);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER_ADMIN = User.createUserForTesting((Configuration)conf, (String)"admin2", (String[])new String[0]);
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_CREATE = User.createUserForTesting((Configuration)conf, (String)"tbl_create", (String[])new String[0]);
        USER_RW = User.createUserForTesting((Configuration)conf, (String)"rwuser", (String[])new String[0]);
        USER_RO = User.createUserForTesting((Configuration)conf, (String)"rouser", (String[])new String[0]);
        USER_QUAL = User.createUserForTesting((Configuration)conf, (String)"rwpartial", (String[])new String[0]);
        USER_NONE = User.createUserForTesting((Configuration)conf, (String)"nouser", (String[])new String[0]);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor htd = new HTableDescriptor(this.TEST_TABLE.getTableName());
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(100);
        htd.addFamily(hcd);
        htd.setOwner(USER_OWNER);
        admin.createTable((TableDescriptor)htd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        TEST_UTIL.waitUntilAllRegionsAssigned(this.TEST_TABLE.getTableName());
        HRegion region = TEST_UTIL.getHBaseCluster().getRegions(this.TEST_TABLE.getTableName()).get(0);
        RegionCoprocessorHost rcpHost = region.getCoprocessorHost();
        this.RCP_ENV = rcpHost.createEnvironment((RegionCoprocessor)ACCESS_CONTROLLER, 0, 1, TEST_UTIL.getConfiguration());
        TestWithDisabledAuthorization.grantGlobal(TEST_UTIL, USER_ADMIN.getShortName(), Permission.Action.ADMIN, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestWithDisabledAuthorization.grantOnTable(TEST_UTIL, USER_RW.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
        TestWithDisabledAuthorization.grantOnTable(TEST_UTIL, USER_CREATE.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestWithDisabledAuthorization.grantOnTable(TEST_UTIL, USER_RO.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
        TestWithDisabledAuthorization.grantOnTable(TEST_UTIL, USER_QUAL.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, Permission.Action.READ, Permission.Action.WRITE);
        Assert.assertEquals((long)5L, (long)AccessControlLists.getTablePermissions((Configuration)TEST_UTIL.getConfiguration(), (TableName)this.TEST_TABLE.getTableName()).size());
    }

    @After
    public void tearDown() throws Exception {
        try {
            TestWithDisabledAuthorization.deleteTable(TEST_UTIL, this.TEST_TABLE.getTableName());
        }
        catch (TableNotFoundException ex) {
            LOG.info("Test deleted table " + this.TEST_TABLE.getTableName());
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions((Configuration)TEST_UTIL.getConfiguration(), (TableName)this.TEST_TABLE.getTableName()).size());
        Assert.assertEquals((long)0L, (long)AccessControlLists.getNamespacePermissions((Configuration)TEST_UTIL.getConfiguration(), (String)this.TEST_TABLE.getTableName().getNamespaceAsString()).size());
    }

    @Test
    public void testCheckPermissions() throws Exception {
        SecureTestUtil.AccessTestAction checkGlobalAdmin = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkGlobalPerms(TEST_UTIL, Permission.Action.ADMIN);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkGlobalAdmin, SUPERUSER, USER_ADMIN);
        TestWithDisabledAuthorization.verifyDenied(checkGlobalAdmin, USER_OWNER, USER_CREATE, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkGlobalRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkGlobalPerms(TEST_UTIL, Permission.Action.READ);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkGlobalRead, SUPERUSER, USER_ADMIN);
        TestWithDisabledAuthorization.verifyDenied(checkGlobalRead, USER_OWNER, USER_CREATE, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkGlobalReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkGlobalPerms(TEST_UTIL, Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkGlobalReadWrite, SUPERUSER, USER_ADMIN);
        TestWithDisabledAuthorization.verifyDenied(checkGlobalReadWrite, USER_OWNER, USER_CREATE, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkTableAdmin = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), null, null, Permission.Action.ADMIN);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkTableAdmin, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestWithDisabledAuthorization.verifyDenied(checkTableAdmin, USER_CREATE, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkTableCreate = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), null, null, Permission.Action.CREATE);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkTableCreate, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE);
        TestWithDisabledAuthorization.verifyDenied(checkTableCreate, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkTableRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), null, null, Permission.Action.READ);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkTableRead, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE);
        TestWithDisabledAuthorization.verifyDenied(checkTableRead, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkTableReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), null, null, Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkTableReadWrite, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE);
        TestWithDisabledAuthorization.verifyDenied(checkTableReadWrite, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkColumnRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkColumnRead, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_RO);
        TestWithDisabledAuthorization.verifyDenied(checkColumnRead, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkColumnReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkColumnReadWrite, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW);
        TestWithDisabledAuthorization.verifyDenied(checkColumnReadWrite, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkQualifierRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, Permission.Action.READ);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkQualifierRead, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_RO, USER_QUAL);
        TestWithDisabledAuthorization.verifyDenied(checkQualifierRead, USER_NONE);
        SecureTestUtil.AccessTestAction checkQualifierReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkQualifierReadWrite, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_QUAL);
        TestWithDisabledAuthorization.verifyDenied(checkQualifierReadWrite, USER_RO, USER_NONE);
        SecureTestUtil.AccessTestAction checkMultiQualifierRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), new Permission[]{new TablePermission(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, new Permission.Action[]{Permission.Action.READ}), new TablePermission(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q2, new Permission.Action[]{Permission.Action.READ})});
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkMultiQualifierRead, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_RO);
        TestWithDisabledAuthorization.verifyDenied(checkMultiQualifierRead, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkMultiQualifierReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), new Permission[]{new TablePermission(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}), new TablePermission(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q2, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE})});
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkMultiQualifierReadWrite, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW);
        TestWithDisabledAuthorization.verifyDenied(checkMultiQualifierReadWrite, USER_RO, USER_QUAL, USER_NONE);
    }

    @Test
    public void testPassiveGrantRevoke() throws Exception {
        User tblUser = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"tbluser", (String[])new String[0]);
        SecureTestUtil.AccessTestAction checkTableRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyDenied(tblUser, checkTableRead);
        SecureTestUtil.AccessTestAction tableRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
                     Table t = conn.getTable(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());){
                    t.get(new Get(TEST_ROW).addFamily(TEST_FAMILY));
                }
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(tblUser, tableRead);
        TestWithDisabledAuthorization.grantOnTable(TEST_UTIL, tblUser.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
        TestWithDisabledAuthorization.verifyAllowed(tblUser, checkTableRead);
        TestWithDisabledAuthorization.verifyAllowed(tblUser, tableRead);
        TestWithDisabledAuthorization.revokeFromTable(TEST_UTIL, tblUser.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
        TestWithDisabledAuthorization.verifyDenied(tblUser, checkTableRead);
        TestWithDisabledAuthorization.verifyAllowed(tblUser, tableRead);
    }

    @Test
    public void testPassiveMasterOperations() throws Exception {
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                ACCESS_CONTROLLER.preCreateTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (TableDescriptor)htd, null);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY2));
                ACCESS_CONTROLLER.preModifyTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), (TableDescriptor)htd);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preTruncateTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preEnableTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDisableTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HRegionInfo region = new HRegionInfo(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ServerName srcServer = ServerName.valueOf((String)"1.1.1.1", (int)1, (long)0L);
                ServerName destServer = ServerName.valueOf((String)"2.2.2.2", (int)2, (long)0L);
                ACCESS_CONTROLLER.preMove(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (RegionInfo)region, srcServer, destServer);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HRegionInfo region = new HRegionInfo(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ACCESS_CONTROLLER.preAssign(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (RegionInfo)region);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HRegionInfo region = new HRegionInfo(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ACCESS_CONTROLLER.preUnassign(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (RegionInfo)region, true);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBalance(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBalanceSwitch(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), true);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                SnapshotDescription snapshot = new SnapshotDescription("foo");
                HTableDescriptor htd = new HTableDescriptor(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ACCESS_CONTROLLER.preSnapshot(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), snapshot, (TableDescriptor)htd);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                SnapshotDescription snapshot = new SnapshotDescription("foo");
                ACCESS_CONTROLLER.preListSnapshot(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), snapshot);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                SnapshotDescription snapshot = new SnapshotDescription("foo");
                HTableDescriptor htd = new HTableDescriptor(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ACCESS_CONTROLLER.preCloneSnapshot(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), snapshot, (TableDescriptor)htd);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                SnapshotDescription snapshot = new SnapshotDescription("foo");
                HTableDescriptor htd = new HTableDescriptor(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ACCESS_CONTROLLER.preRestoreSnapshot(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), snapshot, (TableDescriptor)htd);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                SnapshotDescription snapshot = new SnapshotDescription("foo");
                ACCESS_CONTROLLER.preDeleteSnapshot(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), snapshot);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ArrayList tableNamesList = Lists.newArrayList();
                tableNamesList.add(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ArrayList descriptors = Lists.newArrayList();
                ACCESS_CONTROLLER.preGetTableDescriptors(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (List)tableNamesList, (List)descriptors, ".+");
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ArrayList descriptors = Lists.newArrayList();
                ACCESS_CONTROLLER.preGetTableNames(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (List)descriptors, ".+");
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                NamespaceDescriptor ns = NamespaceDescriptor.create((String)"test").build();
                ACCESS_CONTROLLER.preCreateNamespace(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), ns);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteNamespace(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), "test");
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                NamespaceDescriptor ns = NamespaceDescriptor.create((String)"test").build();
                ACCESS_CONTROLLER.preModifyNamespace(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), ns);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preGetNamespaceDescriptor(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), "test");
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ArrayList descriptors = Lists.newArrayList();
                ACCESS_CONTROLLER.preListNamespaceDescriptors(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (List)descriptors);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSplitRegion(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), Bytes.toBytes((String)"ss"));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetUserQuota(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), "testuser", null);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetTableQuota(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), null);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetNamespaceQuota(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), "test", null);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
    }

    @Test
    public void testPassiveRegionServerOperations() throws Exception {
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preStopRegionServer(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)RSCP_ENV));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRollWALWriterRequest(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)RSCP_ENV));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
    }

    @Test
    public void testPassiveRegionOperations() throws Exception {
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preOpen(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preFlush(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV), FlushLifeCycleTracker.DUMMY);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ArrayList cells = Lists.newArrayList();
                ACCESS_CONTROLLER.preGetOp(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV), new Get(TEST_ROW), (List)cells);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preExists(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV), new Get(TEST_ROW), true);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.prePut(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV), new Put(TEST_ROW), new WALEdit(), Durability.USE_DEFAULT);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDelete(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV), new Delete(TEST_ROW), new WALEdit(), Durability.USE_DEFAULT);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBatchMutate(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV), new MiniBatchOperationInProgress(null, null, null, 0, 0, 0));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCheckAndPut(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV), TEST_ROW, TEST_FAMILY, TEST_Q1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator("foo".getBytes()), new Put(TEST_ROW), true);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCheckAndDelete(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV), TEST_ROW, TEST_FAMILY, TEST_Q1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator("foo".getBytes()), new Delete(TEST_ROW), true);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preAppend(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV), new Append(TEST_ROW));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preIncrement(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV), new Increment(TEST_ROW));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preScannerOpen(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV), new Scan());
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ArrayList paths = Lists.newArrayList();
                ACCESS_CONTROLLER.preBulkLoadHFile(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV), (List)paths);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
    }

    @Test
    public void testPassiveCellPermissions() throws Exception {
        final Configuration conf = TEST_UTIL.getConfiguration();
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q1, ZERO);
                    p.setACL(USER_NONE.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                    p = new Put(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q2, ZERO);
                    p.setACL(USER_NONE.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW).addColumn(TEST_FAMILY, TEST_Q3, ZERO).addColumn(TEST_FAMILY, TEST_Q4, ZERO);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        final ArrayList scanResults = Lists.newArrayList();
        SecureTestUtil.AccessTestAction scanAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Cell> run() throws Exception {
                Scan scan = new Scan();
                scan.setStartRow(TEST_ROW);
                scan.setStopRow(Bytes.add((byte[])TEST_ROW, (byte[])new byte[]{0}));
                scan.addFamily(TEST_FAMILY);
                Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                Table t = connection.getTable(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                try {
                    ResultScanner scanner = t.getScanner(scan);
                    Result result = null;
                    do {
                        if ((result = scanner.next()) == null) continue;
                        scanResults.addAll(result.listCells());
                    } while (result != null);
                }
                finally {
                    t.close();
                    connection.close();
                }
                return scanResults;
            }
        };
        scanResults.clear();
        TestWithDisabledAuthorization.verifyAllowed(scanAction, USER_OWNER);
        Assert.assertEquals((long)4L, (long)scanResults.size());
        scanResults.clear();
        TestWithDisabledAuthorization.verifyAllowed(scanAction, USER_NONE);
        Assert.assertEquals((long)4L, (long)scanResults.size());
    }
}

