/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DeadServer {
    private static final Logger LOG = LoggerFactory.getLogger(DeadServer.class);
    private final Map<ServerName, Long> deadServers = new HashMap<ServerName, Long>();
    private final Set<ServerName> processingServers = new HashSet<ServerName>();
    private static Comparator<Pair<ServerName, Long>> ServerNameDeathDateComparator = new Comparator<Pair<ServerName, Long>>(){

        @Override
        public int compare(Pair<ServerName, Long> o1, Pair<ServerName, Long> o2) {
            return ((Long)o1.getSecond()).compareTo((Long)o2.getSecond());
        }
    };

    public synchronized boolean cleanPreviousInstance(ServerName newServerName) {
        Iterator<ServerName> it = this.deadServers.keySet().iterator();
        while (it.hasNext()) {
            ServerName sn = it.next();
            if (!ServerName.isSameAddress((ServerName)sn, (ServerName)newServerName)) continue;
            it.remove();
            boolean removed = this.processingServers.remove(sn);
            if (removed) {
                LOG.debug("Removed " + sn + " ; numProcessing=" + this.processingServers.size());
            }
            return true;
        }
        return false;
    }

    public synchronized boolean isDeadServer(ServerName serverName) {
        return this.deadServers.containsKey(serverName);
    }

    public synchronized boolean isProcessingServer(ServerName serverName) {
        return this.processingServers.contains(serverName);
    }

    public synchronized boolean areDeadServersInProgress() {
        return !this.processingServers.isEmpty();
    }

    public synchronized Set<ServerName> copyServerNames() {
        HashSet<ServerName> clone = new HashSet<ServerName>(this.deadServers.size());
        clone.addAll(this.deadServers.keySet());
        return clone;
    }

    public synchronized void add(ServerName sn) {
        this.add(sn, true);
    }

    public synchronized void add(ServerName sn, boolean processing) {
        if (!this.deadServers.containsKey(sn)) {
            this.deadServers.put(sn, EnvironmentEdgeManager.currentTime());
        }
        if (processing && this.processingServers.add(sn)) {
            LOG.debug("Added {}; numProcessing={}", (Object)sn, (Object)this.processingServers.size());
        }
    }

    public synchronized void notifyServer(ServerName sn) {
        boolean added = this.processingServers.add(sn);
        if (LOG.isDebugEnabled()) {
            if (added) {
                LOG.debug("Added " + sn + "; numProcessing=" + this.processingServers.size());
            }
            LOG.debug("Started processing " + sn + "; numProcessing=" + this.processingServers.size());
        }
    }

    public synchronized void finish(ServerName sn) {
        boolean removed = this.processingServers.remove(sn);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished processing " + sn + "; numProcessing=" + this.processingServers.size());
            if (removed) {
                LOG.debug("Removed " + sn + " ; numProcessing=" + this.processingServers.size());
            }
        }
    }

    public synchronized int size() {
        return this.deadServers.size();
    }

    public synchronized boolean isEmpty() {
        return this.deadServers.isEmpty();
    }

    public synchronized void cleanAllPreviousInstances(ServerName newServerName) {
        Iterator<ServerName> it = this.deadServers.keySet().iterator();
        while (it.hasNext()) {
            ServerName sn = it.next();
            if (!ServerName.isSameAddress((ServerName)sn, (ServerName)newServerName)) continue;
            it.remove();
            boolean removed = this.processingServers.remove(sn);
            if (!removed) continue;
            LOG.debug("Removed " + sn + " ; numProcessing=" + this.processingServers.size());
        }
    }

    public synchronized String toString() {
        HashSet<ServerName> servers = new HashSet<ServerName>();
        servers.addAll(this.deadServers.keySet());
        servers.addAll(this.processingServers);
        StringBuilder sb = new StringBuilder();
        for (ServerName sn : servers) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(sn.toString());
            if (!this.processingServers.contains(sn)) continue;
            sb.append("*");
        }
        return sb.toString();
    }

    public synchronized List<Pair<ServerName, Long>> copyDeadServersSince(long ts) {
        ArrayList<Pair<ServerName, Long>> res = new ArrayList<Pair<ServerName, Long>>(this.size());
        for (Map.Entry<ServerName, Long> entry : this.deadServers.entrySet()) {
            if (entry.getValue() < ts) continue;
            res.add((Pair<ServerName, Long>)new Pair((Object)entry.getKey(), (Object)entry.getValue()));
        }
        Collections.sort(res, ServerNameDeathDateComparator);
        return res;
    }

    public synchronized Date getTimeOfDeath(ServerName deadServerName) {
        Long time = this.deadServers.get(deadServerName);
        return time == null ? null : new Date(time);
    }

    public synchronized boolean removeDeadServer(ServerName deadServerName) {
        Preconditions.checkState((!this.processingServers.contains(deadServerName) ? 1 : 0) != 0, (Object)("Asked to remove server still in processingServers set " + deadServerName + " (numProcessing=" + this.processingServers.size() + ")"));
        return this.deadServers.remove(deadServerName) != null;
    }
}

