/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetricsAssignmentManagerSource;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestAssignmentManagerMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAssignmentManagerMetrics.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestAssignmentManagerMetrics.class);
    private static final MetricsAssertHelper METRICS_HELPER = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private static MiniHBaseCluster CLUSTER;
    private static HMaster MASTER;
    private static HBaseTestingUtility TEST_UTIL;
    private static final int MSG_INTERVAL = 1000;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void startCluster() throws Exception {
        LOG.info("Starting cluster");
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.table.sanity.checks", false);
        conf.setInt("hbase.metrics.rit.stuck.warning.threshold", 20);
        conf.setInt("hbase.regionserver.msginterval", 1000);
        conf.set("hbase.balancer.tablesOnMaster", "none");
        conf.setInt("hbase.client.sync.wait.timeout.msec", 30000);
        conf.setInt("hbase.client.retries.number", 1);
        conf.setInt("hbase.client.operation.timeout", 2500);
        conf.setInt("hbase.assignment.rit.chore.interval.msec", 1000);
        conf.setInt("hbase.assignment.maximum.attempts", 3);
        conf.setBoolean("hbase.coprocessor.abortonerror", false);
        TEST_UTIL.startMiniCluster(1);
        CLUSTER = TEST_UTIL.getHBaseCluster();
        MASTER = CLUSTER.getMaster();
    }

    @AfterClass
    public static void after() throws Exception {
        LOG.info("AFTER {} <= IS THIS NULL?", (Object)TEST_UTIL);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRITAssignmentManagerMetrics() throws Exception {
        TableName TABLENAME = TableName.valueOf((String)this.name.getMethodName());
        byte[] FAMILY = Bytes.toBytes((String)"family");
        try (Table table = TEST_UTIL.createTable(TABLENAME, FAMILY);){
            byte[] row = Bytes.toBytes((String)"row");
            byte[] qualifier = Bytes.toBytes((String)"qualifier");
            byte[] value = Bytes.toBytes((String)"value");
            Put put = new Put(row);
            put.addColumn(FAMILY, qualifier, value);
            table.put(put);
            Thread.sleep(3000L);
            MetricsAssignmentManagerSource amSource = MASTER.getAssignmentManager().getAssignmentManagerMetrics().getMetricsProcSource();
            METRICS_HELPER.assertGauge("ritCount", 0L, (BaseSource)amSource);
            METRICS_HELPER.assertGauge("ritCountOverThreshold", 0L, (BaseSource)amSource);
            TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TABLENAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"com.foo.FooRegionObserver").setJarPath("hdfs:///foo.jar").setPriority(1001).setProperty("arg1", "1").setProperty("arg2", "2").build()).build();
            try {
                TEST_UTIL.getAdmin().modifyTable(htd);
                Assert.fail((String)"Expected region failed to open");
            }
            catch (IOException e) {
                LOG.info("Expected error", (Throwable)e);
            }
            TEST_UTIL.waitUntilNoRegionsInTransition();
            Thread.sleep(5000L);
            METRICS_HELPER.assertGauge("ritCount", 1L, (BaseSource)amSource);
            METRICS_HELPER.assertGauge("ritCountOverThreshold", 1L, (BaseSource)amSource);
            METRICS_HELPER.assertCounter("assignSubmittedCount", 3L, (BaseSource)amSource);
        }
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
    }
}

