/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HalfStoreFileReader
extends StoreFileReader {
    private static final Logger LOG = LoggerFactory.getLogger(HalfStoreFileReader.class);
    final boolean top;
    protected final byte[] splitkey;
    private final Cell splitCell;
    private Optional<Cell> firstKey = Optional.empty();
    private boolean firstKeySeeked = false;

    public HalfStoreFileReader(FileSystem fs, Path p, CacheConfig cacheConf, Reference r, boolean isPrimaryReplicaStoreFile, AtomicInteger refCount, boolean shared, Configuration conf) throws IOException {
        super(fs, p, cacheConf, isPrimaryReplicaStoreFile, refCount, shared, conf);
        this.splitkey = r.getSplitKey();
        this.splitCell = new KeyValue.KeyOnlyKeyValue(this.splitkey, 0, this.splitkey.length);
        this.top = Reference.isTopFileRegion(r.getFileRegion());
    }

    public HalfStoreFileReader(FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, boolean isPrimaryReplicaStoreFile, AtomicInteger refCount, boolean shared, Configuration conf) throws IOException {
        super(fs, p, in, size, cacheConf, isPrimaryReplicaStoreFile, refCount, shared, conf);
        this.splitkey = r.getSplitKey();
        this.splitCell = new KeyValue.KeyOnlyKeyValue(this.splitkey, 0, this.splitkey.length);
        this.top = Reference.isTopFileRegion(r.getFileRegion());
    }

    protected boolean isTop() {
        return this.top;
    }

    @Override
    public HFileScanner getScanner(boolean cacheBlocks, boolean pread, boolean isCompaction) {
        final HFileScanner s = super.getScanner(cacheBlocks, pread, isCompaction);
        return new HFileScanner(){
            final HFileScanner delegate;
            public boolean atEnd;
            {
                this.delegate = s;
                this.atEnd = false;
            }

            @Override
            public Cell getKey() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getKey();
            }

            @Override
            public String getKeyString() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getKeyString();
            }

            @Override
            public ByteBuffer getValue() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getValue();
            }

            @Override
            public String getValueString() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getValueString();
            }

            @Override
            public Cell getCell() {
                if (this.atEnd) {
                    return null;
                }
                return this.delegate.getCell();
            }

            @Override
            public boolean next() throws IOException {
                if (this.atEnd) {
                    return false;
                }
                boolean b = this.delegate.next();
                if (!b) {
                    return b;
                }
                if (!HalfStoreFileReader.this.top && HalfStoreFileReader.this.getComparator().compare(HalfStoreFileReader.this.splitCell, this.getKey()) <= 0) {
                    this.atEnd = true;
                    return false;
                }
                return true;
            }

            @Override
            public boolean seekTo() throws IOException {
                if (HalfStoreFileReader.this.top) {
                    int r = this.delegate.seekTo(HalfStoreFileReader.this.splitCell);
                    if (r == -2) {
                        return true;
                    }
                    if (r < 0) {
                        return this.delegate.seekTo();
                    }
                    if (r > 0) {
                        return this.delegate.next();
                    }
                    return true;
                }
                boolean b = this.delegate.seekTo();
                if (!b) {
                    return b;
                }
                return this.delegate.getReader().getComparator().compare(HalfStoreFileReader.this.splitCell, this.getKey()) > 0;
            }

            @Override
            public HFile.Reader getReader() {
                return this.delegate.getReader();
            }

            @Override
            public boolean isSeeked() {
                return this.delegate.isSeeked();
            }

            @Override
            public int seekTo(Cell key) throws IOException {
                if (HalfStoreFileReader.this.top) {
                    if (PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)HalfStoreFileReader.this.getComparator(), (Cell)key, (Cell)HalfStoreFileReader.this.splitCell) < 0) {
                        return -1;
                    }
                } else if (PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)HalfStoreFileReader.this.getComparator(), (Cell)key, (Cell)HalfStoreFileReader.this.splitCell) >= 0) {
                    boolean res = this.delegate.seekBefore(HalfStoreFileReader.this.splitCell);
                    if (!res) {
                        throw new IOException("Seeking for a key in bottom of file, but key exists in top of file, failed on seekBefore(midkey)");
                    }
                    return 1;
                }
                return this.delegate.seekTo(key);
            }

            @Override
            public int reseekTo(Cell key) throws IOException {
                if (HalfStoreFileReader.this.top) {
                    if (PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)HalfStoreFileReader.this.getComparator(), (Cell)key, (Cell)HalfStoreFileReader.this.splitCell) < 0) {
                        return -1;
                    }
                } else if (PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)HalfStoreFileReader.this.getComparator(), (Cell)key, (Cell)HalfStoreFileReader.this.splitCell) >= 0) {
                    boolean res = this.delegate.seekBefore(HalfStoreFileReader.this.splitCell);
                    if (!res) {
                        throw new IOException("Seeking for a key in bottom of file, but key exists in top of file, failed on seekBefore(midkey)");
                    }
                    return 1;
                }
                if (this.atEnd) {
                    return 1;
                }
                return this.delegate.reseekTo(key);
            }

            @Override
            public boolean seekBefore(Cell key) throws IOException {
                boolean ret;
                if (HalfStoreFileReader.this.top) {
                    Optional<Cell> fk = HalfStoreFileReader.this.getFirstKey();
                    if (fk.isPresent() && PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)HalfStoreFileReader.this.getComparator(), (Cell)key, (Cell)fk.get()) <= 0) {
                        return false;
                    }
                } else if (PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)HalfStoreFileReader.this.getComparator(), (Cell)key, (Cell)HalfStoreFileReader.this.splitCell) >= 0) {
                    boolean ret2 = this.delegate.seekBefore(HalfStoreFileReader.this.splitCell);
                    if (ret2) {
                        this.atEnd = false;
                    }
                    return ret2;
                }
                if (ret = this.delegate.seekBefore(key)) {
                    this.atEnd = false;
                }
                return ret;
            }

            @Override
            public Cell getNextIndexedKey() {
                return null;
            }

            @Override
            public void close() {
                this.delegate.close();
            }

            @Override
            public void shipped() throws IOException {
                this.delegate.shipped();
            }
        };
    }

    @Override
    public boolean passesKeyRangeFilter(Scan scan) {
        return true;
    }

    @Override
    public Optional<Cell> getLastKey() {
        if (this.top) {
            return super.getLastKey();
        }
        try (HFileScanner scanner = this.getScanner(true, true);){
            if (scanner.seekBefore(this.splitCell)) {
                Optional<Cell> optional = Optional.ofNullable(scanner.getKey());
                return optional;
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Cell> midKey() throws IOException {
        return Optional.empty();
    }

    @Override
    public Optional<Cell> getFirstKey() {
        if (!this.firstKeySeeked) {
            try (HFileScanner scanner = this.getScanner(true, true, false);){
                if (scanner.seekTo()) {
                    this.firstKey = Optional.ofNullable(scanner.getKey());
                }
                this.firstKeySeeked = true;
            }
        }
        return this.firstKey;
    }

    @Override
    public long getEntries() {
        return super.getEntries() / 2L;
    }

    @Override
    public long getFilterEntries() {
        return super.getFilterEntries() / 2L;
    }
}

