/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.util.Iterator;
import org.apache.hadoop.hive.ql.exec.spark.HiveMapFunctionResultList;
import org.apache.hadoop.hive.ql.exec.spark.HivePairFlatMapFunction;
import org.apache.hadoop.hive.ql.exec.spark.SparkMapRecordHandler;
import org.apache.hadoop.hive.ql.exec.spark.SparkMergeFileRecordHandler;
import org.apache.hadoop.hive.ql.exec.spark.SparkRecordHandler;
import org.apache.hadoop.hive.ql.exec.spark.SparkReporter;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.io.merge.MergeFileMapper;
import org.apache.hadoop.io.BytesWritable;
import scala.Tuple2;

public class HiveMapFunction
extends HivePairFlatMapFunction<Iterator<Tuple2<BytesWritable, BytesWritable>>, HiveKey, BytesWritable> {
    private static final long serialVersionUID = 1L;

    public HiveMapFunction(byte[] jobConfBuffer, SparkReporter sparkReporter) {
        super(jobConfBuffer, sparkReporter);
    }

    public Iterator<Tuple2<HiveKey, BytesWritable>> call(Iterator<Tuple2<BytesWritable, BytesWritable>> it) throws Exception {
        this.initJobConf();
        SparkRecordHandler mapRecordHandler = MergeFileMapper.class.getName().equals(this.jobConf.get("mapred.mapper.class")) ? new SparkMergeFileRecordHandler() : new SparkMapRecordHandler();
        HiveMapFunctionResultList result = new HiveMapFunctionResultList(it, mapRecordHandler);
        mapRecordHandler.init(this.jobConf, result, this.sparkReporter);
        return result;
    }

    @Override
    protected boolean isMap() {
        return true;
    }
}

