/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.jndi.ContextFactory;
import org.eclipse.jetty.jndi.NamingContext;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.jndi.local.localContextRoot;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class EnvConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(EnvConfiguration.class);
    private static final String JETTY_ENV_BINDINGS = "org.eclipse.jetty.jndi.EnvConfiguration";
    private URL jettyEnvXmlUrl;

    public void setJettyEnvXml(URL url) {
        this.jettyEnvXmlUrl = url;
    }

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        this.createEnvContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(WebAppContext context) throws Exception {
        Resource jettyEnv;
        Resource web_inf;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created java:comp/env for webapp " + context.getContextPath(), new Object[0]);
        }
        if (this.jettyEnvXmlUrl == null && (web_inf = context.getWebInf()) != null && web_inf.isDirectory() && (jettyEnv = web_inf.addPath("jetty-env.xml")).exists()) {
            this.jettyEnvXmlUrl = jettyEnv.getURL();
        }
        if (this.jettyEnvXmlUrl != null) {
            NamingContext namingContext = localContextRoot.getRoot();
            synchronized (namingContext) {
                final ArrayList bindings = new ArrayList();
                NamingContext.Listener listener = new NamingContext.Listener(){

                    @Override
                    public void unbind(NamingContext ctx, Binding binding) {
                    }

                    @Override
                    public Binding bind(NamingContext ctx, Binding binding) {
                        bindings.add(new Bound(ctx, binding.getName()));
                        return binding;
                    }
                };
                try {
                    localContextRoot.getRoot().addListener(listener);
                    XmlConfiguration configuration = new XmlConfiguration(this.jettyEnvXmlUrl);
                    configuration.setJettyStandardIdsAndProperties(context.getServer(), null);
                    WebAppClassLoader.runWithServerClassAccess(() -> {
                        configuration.configure(context);
                        return null;
                    });
                }
                finally {
                    localContextRoot.getRoot().removeListener(listener);
                    context.setAttribute(JETTY_ENV_BINDINGS, bindings);
                }
            }
        }
        this.bindEnvEntries(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(context.getClassLoader());
        ContextFactory.associateClassLoader(context.getClassLoader());
        try {
            InitialContext ic = new InitialContext();
            Context compCtx = (Context)ic.lookup("java:comp");
            compCtx.destroySubcontext("env");
            List bindings = (List)context.getAttribute(JETTY_ENV_BINDINGS);
            context.setAttribute(JETTY_ENV_BINDINGS, null);
            if (bindings != null) {
                Collections.reverse(bindings);
                for (Bound b : bindings) {
                    b._context.destroySubcontext(b._name);
                }
            }
        }
        catch (NameNotFoundException e) {
            LOG.warn(e);
        }
        finally {
            ContextFactory.disassociateClassLoader();
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    @Override
    public void destroy(WebAppContext context) throws Exception {
        try {
            NamingContext scopeContext = (NamingContext)NamingEntryUtil.getContextForScope(context);
            scopeContext.getParent().destroySubcontext(scopeContext.getName());
        }
        catch (NameNotFoundException e) {
            LOG.ignore(e);
            LOG.debug("No jndi entries scoped to webapp {}", context);
        }
        catch (NamingException e) {
            LOG.debug("Error unbinding jndi entries scoped to webapp " + context, e);
        }
    }

    public void bindEnvEntries(WebAppContext context) throws NamingException {
        Name namingEntryName;
        LOG.debug("Binding env entries from the jvm scope", new Object[0]);
        InitialContext ic = new InitialContext();
        Context envCtx = (Context)ic.lookup("java:comp/env");
        HandlerWrapper scope = null;
        List<Object> list = NamingEntryUtil.lookupNamingEntries(scope, EnvEntry.class);
        for (EnvEntry envEntry : list) {
            envEntry.bindToENC(envEntry.getJndiName());
            namingEntryName = NamingEntryUtil.makeNamingEntryName(null, envEntry);
            NamingUtil.bind(envCtx, namingEntryName.toString(), envEntry);
        }
        LOG.debug("Binding env entries from the server scope", new Object[0]);
        scope = context.getServer();
        list = NamingEntryUtil.lookupNamingEntries(scope, EnvEntry.class);
        for (EnvEntry envEntry : list) {
            envEntry.bindToENC(envEntry.getJndiName());
            namingEntryName = NamingEntryUtil.makeNamingEntryName(null, envEntry);
            NamingUtil.bind(envCtx, namingEntryName.toString(), envEntry);
        }
        LOG.debug("Binding env entries from the context scope", new Object[0]);
        scope = context;
        list = NamingEntryUtil.lookupNamingEntries(scope, EnvEntry.class);
        for (EnvEntry envEntry : list) {
            envEntry.bindToENC(envEntry.getJndiName());
            namingEntryName = NamingEntryUtil.makeNamingEntryName(null, envEntry);
            NamingUtil.bind(envCtx, namingEntryName.toString(), envEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createEnvContext(WebAppContext wac) throws NamingException {
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        ContextFactory.associateClassLoader(wac.getClassLoader());
        try {
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.createSubcontext("env");
        }
        finally {
            ContextFactory.disassociateClassLoader();
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }

    private static class Bound {
        final NamingContext _context;
        final String _name;

        Bound(NamingContext context, String name) {
            this._context = context;
            this._name = name;
        }
    }
}

