/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public abstract class AbstractObjectParser<Value, Context> {
    protected AbstractObjectParser() {
    }

    public abstract <T> void declareField(BiConsumer<Value, T> var1, ContextParser<Context, T> var2, ParseField var3, ObjectParser.ValueType var4);

    public abstract <T> void declareNamedObject(BiConsumer<Value, T> var1, ObjectParser.NamedObjectParser<T, Context> var2, ParseField var3);

    public abstract <T> void declareNamedObjects(BiConsumer<Value, List<T>> var1, ObjectParser.NamedObjectParser<T, Context> var2, ParseField var3);

    public abstract <T> void declareNamedObjects(BiConsumer<Value, List<T>> var1, ObjectParser.NamedObjectParser<T, Context> var2, Consumer<Value> var3, ParseField var4);

    public abstract String getName();

    public <T> void declareField(BiConsumer<Value, T> consumer, CheckedFunction<XContentParser, T, IOException> parser, ParseField parseField, ObjectParser.ValueType type) {
        if (parser == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        this.declareField(consumer, (XContentParser p, Context c) -> parser.apply((Object)p), parseField, type);
    }

    public <T> void declareObject(BiConsumer<Value, T> consumer, ContextParser<Context, T> objectParser, ParseField field) {
        this.declareField(consumer, objectParser, field, ObjectParser.ValueType.OBJECT);
    }

    public <T> void declareObjectOrNull(BiConsumer<Value, T> consumer, ContextParser<Context, T> objectParser, T nullValue, ParseField field) {
        this.declareField(consumer, (XContentParser p, Context c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? nullValue : objectParser.parse(p, c), field, ObjectParser.ValueType.OBJECT_OR_NULL);
    }

    public void declareFloat(BiConsumer<Value, Float> consumer, ParseField field) {
        this.declareField(consumer, p -> Float.valueOf(p.floatValue()), field, ObjectParser.ValueType.FLOAT);
    }

    public void declareFloatOrNull(BiConsumer<Value, Float> consumer, float nullValue, ParseField field) {
        this.declareField(consumer, p -> Float.valueOf(p.currentToken() == XContentParser.Token.VALUE_NULL ? nullValue : p.floatValue()), field, ObjectParser.ValueType.FLOAT_OR_NULL);
    }

    public void declareDouble(BiConsumer<Value, Double> consumer, ParseField field) {
        this.declareField(consumer, p -> p.doubleValue(), field, ObjectParser.ValueType.DOUBLE);
    }

    public void declareDoubleOrNull(BiConsumer<Value, Double> consumer, double nullValue, ParseField field) {
        this.declareField(consumer, p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? nullValue : p.doubleValue(), field, ObjectParser.ValueType.DOUBLE_OR_NULL);
    }

    public void declareLong(BiConsumer<Value, Long> consumer, ParseField field) {
        this.declareField(consumer, p -> p.longValue(), field, ObjectParser.ValueType.LONG);
    }

    public void declareLongOrNull(BiConsumer<Value, Long> consumer, long nullValue, ParseField field) {
        this.declareField(consumer, p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? nullValue : p.longValue(), field, ObjectParser.ValueType.LONG_OR_NULL);
    }

    public void declareInt(BiConsumer<Value, Integer> consumer, ParseField field) {
        this.declareField(consumer, p -> p.intValue(), field, ObjectParser.ValueType.INT);
    }

    public void declareIntOrNull(BiConsumer<Value, Integer> consumer, int nullValue, ParseField field) {
        this.declareField(consumer, p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? nullValue : p.intValue(), field, ObjectParser.ValueType.INT_OR_NULL);
    }

    public void declareString(BiConsumer<Value, String> consumer, ParseField field) {
        this.declareField(consumer, XContentParser::text, field, ObjectParser.ValueType.STRING);
    }

    public <T> void declareString(BiConsumer<Value, T> consumer, Function<String, T> fromStringFunction, ParseField field) {
        this.declareField(consumer, p -> fromStringFunction.apply(p.text()), field, ObjectParser.ValueType.STRING);
    }

    public void declareStringOrNull(BiConsumer<Value, String> consumer, ParseField field) {
        this.declareField(consumer, p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : p.text(), field, ObjectParser.ValueType.STRING_OR_NULL);
    }

    public void declareBoolean(BiConsumer<Value, Boolean> consumer, ParseField field) {
        this.declareField(consumer, XContentParser::booleanValue, field, ObjectParser.ValueType.BOOLEAN);
    }

    public <T> void declareObjectArray(BiConsumer<Value, List<T>> consumer, ContextParser<Context, T> objectParser, ParseField field) {
        this.declareFieldArray(consumer, objectParser, field, ObjectParser.ValueType.OBJECT_ARRAY);
    }

    public <T> void declareObjectArrayOrNull(BiConsumer<Value, List<T>> consumer, ContextParser<Context, T> objectParser, ParseField field) {
        this.declareField((Value value, T list) -> {
            if (list != null) {
                consumer.accept((Object)value, (List)list);
            }
        }, (XContentParser p, Context c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : AbstractObjectParser.parseArray(p, c, objectParser), field, ObjectParser.ValueType.OBJECT_ARRAY_OR_NULL);
    }

    public void declareStringArray(BiConsumer<Value, List<String>> consumer, ParseField field) {
        this.declareFieldArray(consumer, (p, c) -> p.text(), field, ObjectParser.ValueType.STRING_ARRAY);
    }

    public void declareDoubleArray(BiConsumer<Value, List<Double>> consumer, ParseField field) {
        this.declareFieldArray(consumer, (p, c) -> p.doubleValue(), field, ObjectParser.ValueType.DOUBLE_ARRAY);
    }

    public void declareFloatArray(BiConsumer<Value, List<Float>> consumer, ParseField field) {
        this.declareFieldArray(consumer, (p, c) -> Float.valueOf(p.floatValue()), field, ObjectParser.ValueType.FLOAT_ARRAY);
    }

    public void declareLongArray(BiConsumer<Value, List<Long>> consumer, ParseField field) {
        this.declareFieldArray(consumer, (p, c) -> p.longValue(), field, ObjectParser.ValueType.LONG_ARRAY);
    }

    public void declareIntArray(BiConsumer<Value, List<Integer>> consumer, ParseField field) {
        this.declareFieldArray(consumer, (p, c) -> p.intValue(), field, ObjectParser.ValueType.INT_ARRAY);
    }

    public <T> void declareFieldArray(BiConsumer<Value, List<T>> consumer, ContextParser<Context, T> itemParser, ParseField field, ObjectParser.ValueType type) {
        this.declareField(consumer, (XContentParser p, Context c) -> AbstractObjectParser.parseArray(p, c, itemParser), field, type);
    }

    public abstract void declareRequiredFieldSet(String ... var1);

    public abstract void declareExclusiveFieldSet(String ... var1);

    public static <T, Context> List<T> parseArray(XContentParser parser, Context context, ContextParser<Context, T> itemParser) throws IOException {
        XContentParser.Token token;
        XContentParser.Token currentToken = parser.currentToken();
        if (currentToken.isValue() || currentToken == XContentParser.Token.VALUE_NULL || currentToken == XContentParser.Token.START_OBJECT) {
            return Collections.singletonList(itemParser.parse(parser, context));
        }
        ArrayList<T> list = new ArrayList<T>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token.isValue() || token == XContentParser.Token.VALUE_NULL || token == XContentParser.Token.START_OBJECT) {
                list.add(itemParser.parse(parser, context));
                continue;
            }
            throw new IllegalStateException("expected value but got [" + token + "]");
        }
        return list;
    }
}

