/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.util.HashMap;
import org.hibernate.search.test.DefaultTestResourceManager;
import org.hibernate.search.test.TestResourceManager;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.junit.After;

public abstract class SearchInitializationTestBase {
    private DefaultTestResourceManager testResourceManager;

    protected void init(TestConfiguration configuration) {
        if (this.testResourceManager == null) {
            this.testResourceManager = new DefaultTestResourceManager(configuration, this.getClass());
        }
        this.testResourceManager.openSessionFactory();
    }

    protected void init(Class<?> ... annotatedClasses) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        this.init(new ImmutableTestConfiguration(settings, annotatedClasses));
    }

    protected TestResourceManager getTestResourceManager() {
        return this.testResourceManager;
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.testResourceManager != null) {
                this.testResourceManager.defaultTearDown();
            }
        }
        finally {
            this.testResourceManager = null;
        }
    }
}

