/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.search.Search;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.test.SearchTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class CheckCustomFieldDefaultAnalyzer
extends SearchTestBase {
    @Before
    public void before() throws Exception {
        try (Session session = this.openSession();){
            session.beginTransaction();
            session.persist(this.entity());
            session.getTransaction().commit();
        }
    }

    private Object entity() {
        return this.entity("GLaDOS", "CHELL", "WELL DONE. HERE COME THE TEST RESULTS: 'YOU ARE A HORRIBLE PERSON.");
    }

    protected abstract Object entity(String var1, String var2, String var3);

    protected abstract Class<?> getEntityType();

    @After
    public void after() throws Exception {
        try (Session session = this.openSession();){
            session.beginTransaction();
            session.delete(this.entity());
            session.getTransaction().commit();
        }
    }

    @Test
    public void shouldBeAbleToFindTheCustomIdField() throws Exception {
        try (Session session = this.openSession();){
            session.beginTransaction();
            TermQuery termQuery = new TermQuery(new Term("copy_of_id", "GLaDOS"));
            Object result = Search.getFullTextSession((Session)session).createFullTextQuery((Query)termQuery, new Class[]{this.getEntityType()}).uniqueResult();
            Assertions.assertThat((Object)result).isEqualTo(this.entity());
            session.getTransaction().commit();
        }
    }

    @Test
    public void shouldNotAnalyzeCustomIdField() throws Exception {
        try (Session session = this.openSession();){
            session.beginTransaction();
            TermQuery termQuery = new TermQuery(new Term("copy_of_id", "glados"));
            Object result = Search.getFullTextSession((Session)session).createFullTextQuery((Query)termQuery, new Class[]{this.getEntityType()}).uniqueResult();
            Assertions.assertThat((Object)result).isNull();
            session.getTransaction().commit();
        }
    }

    @Test
    public void shouldBeAbleToFindNotAnalyzedCustomField() throws Exception {
        try (Session session = this.openSession();){
            session.beginTransaction();
            TermQuery termQuery = new TermQuery(new Term("copy_of_subject", "CHELL"));
            Object result = Search.getFullTextSession((Session)session).createFullTextQuery((Query)termQuery, new Class[]{this.getEntityType()}).uniqueResult();
            Assertions.assertThat((Object)result).isEqualTo(this.entity());
            session.getTransaction().commit();
        }
    }

    @Test
    public void shouldNotAnalyzeCustomField() throws Exception {
        try (Session session = this.openSession();){
            session.beginTransaction();
            TermQuery termQuery = new TermQuery(new Term("copy_of_subject", "chell"));
            Object result = Search.getFullTextSession((Session)session).createFullTextQuery((Query)termQuery, new Class[]{this.getEntityType()}).uniqueResult();
            Assertions.assertThat((Object)result).isNull();
            session.getTransaction().commit();
        }
    }

    @Test
    public void shouldBeAbleToFindAnalyzedAnnotatedField() throws Exception {
        try (Session session = this.openSession();){
            session.beginTransaction();
            TermQuery termQuery = new TermQuery(new Term("result", "HORRIBLE"));
            Object result = Search.getFullTextSession((Session)session).createFullTextQuery((Query)termQuery, new Class[]{this.getEntityType()}).uniqueResult();
            Assertions.assertThat((Object)result).isEqualTo(this.entity());
            session.getTransaction().commit();
        }
    }

    @Test
    public void shouldNotBeAbleToFindAnalyzedCustomField() throws Exception {
        try (Session session = this.openSession();){
            session.beginTransaction();
            TermQuery termQuery = new TermQuery(new Term("copy_of_result", "HORRIBLE"));
            Object result = Search.getFullTextSession((Session)session).createFullTextQuery((Query)termQuery, new Class[]{this.getEntityType()}).uniqueResult();
            Assertions.assertThat((Object)result).isNull();
            session.getTransaction().commit();
        }
    }

    @Test
    public void shouldBeAbleToFindAnalyzedCustomField() throws Exception {
        try (Session session = this.openSession();){
            session.beginTransaction();
            TermQuery termQuery = new TermQuery(new Term("copy_of_result", "horrible"));
            Object result = Search.getFullTextSession((Session)session).createFullTextQuery((Query)termQuery, new Class[]{this.getEntityType()}).uniqueResult();
            Assertions.assertThat((Object)result).isEqualTo(this.entity());
            session.getTransaction().commit();
        }
    }

    public static class AdditionalFieldBridge
    implements MetadataProvidingFieldBridge,
    TwoWayFieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            luceneOptions.addFieldToDocument(name, (String)value, document);
            luceneOptions.addFieldToDocument(this.copyOf(name), (String)value, document);
        }

        private String copyOf(String name) {
            return "copy_of_" + name;
        }

        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field(this.copyOf(name), FieldType.STRING);
        }

        public Object get(String name, Document document) {
            return document.get(name);
        }

        public String objectToString(Object object) {
            return (String)object;
        }
    }
}

